/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.nvram;

import com.ibm.hsc.cim.provider.pi.PIVirtualEthernetMACAddressUtils;
import com.ibm.hsc.common.exceptions.PIHscBaseException;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspCecTime;
import com.ibm.hsc.fsp.cmdhelpers.FspFileOpenResponse;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Adler32;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PIHMCSaveArea {
    private DataInputStream m_responseData;
    public static final int MANUFACTORY_GENESIS_MODE = 0;
    public static final int NON_MANUFACTORY_GENESIS_MODE = 1;
    public static final String SAVE_AREA_FORMAT = "save_area_format";
    public static final String PI_HMC_SAVE_AREA_FORMAT_FILE = "/opt/hsc/data/SaveAreaFormat.xml";
    static final short DLPAR_BIT = 16;
    static final short SIZE_OF_LONG = 8;
    static final short SIZE_OF_INT = 4;
    static final short SIZE_OF_SHORT = 2;
    static final short SIZE_OF_BYTE = 1;
    static final short NUM_BITS_PER_BYTE = 8;
    static final short SIZE_OF_TIMESTAMP = 11;
    final short SIZE_OF_ENCODED_TIME_STAMP = (short)5;
    final short LENGTH_OF_NAME = (short)32;
    final short LENGTH_OF_PROFILE_NAME = (short)32;
    final short LENGTH_OF_LPAR_NAME = (short)48;
    final short LENGTH_OF_FAST_ACT_LPAR_NAME = (short)47;
    static final short SIZE_OF_CHECKSUM = 8;
    static final int LENGTH_OF_VLAN_MAC_ADDR_PREFIX = 3;
    public static Vector FSP_VERSIONS = new Vector();
    public static Vector FSP_HMC_VERSIONS = new Vector();
    public static Vector NVRAM_VERSIONS = new Vector();
    public static Vector HMC_TEMPLATE_VERSIONS = new Vector();
    public static Vector HMC_PROFILE_TEMPLATE_VERSIONS = new Vector();
    final short SIZE_OF_PACKAGE = (short)1000;
    final short SIZE_OF_LPAR_TYPE = 1;
    short SIZE_OF_LPAR_INFO = (short)49;
    int SIZE_OF_TAGGED_IO_INFO_VECTOR = 5;
    final short SYS_PROFILE = 1;
    short MAX_PROFILE = (short)130;
    public int NVRAM_SIZE;
    short NUM_PARTITION_SLOTS;
    final int PROFILE_NAME_TABLE_CHANGE = 1;
    final int DEFAULT_LIST_CHANGE = 2;
    final int ACTIVATED_LIST_CHANGE = 4;
    final int PROFILE_INFO_CHANGE = 8;
    final int PARTITION_TABLE_CHANGE = 16;
    int CORRUPTED_BYTE_OFFSET = 0;
    int HMC_SAVE_AREA_BEGINNING_OFFSET = 0;
    int HMC_SAVE_AREA_TEMPLATE_VERSION_OFFSET;
    int NUM_ALPAR_SLOTS_OFFSET;
    int NUM_PARTITION_SLOTS_OFFSET;
    int VALIDATION_CHECKSUM_OFFSET;
    int TIME_STAMPS_CHECKSUM_OFFSET;
    int TIMESTAMPS_CHECKSUM_OFFSET;
    int NVRAM_TIME_STAMP_OFFSET;
    int NVRAM_TIMESTAMP_OFFSET;
    private static final String BASIC_INFO_CHECKSUM = "basic_info_checksum";
    private static final String BASIC_INFO_LENGTH = "basic_info_length";
    private static final String SAVE_AREA_TEMPLATE_VERSION = "save_area_template_version";
    private static final String VIRTUAL_ETHERNET_MAC_ADDR_PREFIX = "veth_mac_prefix";
    private static final String SYS_CREDENTIAL_USER_ID = "sys_cred_user_id";
    private static final String SYS_CREDENTIAL_PASSWORD = "sys_cred_password";
    private static final String SAVE_AREA_SECTIONS = "save_area_sections";
    private static final String TIMESTAMP_INFO_CHECKSUM = "timestamp_info_checksum";
    private static final String TIMESTAMP_INFO_TEMPLATE_VERSION = "timestamp_info_template_version";
    private static final String TIMESTAMP_INFO_LENGTH = "timestamp_info_length";
    private static final String GLOBAL_TIMESTAMP = "global_timestamp";
    private static final String LAST_MODIFIED_PARTITION_TABLE_TIMESTAMP = "last_modified_partition_table_timestamp";
    private static final String PRIOR_MODIFIED_PARTITION_TABLE_TIMESTAMP = "prior_modified_partition_table_timestamp";
    private static final String MODIFIED_PARTITION_TABLE_STARTING_OFFSET = "modified_partition_table_starting_offset";
    private static final String MODIFIED_PARTITION_TABLE_LEN = "modified_partition_table_len";
    private static final String LAST_MODIFIED_DEFAULT_PROF_TABLE_TIMESTAMP = "last_modified_default_prof_table_timestamp";
    private static final String PRIOR_MODIFIED_DEFAULT_PROF_TABLE_TIMESTAMP = "prior_modified_default_prof_table_timestamp";
    private static final String MODIFIED_DEFAULT_PROF_TABLE_STARTING_OFFSET = "modified_default_prof_table_starting_offset";
    private static final String MODIFIED_DEFAULT_PROF_TABLE_LEN = "modified_default_prof_table_len";
    private static final String LAST_MODIFIED_ACTIVATED_PROF_TABLE_TIMESTAMP = "last_modified_activated_prof_table_timestamp";
    private static final String PRIOR_MODIFIED_ACTIVATED_PROF_TABLE_TIMESTAMP = "prior_modified_activated_prof_table_timestamp";
    private static final String MODIFIED_ACTIVATED_PROF_TABLE_STARTING_OFFSET = "modified_activated_prof_table_starting_offset";
    private static final String MODIFIED_ACTIVATED_PROF_TABLE_LEN = "modified_activated_prof_table_len";
    private static final String LAST_MODIFIED_PROFILE_INFO_TIMESTAMP = "last_modified_profile_info_timestamp";
    private static final String PRIOR_MODIFIED_PROFILE_INFO_TIMESTAMP = "prior_modified_profile_info_timestamp";
    private static final String MODIFIED_PROFILE_INFO_STARTING_OFFSET = "modified_profile_info_starting_offset";
    private static final String MODIFIED_PROFILE_INFO_LEN = "modified_profile_info_len";
    private static final String PARTITION_TABLE_CHECKSUM = "partition_table_checksum";
    private static final String PARTITION_TABLE_LENGTH = "partition_table_length";
    private static final String PARTITION_TABLE_TEMPLATE_VERSION = "partition_table_template_version";
    private static final String NUM_PARTITIONS = "num_partitions";
    private static final String VERSION_BASED_PARTITION_TABLE_DATA = "version_based_partition_table_data";
    private static final String DEFAULT_PROF_TABLE_CHECKSUM = "default_prof_table_checksum";
    private static final String DEFAULT_PROF_TABLE_LENGTH = "default_prof_table_length";
    private static final String DEFAULT_PROF_TABLE_TEMPLATE_VERSION = "default_prof_table_template_version";
    private static final String DEFAULT_PROF_TABLE = "default_prof_table";
    private static final String ACTIVATED_PROF_TABLE_CHECKSUM = "activated_prof_table_checksum";
    private static final String ACTIVATED_PROF_TABLE_LENGTH = "activated_prof_table_length";
    private static final String ACTIVATED_PROF_TABLE_TEMPLATE_VERSION = "activated_prof_table_template_version";
    private static final String ACTIVATED_PROF_TABLE = "activated_prof_table";
    private static final String PROFILE_INFO_CHECKSUM = "profile_info_checksum";
    private static final String PROFILE_INFO_DATA_SIZE = "profile_info_data_size";
    private static final String PROFILE_INFO_TEMPLATE_VERSION = "profile_info_template_version";
    private static final String VERSION_BASED_PROFILE_INFO_DATA = "version_based_profile_info_data";
    private static final String NEXT_AVAILABLE_SEQUENCE_NUMBER = "next_available_sequence_number";
    private static final String PARTITION_NAME = "partition_name";
    private static final String PARTITION_TYPE = "partition_type";
    private static final String PARTITION_EWLM_GROUP_ID = "partition_ewlm_group_id";
    private static final String LEN = "len";
    private static final String TEMPLATE_VERSION = "template_version";
    private static final String PROF_ID = "prof_id";
    private static final String PROF_NAME = "prof_name";
    private static final String VERSION_BASED_PARTITION_TABLE_DATA_0 = "version_based_partition_table_data_0";
    private static final String VERSION_BASED_PARTITION_TABLE_DATA_1 = "version_based_partition_table_data_1";
    private static final String PARTITION_ID = "partition_id";
    private static final int SYS_PROFILE_TEMPLATE_VERSION_BASE = 0;
    private static final int FSPM_PROFILE_TEMPLATE_VERSION_BASE = 50;
    private static final int LPAR_PROFILE_TEMPLATE_VERSION_BASE = 100;
    private static final short INVALID_PROFILE = 255;
    private static final int SAVE_AREA_PARSE = 0;
    private static final int SYS_PROFILE_PARSE = 1;
    private static final int LPAR_PROFILE_PARSE = 2;
    private static final int FSPM_PROFILE_PARSE = 3;
    private Hashtable _dataTypeSizeTable = null;
    private int _nextAvailProfileSequenceID = 1;
    private static final int VERSION_BASED_PARTITION_TABLE_DATA_0_LENGTH = 49;
    private static final int VERSION_BASED_PARTITION_TABLE_DATA_1_LENGTH = 49;
    private Document saveAreaFormatDoc = null;
    private Vector saveAreaElementSequence = new Vector();
    private Vector sysProfileElementSequence = new Vector();
    private Vector fspmProfileElementSequence = new Vector();
    private Vector lparProfileElementSequence = new Vector();
    private Vector tmpSubSequence = new Vector();
    private Hashtable mapTable = null;
    private Hashtable sysProfileDataTable = new Hashtable();
    private Hashtable fspmProfileDataTable = new Hashtable();
    private Hashtable lparProfileDataTable = new Hashtable();
    private Hashtable saveAreaDataTable = new Hashtable();
    private Hashtable saveAreaDataTableOffsets = new Hashtable();
    private Hashtable lparProfileDataTableOffsets = new Hashtable();
    private Hashtable sysProfileDataTableOffsets = new Hashtable();
    private Hashtable fspmProfileDataTableOffsets = new Hashtable();
    private static final int TYPE_INDEX = 0;
    private static final int OFFSET_INDEX = 1;
    private static final int ARRAY_SIZE_INDEX = 2;
    private static final int ARRAY_TYPE_INDEX = 3;
    private static final int VERSION_BASED_INFO_INDEX = 4;
    private static final int STRING_LENGTH_INDEX = 2;
    private static final int BASIC_TYPE_ID = 0;
    private static final int ARRAY_TYPE_ID = 1;
    private static final int VERSION_BASED_STRUCT_ID = 2;
    private static final int STRING_ID = 3;
    private static final int SET_ID = 4;
    private static final int CHECK_NONZERO_ID = 5;
    private static final String BASIC_TYPE = "basic_type";
    private static final String ARRAY_TYPE = "array_type";
    private static final String VERSION_BASED_STRUCT = "version_based_struct";
    private static final String STRING = "string";
    private static final String SET = "set";
    private static final String CHECK_NONZERO = "check_nonzero";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VERSION = "version";
    private static final String SIZE = "size";
    private static final String LENGTH = "length";
    private static final String VALUE = "value";
    private static final String CHECKSUM = "checksum";
    private static final String TIMESTAMP = "timestamp";
    private static final String BYTE = "byte";
    private static final String SHORT = "short";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String STRUCT = "struct";
    private static final short REQUIRED_BIT = 8;
    private static final int VBPTDATA_0_ELEMENT_LENGTH = 49;
    private static final int VBPTDATA_1_ELEMENT_LENGTH = 49;
    private static final short NON_FULL_SYSTEM_PARTITION_PROFILE = 0;
    private static final short FULL_SYSTEM_PARTITION_PROFILE = 1;
    private Object saveAreaFileSyncObj = new Object();
    private boolean isSaveAreaFileOpen = false;
    private boolean _modSinceLastRebuild = false;
    final short FIX_LPAR_PROFILE_LENGTH_R5 = (short)39;
    final short FIX_FSPM_PROFILE_LENGTH_R5 = (short)39;
    final short FIX_SYS_PROFILE_LENGTH_R5 = (short)39;
    private Hashtable _saveAreaOffsetsTable = new Hashtable();
    public static final int LPAR_INFO_USER_DEF_NAME = 0;
    public static final int LPAR_INFO_OS_TYPE = 1;
    static final byte HMC_TEMPLATE_VERSION_0 = 0;
    static final byte HMC_TEMPLATE_VERSION_1 = 1;
    static final byte HMC_TEMPLATE_VERSION_2 = 2;
    static final byte HMC_PROFILE_TEMPLATE_VERSION_0 = 0;
    static final byte HMC_PROFILE_TEMPLATE_VERSION_1 = 1;
    public static Vector FIRST_RELEASE_SECTIONS;
    public static Vector CURRENT_RELEASE_SECTIONS;
    public static final int BASIC_INFO_SECTION = 0;
    public static final int TIMESTAMP_SECTION = 1;
    public static final int PARTITION_TABLE_SECTION = 2;
    public static final int DEFAULT_PROFILE_SECTION = 3;
    public static final int ACTIVATED_PROFILE_SECTION = 4;
    public static final int PROFILE_SECTION = 5;
    static final byte FAST_ACTIVATION_OFF = 0;
    static final byte FAST_ACTIVATION_ON = 1;
    private int _nvramDataSize = 0;
    private byte[] _nvramTimestamp = new byte[11];
    private byte[] _partitionTableTimestamp = new byte[11];
    private byte[] _defaultProfTableTimestamp = new byte[11];
    private byte[] _activatedProfTableTimestamp = new byte[11];
    private byte[] _profileInfoTimestamp = new byte[11];
    private short _numDrawers = 0;
    private int[] _defaultProfTable;
    private int[] _activatedProfTable;
    private String[] _partitionNameTable;
    private boolean[] _fastActivation;
    private String[] _partitionTable;
    private short[] _partitionOSTypeTable;
    private Hashtable _profileTable;
    private Vector[] _profilesAtPartitionTable;
    private byte[] _nvramData;
    private String _zeroOutNameString = new String(new byte[32]);
    private String _zeroOutTimeStamp = new String(new byte[11]);
    private ByteArrayInputStream _nvramBAInputStream;
    private ByteArrayOutputStream _nvramBAOutputStream;
    private DataInputStream _nvramDInputStream;
    private DataOutputStream _nvramDOutputStream;
    private File _backup;
    private FileInputStream _input;
    private FileOutputStream _output;
    static final byte _hmcTemplateVersion = 0;
    static final byte _latestHmcTemplateVersion = 2;
    static final byte _hmcProfileTemplateVersion = 1;
    static final byte _latestHmcProfileTemplateVersion = 1;
    private byte _templateVersion;
    private byte _profileTemplateVersion;
    private byte _fspTemplateVersion;
    private byte _fspProfileTemplateVersion;
    static boolean DEBUG_ON;
    private Adler32 _checksumCalc = new Adler32();
    private long _checksum = 0L;
    private String _cecName;
    private byte _releaseVersion = 0;
    private byte _versionMask = (byte)-2;
    private String _fspVersion = null;
    private String _macAddrPrefix = null;
    private String _sysCredentialUserID = null;
    static final int LENGTH_OF_SYS_CREDENTIAL_USER_ID = 8;
    private String _sysCredentialPassword = null;
    static final int LENGTH_OF_SYS_CREDENTIAL_PASSWORD = 16;
    private int _releaseNumPartitionSlots = 0;
    private int _restoreType = 3;
    private long _bufferedNVRAMSize = 0L;
    private int _profileTableSize = 0;
    private boolean _cannotMergeFromModel = false;
    private boolean _cannotMergeFromAddOn = false;
    private OmCecMgr _cecMgr = null;
    private boolean _migrationOccurred = false;
    private short _basicInfoLength = (short)46;
    private short _timestampInfoLength = (short)142;
    private short _partitionTableLength = 0;
    private short _defaultProfileTableLength = 0;
    private short _activatedProfileTableLength = 0;
    private Hashtable nvramError = new Hashtable();
    private static Vector callingReg;
    private long lastCleanupTime = System.currentTimeMillis();

    private void initSaveAreaFormatTables() {
        this.mapTable = new Hashtable();
        this.mapTable.put(BASIC_TYPE, new Integer(0));
        this.mapTable.put(ARRAY_TYPE, new Integer(1));
        this.mapTable.put(VERSION_BASED_STRUCT, new Integer(2));
        this.mapTable.put(STRING, new Integer(3));
        this.mapTable.put(SET, new Integer(4));
        this.mapTable.put(CHECK_NONZERO, new Integer(5));
        this._dataTypeSizeTable = new Hashtable();
        this._dataTypeSizeTable.put(BYTE, new Integer(1));
        this._dataTypeSizeTable.put(SHORT, new Integer(2));
        this._dataTypeSizeTable.put(INT, new Integer(4));
        this._dataTypeSizeTable.put(LONG, new Integer(8));
        this._dataTypeSizeTable.put(CHECKSUM, new Integer(8));
        this._dataTypeSizeTable.put(TIMESTAMP, new Integer(11));
        this._dataTypeSizeTable.put(VERSION_BASED_STRUCT, new Integer(0));
        this._dataTypeSizeTable.put(VERSION_BASED_PARTITION_TABLE_DATA_0, new Integer(49));
        this._dataTypeSizeTable.put(VERSION_BASED_PARTITION_TABLE_DATA_1, new Integer(49));
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.saveAreaFormatDoc = documentBuilder.parse(new File(PI_HMC_SAVE_AREA_FORMAT_FILE));
        }
        catch (Throwable throwable) {
            System.out.println("got an exception " + throwable);
            throwable.printStackTrace();
        }
    }

    public static boolean nvramCheckReg() {
        Thread thread = Thread.currentThread();
        if (callingReg.indexOf(thread) != -1) {
            return false;
        }
        callingReg.addElement(thread);
        return true;
    }

    private void handleBadNVRAMError() {
        Thread thread = Thread.currentThread();
        if (callingReg.indexOf(thread) == -1) {
            return;
        }
        long l = System.currentTimeMillis();
        this.nvramError.put(thread, new Long(l));
        new Exception("report bad nvram error.").printStackTrace();
    }

    public PIHMCSaveArea(OmCecMgr omCecMgr, String string, FspLockHelper fspLockHelper) throws PIHscServerException {
        this.initSaveAreaFormatTables();
        this._cecMgr = omCecMgr;
        this._fspVersion = string;
        this._cecName = omCecMgr.getCecName();
        this.reload(fspLockHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reload(FspLockHelper fspLockHelper) throws PIHscServerException {
        block17: {
            int n = 1;
            boolean bl = false;
            if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                System.out.println("in reload:  _fspVersion is null");
                this._fspVersion = this._cecMgr.getFspVersion();
                if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                    System.out.println("in reload:  _fspVersion is still null, using version associated with HMC level");
                    this._fspVersion = "F3.0";
                }
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "_fspVersion = " + this._fspVersion);
            }
            if (DEBUG_ON) {
                System.out.println("_fspVersion = " + this._fspVersion);
            }
            try {
                try {
                    this.NVRAM_SIZE = (int)this._cecMgr.getCmdHelper().getFileSize(7, 0L);
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in PIHMCSaveArea constructor: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._init(this._cecName, fspLockHelper);
                }
                catch (Throwable throwable) {
                    n = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0008", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var8_7 = null;
                if (!bl) break block17;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _init(String string, FspLockHelper fspLockHelper) throws PIHscServerException {
        try {
            this._cecName = string;
            if (DEBUG_ON) {
                System.out.println("**********************************************");
                System.out.println("In NVRAM constructor");
                System.out.println("cecName = " + string);
            }
            Object var3_3 = null;
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            try {
                byte[] byArray;
                this.NVRAM_SIZE = (int)this._cecMgr.getCmdHelper().getFileSize(7, 0L);
                if (DEBUG_ON) {
                    System.out.println("in _init: NVRAM_SIZE = " + this.NVRAM_SIZE);
                }
                if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                    System.out.println("in _init: _fspVersion is null");
                    this._fspVersion = this._cecMgr.getFspVersion();
                    if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                        this._fspVersion = "F3.0";
                    }
                    if (DEBUG_ON) {
                        System.out.println("in _init: fspVersion = " + this._fspVersion);
                    }
                }
                System.out.println("_hmcTemplateVersion = 0");
                if (!this._cecMgr.isHypervisorRunning()) {
                    this.NUM_PARTITION_SLOTS = 0;
                } else {
                    try {
                        this.NUM_PARTITION_SLOTS = this._cecMgr.getCmdHelper().getNumberOfLparSlots().shortValue();
                    }
                    catch (Throwable throwable) {
                        System.out.println("in _init: call to getNumberOfLparSlots failed ");
                        System.out.println("Setting NUM_PARTITION_SLOTS to 0");
                        throwable.printStackTrace();
                        this.NUM_PARTITION_SLOTS = 0;
                    }
                }
                this._releaseNumPartitionSlots = this.NUM_PARTITION_SLOTS;
                if (DEBUG_ON) {
                    System.out.println("in _init: number of partition slots specified by PHYP = " + this.NUM_PARTITION_SLOTS);
                }
                if (new String(byArray = this._cecMgr.getCmdHelper().readFile(7, 0L, this.HMC_SAVE_AREA_BEGINNING_OFFSET, 12L), "US-ASCII").equals(new String(new byte[byArray.length], "US-ASCII"))) {
                    int n3 = fspLockHelper.getCecLockType();
                    if (n3 == 0) {
                        fspLockHelper.upgradeCecLock();
                    } else if (n3 != 64) {
                        System.out.println("Need to write to FSP but don't have a writeLock - tossing exception");
                        throw new PIHscServerException("0053", null);
                    }
                    this._initializeData(this._fspVersion, true);
                    this._backupToLocalFile();
                } else {
                    int n4;
                    this._releaseVersion = 0;
                    this._fspTemplateVersion = 0;
                    int n5 = 8;
                    this._fspTemplateVersion = byArray[n5];
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apnvhscF", "_fspTemplateVersion = " + this._fspTemplateVersion);
                    }
                    if (DEBUG_ON) {
                        System.out.println("in _init: _fspTemplateVersion = " + this._fspTemplateVersion);
                        System.out.println("in _init: _hmcTemplateVersion = 0");
                        System.out.println("in _init: _hmcProfileTemplateVersion = 0");
                        System.out.println("in _init: _fspVersion = " + this._fspVersion);
                    }
                    n = FSP_VERSIONS.indexOf(this._fspVersion);
                    this._templateVersion = this._fspTemplateVersion;
                    n2 = HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
                    if (n2 == -1) {
                        this._templateVersion = n == -1 ? (byte)2 : this.getFSPTemplateVersion(this._fspVersion);
                        n2 = HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
                    }
                    this._profileTemplateVersion = (Byte)HMC_PROFILE_TEMPLATE_VERSIONS.elementAt(n2);
                    System.out.println("in _init: foooooooooooooooooooooooo");
                    System.out.println("in _init: _templateVersion = " + this._templateVersion);
                    System.out.println("in _init: _profileTemplateVersion  = " + this._profileTemplateVersion);
                    System.out.println("in _init: foooooooooooooooooooooooo");
                    this._updateVariables(true, true, true);
                    int n6 = (Integer)this.saveAreaDataTableOffsets.get(VERSION_BASED_PARTITION_TABLE_DATA);
                    byArray = this._cecMgr.getCmdHelper().readFile(7, 0L, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n6 - this.HMC_SAVE_AREA_BEGINNING_OFFSET);
                    int n7 = (Integer)this.saveAreaDataTableOffsets.get(NUM_PARTITIONS);
                    this._releaseNumPartitionSlots = (short)(byArray[n7] << 8 | byArray[n7 + 1] & 0xFF);
                    System.out.println("in _init: _releaseNumPartitionSlots read from FSP Save Area = " + this._releaseNumPartitionSlots);
                    if (this.NUM_PARTITION_SLOTS == 0) {
                        this._updateVariables(true, true, true);
                        this.NUM_PARTITION_SLOTS = (short)this._releaseNumPartitionSlots;
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apnvhscF", "fspVerIndex = " + n);
                        Trace.trace("apnvhscF", "_fspTemplateVersion = " + this._fspTemplateVersion);
                    }
                    if (DEBUG_ON) {
                        System.out.println("in _init: fspVerIndex = " + n);
                        System.out.println("in _init: _fspTemplateVersion = " + this._fspTemplateVersion);
                    }
                    int n8 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
                    byArray = this._cecMgr.getCmdHelper().readFile(7, 0L, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n8 - this.HMC_SAVE_AREA_BEGINNING_OFFSET);
                    int n9 = (Integer)this.saveAreaDataTableOffsets.get(GLOBAL_TIMESTAMP);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(byArray, n9, n8 - n9);
                    int n10 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
                    byte[] byArray2 = new byte[8];
                    for (int i = 0; i < 8; ++i) {
                        byArray2[i] = byArray[n10 + i];
                    }
                    BigInteger bigInteger = new BigInteger(byArray2);
                    System.out.println("in _init: fsp timestamp checksum value = " + bigInteger.longValue());
                    System.out.println("in _init: recalculated timestamp checksusm = " + this._checksumCalc.getValue());
                    if (bigInteger.longValue() != this._checksumCalc.getValue()) {
                        this.handleBadNVRAMError();
                        this._cecMgr.setCecRecoveryState();
                        throw new PIHscServerException("0006", null);
                    }
                    if (DEBUG_ON) {
                        System.out.println("In NVRAM constructor (_init): timeStamp != 0");
                    }
                    if (n > n2 || this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                        System.out.println("In NVRAM constructor: Looks like MIGRATION -----");
                        n4 = fspLockHelper.getCecLockType();
                        if (n4 == 0) {
                            fspLockHelper.upgradeCecLock();
                        } else if (n4 == -1) {
                            System.out.println("Need to write to FSP but don't have a writeLock - tossing exception");
                            throw new PIHscServerException("0053", null);
                        }
                    }
                    this._migrationOccurred = false;
                    this.buildNVRAM(true, null, true, true, true);
                    if (this._migrationOccurred) {
                        System.out.println("in removeSysProfile: migration occurred.  attempt write to FSP");
                        this._migrationOccurred = false;
                        n4 = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
                        byte[] byArray3 = new byte[this.NVRAM_SIZE];
                        System.arraycopy(this._nvramData, n4, byArray3, 0, this.NVRAM_SIZE);
                        this._writeDataToFSP(byArray3, n4, this.NVRAM_SIZE);
                    }
                    this._backupToLocalFile();
                }
                Object var19_22 = null;
                this._cecMgr.setSaveArea(this);
                if (DEBUG_ON) {
                    System.out.println("End of NVRAM construtor");
                    System.out.println("*******************************************");
                    System.out.println();
                    System.out.println();
                }
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                this._cecMgr.setSaveArea(this);
                if (DEBUG_ON) {
                    System.out.println("End of NVRAM construtor");
                    System.out.println("*******************************************");
                    System.out.println();
                    System.out.println();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this._cecMgr.setSaveArea(this);
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0008", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- NVRAM Constructor");
            }
        }
    }

    public PIHMCSaveArea(File file, int n, int n2, byte by, String string, OmCecMgr omCecMgr, String string2) throws PIHscServerException {
        this.initSaveAreaFormatTables();
        try {
            if (DEBUG_ON) {
                System.out.println("SQUADRONS HMC SAVE AREA - restore from file");
            }
            Object var8_8 = null;
            byte by2 = 0;
            int n3 = 0;
            int n4 = 0;
            this._cecMgr = omCecMgr;
            this._fspVersion = string2;
            if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                System.out.println("in constructor (backup file): _fspVersion is null");
                this._fspVersion = this._cecMgr.getFspVersion();
                if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                    this._fspVersion = "F3.0";
                }
                if (DEBUG_ON) {
                    System.out.println("fspVersion = " + this._fspVersion);
                }
            }
            n4 = FSP_VERSIONS.indexOf(this._fspVersion);
            this.NVRAM_SIZE = n;
            this.NUM_PARTITION_SLOTS = (short)n2;
            this._releaseNumPartitionSlots = this.NUM_PARTITION_SLOTS;
            this._cecName = string;
            FileInputStream fileInputStream = new FileInputStream(file);
            if (DEBUG_ON) {
                System.out.println("PIHMCSaveArea from file; NVRAM_SIZE = " + this.NVRAM_SIZE);
            }
            fileInputStream.skip(8L);
            by2 = (byte)fileInputStream.read();
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "restoreFileTemplateVersion = " + String.valueOf(by2));
            }
            if (DEBUG_ON) {
                System.out.println("restoreFileTemplateVersion = " + by2);
            }
            fileInputStream.close();
            this._templateVersion = by2;
            n3 = HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
            if (n3 == -1) {
                this._templateVersion = n4 == -1 ? (byte)2 : this.getFSPTemplateVersion(this._fspVersion);
                n3 = HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
            }
            this._profileTemplateVersion = (Byte)HMC_PROFILE_TEMPLATE_VERSIONS.elementAt(n3);
            this._updateVariables(true, false, true);
            this.buildNVRAMFromLocalCopy(file, false, false);
            if (DEBUG_ON) {
                System.out.println("End of PIHMCSaveArea constructor(SPECIAL - from file)");
                System.out.println("**********************************************");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0009", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- NVRAM Constructor");
            }
        }
    }

    public PIHMCSaveArea(int n, int n2, byte by, String string, OmCecMgr omCecMgr, String string2) throws PIHscServerException {
        this.initSaveAreaFormatTables();
        try {
            if (DEBUG_ON) {
                System.out.println("SQUADRONS HMC SAVE AREA - migration constructor ");
            }
            Object var7_7 = null;
            int n3 = 0;
            this._cecMgr = omCecMgr;
            this._fspVersion = string2;
            this.NVRAM_SIZE = n;
            this.NUM_PARTITION_SLOTS = (short)n2;
            this._releaseNumPartitionSlots = this.NUM_PARTITION_SLOTS;
            this._templateVersion = by;
            n3 = HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
            this._profileTemplateVersion = (Byte)HMC_PROFILE_TEMPLATE_VERSIONS.elementAt(n3);
            this._cecName = string;
            if (DEBUG_ON) {
                System.out.println("PIHMCSaveArea for migration; NVRAM_SIZE = " + this.NVRAM_SIZE);
                System.out.println("_templateVersion = " + this._templateVersion);
                System.out.println("_profileTemplateVersion = " + this._profileTemplateVersion);
            }
            this._updateVariables(true, false, true);
            if (DEBUG_ON) {
                System.out.println("End of PIHMCSaveArea constructor(SPECIAL - for migration)");
                System.out.println("**********************************************");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0008", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- NVRAM Constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() throws PIHscServerException {
        block21: {
            int n = 1;
            boolean bl = false;
            int n2 = 0;
            try {
                try {
                    this.NVRAM_SIZE = (int)this._cecMgr.getCmdHelper().getFileSize(7, 0L);
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in PIHMCSaveArea initialize(): open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                        System.out.println("in initialize: _fspVersion is null");
                        this._fspVersion = this._cecMgr.getFspVersion();
                        if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                            System.out.println("in initialize: _fspVersion is still null");
                            this._fspVersion = "F3.0";
                        }
                        if (DEBUG_ON) {
                            System.out.println("fspVersion = " + this._fspVersion);
                        }
                    }
                    int n3 = FSP_VERSIONS.indexOf(this._fspVersion);
                    if (DEBUG_ON) {
                        System.out.println("in initialize: fspVerIndex = " + n3);
                    }
                    this._templateVersion = n3 == -1 ? (byte)0 : this.getFSPTemplateVersion(this._fspVersion);
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apnvhscF", "_templateVersion = " + String.valueOf(this._templateVersion));
                    }
                    n2 = HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
                    this._profileTemplateVersion = (Byte)HMC_PROFILE_TEMPLATE_VERSIONS.elementAt(n2);
                    if (DEBUG_ON) {
                        System.out.println("in initialize: _templateVersion = " + this._templateVersion);
                        System.out.println("in initialize: _profileTemplateVersion = " + this._profileTemplateVersion);
                    }
                    System.out.println("in initialize: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                    System.out.println("in initialize: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                    if (this.NUM_PARTITION_SLOTS < this._releaseNumPartitionSlots) {
                        System.out.println("in initialize: SOMETHING CHANGED: NUM_PARTITION_SLOTS < _releaseNumPartitionSlots");
                        System.out.println("in initialize: setting _releaseNumPartitionSlots to NUM_PARTITION_SLOTS");
                        this._releaseNumPartitionSlots = this.NUM_PARTITION_SLOTS;
                    }
                    this._initializeData(this._fspVersion, false);
                    this._backupToLocalFile();
                    if (DEBUG_ON) {
                        System.out.println("successful initialize ");
                    }
                    this._cecMgr.setSaveArea(this);
                }
                catch (Throwable throwable) {
                    n = 255;
                    throwable.printStackTrace();
                    this._cecMgr.setSaveArea(this);
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0030", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var8_8 = null;
                if (!bl) break block21;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                }
                this.isSaveAreaFileOpen = false;
                if (!DEBUG_ON) throw throwable;
                System.out.println("End of NVRAM initialize");
                System.out.println("*******************************************");
                System.out.println();
                System.out.println();
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        if (!DEBUG_ON) return;
        System.out.println("End of NVRAM initialize");
        System.out.println("*******************************************");
        System.out.println();
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rebuildNVRAM(String string, FspLockHelper fspLockHelper) throws PIHscServerException {
        boolean bl;
        block29: {
            bl = this._modSinceLastRebuild;
            int n = 128;
            boolean bl2 = false;
            FspFileOpenResponse fspFileOpenResponse = null;
            this._fspVersion = string;
            if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                System.out.println("in rebuildNVRAM: fspVersion is null");
                this._fspVersion = this._cecMgr.getFspVersion();
                if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                    System.out.println("in rebuildNVRAM: _fspVersion is still null");
                    this._fspVersion = "F3.0";
                }
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "in  rebuildNVRAM");
                Trace.trace("apnvhscF", "_fspVersion = " + this._fspVersion);
            }
            if (DEBUG_ON) {
                System.out.println("in rebuildNVRAM ");
                System.out.println("_fspVersion = " + this._fspVersion);
            }
            boolean bl3 = false;
            int n2 = fspLockHelper.getCecLockType();
            System.out.println("fspLockHelper lockType = " + n2);
            try {
                block28: {
                    try {
                        this.NVRAM_SIZE = (int)this._cecMgr.getCmdHelper().getFileSize(7, 0L);
                        Object object = this.saveAreaFileSyncObj;
                        synchronized (object) {
                            while (this.isSaveAreaFileOpen) {
                                try {
                                    if (DEBUG_ON) {
                                        System.out.println("Waiting for file to close....");
                                    }
                                    Thread.sleep(200L);
                                }
                                catch (Exception exception) {}
                            }
                            this.isSaveAreaFileOpen = true;
                        }
                        fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)0, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                        if (fspFileOpenResponse == null) {
                            if (DEBUG_ON) {
                                System.out.println("in PIHMCSaveArea rebuildNVRAM: open file failed");
                            }
                            throw new PIHscServerException("004c", null);
                        }
                        bl2 = true;
                        if (this._cecMgr.isHypervisorRunning()) {
                            try {
                                this.NUM_PARTITION_SLOTS = this._cecMgr.getCmdHelper().getNumberOfLparSlots().shortValue();
                            }
                            catch (Throwable throwable) {
                                System.out.println("in rebuildNVRAM: call to getNumberOfLparSlots failed ");
                                System.out.println("Not changing current  NUM_PARTITION_SLOTS:  " + this.NUM_PARTITION_SLOTS);
                                throwable.printStackTrace();
                            }
                        }
                        if (new String((byte[])(object = (Object)this._cecMgr.getCmdHelper().readFile(7, 0L, this.HMC_SAVE_AREA_BEGINNING_OFFSET, 12L)), "US-ASCII").equals(new String(new byte[((Object)object).length], "US-ASCII"))) {
                            System.out.println("in rebuildNVRAM: savearea cleared - initializing ----");
                            this._initializeData(this._fspVersion, true);
                            bl = true;
                            break block28;
                        }
                        System.out.println("in rebuildNVRAM: savearea already initialized - call buildNVRAM ----");
                        this._migrationOccurred = false;
                        this.buildNVRAM(false, null, true, true, true);
                        bl = this._modSinceLastRebuild;
                        if (this._migrationOccurred) {
                            System.out.println("in rebuildNVRAM: migration occurred");
                            this._migrationOccurred = false;
                            if (n2 == 0) {
                                System.out.println("in rebuildNVRAM: changing readLock to writeLock");
                                fspLockHelper.upgradeCecLock();
                            } else if (n2 != 64) {
                                System.out.println("Need to write to FSP but don't have a writeLock - tossing exception");
                                throw new PIHscServerException("0053", null);
                            }
                            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                            bl2 = false;
                            n = 1;
                            fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                            if (fspFileOpenResponse == null) {
                                if (DEBUG_ON) {
                                    System.out.println("in PIHMCSaveArea rebuildNVRAM: secondary open file failed (for migration)");
                                }
                                throw new PIHscServerException("004c", null);
                            }
                            bl2 = true;
                            int n3 = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
                            byte[] byArray = new byte[this.NVRAM_SIZE];
                            System.arraycopy(this._nvramData, n3, byArray, 0, this.NVRAM_SIZE);
                            this._writeDataToFSP(byArray, n3, this.NVRAM_SIZE);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                        if (throwable instanceof PIHscServerException) {
                            throw (PIHscServerException)throwable;
                        }
                        throw new PIHscServerException("0008", throwable);
                    }
                }
                Object var13_15 = null;
                if (!bl2) break block29;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (bl2) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        System.out.println("exit rebuildNVRAM:  hasSaveAreaChanged = " + bl);
        this._modSinceLastRebuild = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean buildNVRAM(boolean var1_1, File var2_2, boolean var3_3, boolean var4_4, boolean var5_5) throws PIHscServerException {
        block292: {
            block294: {
                block293: {
                    block283: {
                        block291: {
                            block290: {
                                block284: {
                                    block289: {
                                        block288: {
                                            block285: {
                                                block287: {
                                                    block286: {
                                                        block280: {
                                                            block282: {
                                                                block281: {
                                                                    var6_6 = 0;
                                                                    if (PIHMCSaveArea.DEBUG_ON) {
                                                                        System.out.println("*****************************************");
                                                                        System.out.println("In buildNVRAM");
                                                                    }
                                                                    var7_7 = null;
                                                                    var8_9 = null;
                                                                    var9_10 = 0;
                                                                    var10_11 = 0;
                                                                    var11_12 = 0;
                                                                    var12_13 = 0;
                                                                    var13_14 = null;
                                                                    var14_15 = null;
                                                                    var15_16 = null;
                                                                    var16_17 = null;
                                                                    var17_18 = 0;
                                                                    var18_19 = 0;
                                                                    var19_20 = null;
                                                                    var20_21 = new byte[3];
                                                                    var21_22 = new byte[8];
                                                                    var22_23 = new byte[16];
                                                                    if (var4_4) ** GOTO lbl81
                                                                    var9_10 = this.updateNVRAMCache(var2_2, false);
                                                                    if (var9_10 != 0) {
                                                                        var6_6 = 1;
                                                                        this._modSinceLastRebuild = true;
                                                                    }
                                                                    var23_24 = ((Integer)this.saveAreaDataTableOffsets.get("save_area_template_version")).intValue();
                                                                    this._templateVersion = this._nvramData[var23_24];
                                                                    var24_25 = (Integer)this.saveAreaDataTableOffsets.get("num_partitions");
                                                                    this._releaseNumPartitionSlots = (short)(this._nvramData[var24_25] << 8 | this._nvramData[var24_25 + 1] & 255);
                                                                    System.out.println("in buildNVRAM: building from file - ");
                                                                    System.out.println("in buildNVRAM: _templateVersion = " + this._templateVersion);
                                                                    System.out.println("in buildNVRAM: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                                                                    System.out.println("in buildNVRAM: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                                                                    System.out.println(" ");
                                                                    if (var9_10 != -1) break block280;
                                                                    System.out.println("in buildNVRAM: ***********************************");
                                                                    System.out.println("in buildNVRAM: everything gone - call initialize()");
                                                                    System.out.println("in buildNVRAM: ***********************************");
                                                                    this.initialize();
                                                                    var25_26 = var6_6;
                                                                    {
                                                                        var135_31 = null;
                                                                        if (!PIHMCSaveArea.DEBUG_ON) break block281;
                                                                        System.out.println("End of buildNVRAM");
                                                                        System.out.println("********************************************");
                                                                        System.out.println();
                                                                        System.out.println();
                                                                    }
                                                                }
                                                                if (1 > Trace.LEVEL) break block282;
                                                                Trace.trace("apnvhscT", "<- buildNVRAM");
                                                            }
                                                            return (boolean)var25_26;
                                                        }
                                                        if (PIHMCSaveArea.DEBUG_ON) {
                                                            System.out.println("_templateVersion = " + this._templateVersion);
                                                        }
                                                        var12_13 = PIHMCSaveArea.FSP_VERSIONS.indexOf(this._fspVersion);
                                                        var25_27 = this.getFSPTemplateVersion(this._fspVersion);
                                                        var10_11 = PIHMCSaveArea.HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
                                                        if (2 <= Trace.LEVEL) {
                                                            Trace.trace("apnvhscF", "fspVerIndex = " + String.valueOf(var12_13));
                                                            Trace.trace("apnvhscF", "fspTemplateVersion = " + String.valueOf(var25_27));
                                                            Trace.trace("apnvhscF", "templateVerIndex = " + String.valueOf(var10_11));
                                                        }
                                                        if (PIHMCSaveArea.DEBUG_ON) {
                                                            System.out.println("fspVerIndex = " + var12_13);
                                                            System.out.println("fspTemplateVersion = " + var25_27);
                                                            System.out.println("templateVerIndex = " + var10_11);
                                                        }
                                                        if (var10_11 == -1) {
                                                            System.out.println("_templateVersion is unknown");
                                                            if (var12_13 == -1) {
                                                                System.out.println("_fspVersion is unknown");
                                                                this._templateVersion = (byte)2;
                                                            } else {
                                                                this._templateVersion = var25_27;
                                                            }
                                                            var10_11 = PIHMCSaveArea.HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
                                                        }
                                                        this._profileTemplateVersion = (Byte)PIHMCSaveArea.HMC_PROFILE_TEMPLATE_VERSIONS.elementAt(var10_11);
                                                        this._updateVariables(false, false, false);
                                                        break block283;
lbl81:
                                                        // 1 sources

                                                        System.out.println("in buildNVRAM: reading from FSP");
                                                        var23_24 = ((Integer)this.saveAreaDataTableOffsets.get("basic_info_checksum")).intValue();
                                                        var24_25 = (Integer)this.saveAreaDataTableOffsets.get("partition_table_checksum");
                                                        var15_16 = this._readDataFromFSP(var23_24, var24_25 - var23_24);
                                                        if (!var1_1 && new String(var15_16, "US-ASCII").equals(new String(new byte[10], "US-ASCII"))) {
                                                            this.handleBadNVRAMError();
                                                            this._cecMgr.setCecRecoveryState();
                                                            throw new PIHscServerException("0031", null);
                                                        }
                                                        var16_17 = new byte[8];
                                                        for (var25_28 = 0; var25_28 < 8; ++var25_28) {
                                                            var16_17[var25_28] = var15_16[var23_24 + var25_28];
                                                        }
                                                        var19_20 = new BigInteger(var16_17);
                                                        this._checksum = var19_20.longValue();
                                                        var17_18 = (Integer)this.saveAreaDataTableOffsets.get("save_area_template_version");
                                                        var18_19 = (Integer)this.saveAreaDataTableOffsets.get("timestamp_info_checksum");
                                                        this._checksumCalc.reset();
                                                        this._checksumCalc.update(var15_16, var17_18, var18_19 - var17_18);
                                                        System.out.println("in buildNVRAM: basic info saved checksum = " + this._checksum);
                                                        System.out.println("in buildNVRAM: basic info recalculated checksum = " + this._checksumCalc.getValue());
                                                        if (this._checksum != this._checksumCalc.getValue()) {
                                                            if (PIHMCSaveArea.DEBUG_ON) {
                                                                System.out.println("Basic info corrupted");
                                                            }
                                                            this.handleBadNVRAMError();
                                                            this._cecMgr.setCecRecoveryState();
                                                            throw new PIHscServerException("0006", null);
                                                        }
                                                        this._templateVersion = var15_16[var17_18];
                                                        if (2 <= Trace.LEVEL) {
                                                            Trace.trace("apnvhscF", "_templateVersion = " + String.valueOf(this._templateVersion));
                                                        }
                                                        if (PIHMCSaveArea.DEBUG_ON) {
                                                            System.out.println("in buildNVRAM: _templateVersion = " + this._templateVersion);
                                                        }
                                                        var17_18 = (Integer)this.saveAreaDataTableOffsets.get("veth_mac_prefix");
                                                        for (var25_28 = 0; var25_28 < 3; ++var25_28) {
                                                            var20_21[var25_28] = var15_16[var17_18 + var25_28];
                                                        }
                                                        this._macAddrPrefix = ByteUtilities.toHexString(var20_21);
                                                        if (2 <= Trace.LEVEL) {
                                                            Trace.trace("apnvhscF", "_macAddrPrefix = " + String.valueOf(this._macAddrPrefix));
                                                        }
                                                        if (PIHMCSaveArea.DEBUG_ON) {
                                                            System.out.println("_macAddrPrefix = " + this._macAddrPrefix);
                                                        }
                                                        System.out.println("in buildNVRAM: _macAddrPrefix = " + this._macAddrPrefix);
                                                        var25_29 = null;
                                                        var17_18 = (Integer)this.saveAreaDataTableOffsets.get("sys_cred_user_id");
                                                        for (var26_38 = 0; var26_38 < 8; ++var26_38) {
                                                            var21_22[var26_38] = var15_16[var17_18 + var26_38];
                                                        }
                                                        var25_29 = new String(var21_22);
                                                        this._sysCredentialUserID = var25_29.trim();
                                                        if (2 <= Trace.LEVEL) {
                                                            Trace.trace("apnvhscF", "_sysCredentialUserID = " + String.valueOf(this._sysCredentialUserID));
                                                        }
                                                        if (PIHMCSaveArea.DEBUG_ON) {
                                                            System.out.println("_sysCredentialUserID = " + this._sysCredentialUserID);
                                                        }
                                                        var17_18 = (Integer)this.saveAreaDataTableOffsets.get("sys_cred_password");
                                                        for (var26_38 = 0; var26_38 < 16; ++var26_38) {
                                                            var22_23[var26_38] = var15_16[var17_18 + var26_38];
                                                        }
                                                        var25_29 = new String(var22_23);
                                                        this._sysCredentialPassword = var25_29.trim();
                                                        if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                                                            System.out.println("in buildNVRAM: _fspVersion is null");
                                                            this._fspVersion = this._cecMgr.getFspVersion();
                                                            if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                                                                System.out.println("in buildNVRAM: _fspVersion is still null");
                                                                this._fspVersion = "F3.0";
                                                            }
                                                            if (PIHMCSaveArea.DEBUG_ON) {
                                                                System.out.println("fspVersion = " + this._fspVersion);
                                                            }
                                                        }
                                                        var12_13 = PIHMCSaveArea.FSP_VERSIONS.indexOf(this._fspVersion);
                                                        var26_38 = this.getFSPTemplateVersion(this._fspVersion);
                                                        if (2 <= Trace.LEVEL) {
                                                            Trace.trace("apnvhscF", "fspVersion = " + this._fspVersion);
                                                            Trace.trace("apnvhscF", "fspVerIndex = " + String.valueOf(var12_13));
                                                            Trace.trace("apnvhscF", "fspTemplateVersion = " + var26_38);
                                                            Trace.trace("apnvhscF", "_templateVersion = " + this._templateVersion);
                                                        }
                                                        if (PIHMCSaveArea.DEBUG_ON) {
                                                            System.out.println("in buildNVRAM: fspVersion = " + this._fspVersion);
                                                            System.out.println("in buildNVRAM: fspVerIndex = " + var12_13);
                                                            System.out.println("in buildNVRAM: fspTemplateVersion = " + var26_38);
                                                            System.out.println("in buildNVRAM: _templateVersion = " + this._templateVersion);
                                                        }
                                                        if ((var10_11 = PIHMCSaveArea.HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion))) == -1) {
                                                            if (var12_13 == -1) {
                                                                System.out.println("in buildNVRAM: _templateVersion is unknown; setting to latest HMC version");
                                                                System.out.println("in buildNVRAM: _latestHmcTemplateVersion = 2");
                                                                this._templateVersion = (byte)2;
                                                            } else {
                                                                this._templateVersion = this.getFSPTemplateVersion(this._fspVersion);
                                                            }
                                                            var10_11 = PIHMCSaveArea.HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
                                                        }
                                                        this._profileTemplateVersion = (Byte)PIHMCSaveArea.HMC_PROFILE_TEMPLATE_VERSIONS.elementAt(var10_11);
                                                        if (!var1_1) {
                                                            this._updateVariables(false, true, false);
                                                        }
                                                        if (var1_1) break block284;
                                                        var27_40 = (Integer)this.saveAreaDataTableOffsets.get("timestamp_info_checksum");
                                                        var16_17 = new byte[8];
                                                        for (var28_43 = 0; var28_43 < 8; ++var28_43) {
                                                            var16_17[var28_43] = var15_16[var27_40 + var28_43];
                                                        }
                                                        var19_20 = new BigInteger(var16_17);
                                                        this._checksum = var19_20.longValue();
                                                        var17_18 = var27_40 + 8;
                                                        this._checksumCalc.reset();
                                                        this._checksumCalc.update(var15_16, var17_18, var24_25 - var17_18);
                                                        System.out.println("in buildNVRAM: timestampInfoChecksumOffset = " + var27_40);
                                                        System.out.println("in buildNVRAM: _checksum = " + this._checksum);
                                                        System.out.println("in buildNVRAM: _checksumCalc.getValue = " + this._checksumCalc.getValue());
                                                        if (this._checksum != this._checksumCalc.getValue()) {
                                                            if (PIHMCSaveArea.DEBUG_ON) {
                                                                System.out.println("in buildNVRAM: timestampInfoChecksumOffset = " + var27_40);
                                                                System.out.println("in buildNVRAM: _checksum = " + this._checksum);
                                                                System.out.println("in buildNVRAM: _checksumCalc.getValue = " + this._checksumCalc.getValue());
                                                            }
                                                            this.handleBadNVRAMError();
                                                            this._cecMgr.setCecRecoveryState();
                                                            throw new PIHscServerException("0006", null);
                                                        }
                                                        var28_44 = new byte[11];
                                                        for (var29_45 = 0; var29_45 < 11; ++var29_45) {
                                                            var28_44[var29_45] = var15_16[var17_18 + var29_45];
                                                        }
                                                        var29_45 = this.compareTime(this._nvramTimestamp, var28_44);
                                                        if (var29_45 != 0) break block285;
                                                        try {
                                                            if (!var5_5) {
                                                                Thread.sleep(1000L);
                                                            }
                                                        }
                                                        catch (Throwable var30_46) {
                                                            var30_46.printStackTrace();
                                                            HSCLogUtils.serverLog(var30_46, HSCLogUtils._NVRAMClassLogInfo);
                                                        }
                                                        if (2 <= Trace.LEVEL) {
                                                            Trace.trace("apnvhscF", "Time stamps in the cached and fsp in the same - No need to update");
                                                        }
                                                        var11_12 = var12_13 == -1 ? this._templateVersion : (Byte)PIHMCSaveArea.NVRAM_VERSIONS.elementAt(var12_13);
                                                        if (var12_13 > var10_11 && var11_12 > this._templateVersion || this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                                                            System.out.println("in buildNVRAM: CALLING migration ==============================");
                                                            System.out.println("fspVerIndex = " + var12_13);
                                                            System.out.println("templateVerIndex = " + var10_11);
                                                            System.out.println("NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                                                            System.out.println("_releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                                                            this.migration();
                                                            var6_6 = 1;
                                                            this._modSinceLastRebuild = true;
                                                        }
                                                        var30_47 = var6_6;
                                                        {
                                                            var135_32 = null;
                                                            if (!PIHMCSaveArea.DEBUG_ON) break block286;
                                                            System.out.println("End of buildNVRAM");
                                                            System.out.println("********************************************");
                                                            System.out.println();
                                                            System.out.println();
                                                        }
                                                    }
                                                    if (1 > Trace.LEVEL) break block287;
                                                    Trace.trace("apnvhscT", "<- buildNVRAM");
                                                }
                                                return (boolean)var30_47;
                                            }
                                            if (PIHMCSaveArea.DEBUG_ON) {
                                                System.out.println("Need to update NVRAM cache");
                                            }
                                            if (2 <= Trace.LEVEL) {
                                                Trace.trace("apnvhscF", "Time Stamps in the FSP is newer than the one in the cache - Need to update the NVRAM");
                                            }
                                            if ((var9_10 = this.updateNVRAMCache(null, true)) != 0) {
                                                var6_6 = 1;
                                                this._modSinceLastRebuild = true;
                                            }
                                            if (var9_10 != -1) break block283;
                                            this.initialize();
                                            var30_48 = var6_6;
                                            {
                                                var135_33 = null;
                                                if (!PIHMCSaveArea.DEBUG_ON) break block288;
                                                System.out.println("End of buildNVRAM");
                                                System.out.println("********************************************");
                                                System.out.println();
                                                System.out.println();
                                            }
                                        }
                                        if (1 > Trace.LEVEL) break block289;
                                        Trace.trace("apnvhscT", "<- buildNVRAM");
                                    }
                                    return (boolean)var30_48;
                                }
                                if (3 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscD", "Constructor calls this method - Update everything");
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("NVRAM constructor call this method");
                                }
                                if ((var9_10 = this.updateNVRAMCache(null, true)) != 0) {
                                    var6_6 = 1;
                                    this._modSinceLastRebuild = true;
                                }
                                if (var9_10 != -1) break block283;
                                this.initialize();
                                var27_41 = var6_6;
                                {
                                    var135_34 = null;
                                    if (!PIHMCSaveArea.DEBUG_ON) break block290;
                                    System.out.println("End of buildNVRAM");
                                    System.out.println("********************************************");
                                    System.out.println();
                                    System.out.println();
                                }
                            }
                            if (1 > Trace.LEVEL) break block291;
                            Trace.trace("apnvhscT", "<- buildNVRAM");
                        }
                        return (boolean)var27_41;
                    }
                    if (var9_10 != 0) {
                        var6_6 = 1;
                        this._modSinceLastRebuild = true;
                    }
                    this._nvramBAInputStream = new ByteArrayInputStream(this._nvramData);
                    this._nvramDInputStream = new DataInputStream(this._nvramBAInputStream);
                    var23_24 = 0;
                    var24_25 = 0;
                    var25_30 = null;
                    var26_39 = null;
                    var27_42 = null;
                    var28_44 = null;
                    var29_45 = 0;
                    var30_49 = null;
                    var31_50 = false;
                    var32_51 = 0;
                    var33_52 = null;
                    var34_53 = 0;
                    var35_54 = 0;
                    var36_55 = 0;
                    var37_56 = 0;
                    var37_56 = (Integer)this.saveAreaDataTableOffsets.get("version_based_profile_info_data");
                    var17_18 = (Integer)this.saveAreaDataTableOffsets.get("global_timestamp");
                    this._nvramDInputStream.skipBytes(var17_18);
                    this._nvramDInputStream.read(this._nvramTimestamp);
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: _nvramTimestamp = " + PIHMCSaveArea.printableTimestamp(new String(this._nvramTimestamp, "US-ASCII")));
                    }
                    if ((var9_10 & 16) != 0) {
                        this._nvramDInputStream.read(this._partitionTableTimestamp);
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: Partition Table timestamp = " + PIHMCSaveArea.printableTimestamp(new String(this._partitionTableTimestamp, "US-ASCII")));
                        }
                    } else {
                        this._nvramDInputStream.skipBytes(11);
                    }
                    this._nvramDInputStream.skipBytes(19);
                    if ((var9_10 & 2) != 0) {
                        this._nvramDInputStream.read(this._defaultProfTableTimestamp);
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: _defaultProfTableTimestamp = " + PIHMCSaveArea.printableTimestamp(new String(this._defaultProfTableTimestamp, "US-ASCII")));
                        }
                    } else {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("NOT updating DEFAULT_LIST variables");
                        }
                        this._nvramDInputStream.skipBytes(11);
                    }
                    this._nvramDInputStream.skipBytes(19);
                    if ((var9_10 & 4) != 0) {
                        this._nvramDInputStream.read(this._activatedProfTableTimestamp);
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: _activatedProfTableTimestamp = " + PIHMCSaveArea.printableTimestamp(new String(this._activatedProfTableTimestamp, "US-ASCII")));
                        }
                    } else {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("NO updating ACTIVATED_LIST variables");
                        }
                        this._nvramDInputStream.skipBytes(11);
                    }
                    this._nvramDInputStream.skipBytes(19);
                    if ((var9_10 & 8) != 0) {
                        this._nvramDInputStream.read(this._profileInfoTimestamp);
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: _profileInfoTimestamp = " + PIHMCSaveArea.printableTimestamp(new String(this._profileInfoTimestamp, "US-ASCII")));
                        }
                    } else {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("NOT updating PROFILE_INFO_CHANGE variables");
                        }
                        this._nvramDInputStream.skipBytes(11);
                    }
                    var17_18 = (Integer)this.saveAreaDataTableOffsets.get("prior_modified_profile_info_timestamp");
                    var34_53 = (Integer)this.saveAreaDataTableOffsets.get("version_based_partition_table_data");
                    this._nvramDInputStream.skipBytes(var34_53 - var17_18);
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("in buildNVRAM: partition table update; skipping " + (var34_53 - var17_18) + " bytes -------");
                    }
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: _partitionTable");
                    }
                    var35_54 = (Integer)this.saveAreaDataTableOffsets.get("default_prof_table");
                    if ((var9_10 & 16) != 0) {
                        this._partitionTable = new String[this._releaseNumPartitionSlots];
                        this._partitionNameTable = new String[this._releaseNumPartitionSlots];
                        this._partitionOSTypeTable = new short[this._releaseNumPartitionSlots];
                        this._fastActivation = new boolean[this._releaseNumPartitionSlots];
                        for (var38_57 = 0; var38_57 < this._releaseNumPartitionSlots; ++var38_57) {
                            var39_59 = new byte[48];
                            this._nvramDInputStream.readFully(var39_59);
                            var40_62 = null;
                            var41_64 = 0;
                            var40_62 = new String(var39_59, 0, 47, "US-ASCII");
                            if (var39_59[47] != 0) {
                                var41_64 = 1;
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("in buildNVRAM: lparName[" + (var38_57 + 1) + "] = " + var40_62.trim());
                            }
                            if (var39_59.equals(this._zeroOutNameString)) {
                                this._partitionTable[var38_57] = null;
                                this._partitionNameTable[var38_57] = null;
                            } else {
                                this._partitionTable[var38_57] = var40_62.trim();
                                this._partitionNameTable[var38_57] = var40_62.trim();
                                this._fastActivation[var38_57] = var41_64;
                            }
                            this._partitionOSTypeTable[var38_57] = var42_65 = (short)(this._nvramDInputStream.readUnsignedByte() & 255);
                        }
                        this._nvramDInputStream.skipBytes(8);
                    } else {
                        this._nvramDInputStream.skipBytes(var35_54 - var34_53);
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("in buildNVRAM: skipping " + (var35_54 - var34_53) + " bytes to default prof table");
                        }
                    }
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: _defaultProfTable");
                    }
                    var13_14 = (Object[])this.saveAreaDataTable.get("activated_prof_table");
                    var36_55 = (Integer)var13_14[1];
                    if ((var9_10 & 2) != 0) {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: default list has been changed");
                        }
                        this._defaultProfTable = new int[this._releaseNumPartitionSlots];
                        for (var38_57 = 0; var38_57 < this._releaseNumPartitionSlots; ++var38_57) {
                            this._defaultProfTable[var38_57] = var32_51 = this._nvramDInputStream.readUnsignedShort();
                            if (!PIHMCSaveArea.DEBUG_ON) continue;
                            System.out.println("In buildNVRAM: defaultProfile(" + var38_57 + ") " + var32_51);
                        }
                        this._nvramDInputStream.skipBytes(8);
                    } else {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: default list has not been changed");
                        }
                        this._nvramDInputStream.skipBytes(var36_55 - var35_54);
                    }
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: _activatedProfTable");
                    }
                    var38_57 = (Integer)this.saveAreaDataTableOffsets.get("next_available_sequence_number");
                    if ((var9_10 & 4) != 0) {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: activated list needs to be updated");
                        }
                        this._activatedProfTable = new int[this._releaseNumPartitionSlots];
                        for (var39_60 = 0; var39_60 < this._releaseNumPartitionSlots; ++var39_60) {
                            this._activatedProfTable[var39_60] = var32_51 = this._nvramDInputStream.readUnsignedShort();
                            if (!PIHMCSaveArea.DEBUG_ON) continue;
                            System.out.println("In buildNVRAM: activatedProfile(" + var39_60 + ") " + var32_51);
                        }
                        var39_60 = (Integer)this.saveAreaDataTableOffsets.get("profile_info_checksum");
                        this._nvramDInputStream.skipBytes(var38_57 - var39_60);
                    } else {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("in buildNVRAM: activated list doesn't need to be updated");
                        }
                        this._nvramDInputStream.skipBytes(var38_57 - var36_55);
                    }
                    this._nextAvailProfileSequenceID = this._nvramDInputStream.readUnsignedShort();
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("============================================================");
                        System.out.println("in buildNVRAM: _nextAvailProfileSequenceID = " + this._nextAvailProfileSequenceID);
                        System.out.println("============================================================");
                    }
                    if ((var9_10 & 8) == 0) ** GOTO lbl1295
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: profile info needs to be updated");
                    }
                    this._nvramDataSize = var37_56;
                    this._profileTable = new Hashtable<K, V>();
                    this._profilesAtPartitionTable = new Vector[this._releaseNumPartitionSlots + 1];
                    for (var39_61 = 0; var39_61 < this._releaseNumPartitionSlots + 1; ++var39_61) {
                        this._profilesAtPartitionTable[var39_61] = new Vector<E>();
                    }
                    var39_61 = 0;
                    var40_63 = 0;
                    var40_63 = this._nvramDInputStream.readShort();
                    if (var40_63 != 0) break block292;
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: no profiles created yet");
                    }
                    if (var3_3) {
                        this._backupToLocalFile();
                    }
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("End of buildNVRAM");
                        System.out.println("****************************************");
                        System.out.println();
                        System.out.println();
                    }
                    if (var12_13 > var10_11 && var11_12 > this._templateVersion || this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                        System.out.println("in buildNVRAM: CALLING migration ==============================");
                        System.out.println("fspVerIndex = " + var12_13);
                        System.out.println("templateVerIndex = " + var10_11);
                        System.out.println("NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                        System.out.println("_releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                        this.migration();
                    }
                    var41_64 = var6_6;
                    {
                        var135_35 = null;
                        if (!PIHMCSaveArea.DEBUG_ON) break block293;
                        System.out.println("End of buildNVRAM");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                if (1 > Trace.LEVEL) break block294;
                Trace.trace("apnvhscT", "<- buildNVRAM");
            }
            return (boolean)var41_64;
        }
        try {
            block295: {
                var29_45 = var37_56;
                if (PIHMCSaveArea.DEBUG_ON) {
                    System.out.println();
                    System.out.println("In buildNVRAM; current mark  = " + var29_45);
                }
                var39_61 = 1;
                var41_64 = 0;
                var32_51 = 0;
                var42_65 = 0;
                var43_66 = 0;
                var44_67 = false;
                while (var29_45 < this.NVRAM_SIZE) {
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: profile offset = " + var29_45);
                    }
                    var45_68 = new Hashtable<String, Object>();
                    if (var39_61 != 1) {
                        var40_63 = this._nvramDInputStream.readShort();
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("flag != 1");
                        }
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: profile len = " + var40_63);
                        }
                    } else {
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: profile len = " + var40_63);
                        }
                        var39_61 = 0;
                    }
                    var41_64 = (short)this._nvramDInputStream.readUnsignedByte();
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("In buildNVRAM: profile's template Version = " + var41_64);
                    }
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("apnvhscD", "templateVersion = " + String.valueOf(var41_64));
                    }
                    if (var41_64 != 255 && var40_63 != 0) {
                        var32_51 = this._nvramDInputStream.readUnsignedShort();
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM: profileID = " + var32_51);
                        }
                        var46_69 = new byte[32];
                        this._nvramDInputStream.readFully(var46_69);
                        var25_30 = new String(var46_69, "US-ASCII");
                        if (2 <= Trace.LEVEL) {
                            Trace.trace("apnvhscF", "name = " + var25_30);
                        }
                        var25_30 = var25_30.trim();
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("In buildNVRAM:  name = " + var25_30);
                            System.out.println("In buildNVRAM:  name = " + var25_30.trim());
                        }
                        if (var41_64 < 100) {
                            if (var41_64 < 50) {
                                var45_68.put("Name", new UnsignedInt16(var32_51));
                                var45_68.put("UserDefinedName", var25_30);
                                var47_70 = 0;
                                var47_70 = this._nvramDInputStream.readUnsignedShort();
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: numPartitionsInSys = " + var47_70);
                                }
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "numPartitionsInSys = " + String.valueOf(var47_70));
                                }
                                if (var47_70 != 0) {
                                    if (PIHMCSaveArea.DEBUG_ON) {
                                        System.out.println("numPartitionInSys != 0");
                                    }
                                    var48_71 /* !! */  = new Vector<Integer>();
                                    var48_71 /* !! */ .setSize(var47_70);
                                    for (var49_74 = 0; var49_74 < var47_70; ++var49_74) {
                                        if (PIHMCSaveArea.DEBUG_ON) {
                                            System.out.println("IN for loop");
                                        }
                                        var50_75 = this._nvramDInputStream.readUnsignedShort();
                                        var48_71 /* !! */ .setElementAt(new Integer(var50_75), var49_74);
                                        if (!PIHMCSaveArea.DEBUG_ON) continue;
                                        System.out.println("profile id = " + var50_75);
                                    }
                                    var45_68.put("ProfileList", var48_71 /* !! */ );
                                } else {
                                    var45_68.put("ProfileList", new Vector<E>());
                                }
                                var13_14 = new Object[]{new Integer(var29_45), new Short(var40_63), var45_68};
                                var48_71 /* !! */  = new Integer(var32_51);
                                this._profileTable.put(var48_71 /* !! */ , var13_14);
                                this._profilesAtPartitionTable[0].add(var48_71 /* !! */ );
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: timeStmap = " + var32_51 + " offset = " + var29_45 + " len = " + var40_63 + " properties = " + var45_68);
                                    System.out.println();
                                }
                            } else {
                                var47_70 = 0;
                                var45_68.put("SettingID", new UnsignedInt16(var32_51));
                                var45_68.put("UserDefinedName", var25_30);
                                var45_68.put("FullSysPartProf", new UnsignedInt8(1));
                                var47_70 = this._nvramDInputStream.readUnsignedShort();
                                var45_68.put("partitionID", new UnsignedInt16((int)var47_70));
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(var47_70));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: FSPM partitionID = " + var47_70);
                                }
                                var43_66 = (short)this._nvramDInputStream.readUnsignedByte();
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: bootMode = " + var43_66);
                                }
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "bootMode = " + String.valueOf(var43_66));
                                }
                                var45_68.put("BootMode", new UnsignedInt8(var43_66));
                                var48_72 = (short)this._nvramDInputStream.readUnsignedByte();
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "sfpSurveil = " + String.valueOf(var48_72));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM:sfpSurveil= " + var48_72);
                                }
                                var45_68.put("SFPSurveillance", new UnsignedInt8(var48_72));
                                var49_74 = (short)this._nvramDInputStream.readUnsignedByte();
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "virtHSLOptiConnect = " + String.valueOf(var49_74));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: virtHSLOptiConnect= " + var49_74);
                                }
                                var45_68.put("HSLOptiConnectPool", new UnsignedInt8(var49_74));
                                var50_76 = this._nvramDInputStream.readInt();
                                var50_76 &= -1L;
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "loadSrcDRCIndex = " + String.valueOf(var50_76));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: loadSrcDRCIndex = " + var50_76);
                                }
                                var45_68.put("LoadSourceDRCIndex", new UnsignedInt32(var50_76));
                                var52_79 = this._nvramDInputStream.readInt();
                                var52_79 &= -1L;
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "altLoadSrcDRCIndex = " + String.valueOf(var52_79));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: altLoadSrcDRCIndex = " + var52_79);
                                }
                                var45_68.put("AltLoadSourceDRCIndex", new UnsignedInt32(var52_79));
                                var54_82 = this._nvramDInputStream.readInt();
                                var54_82 &= -1L;
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "consoleDRCIndex = " + String.valueOf(var54_82));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: consoleDRCIndex = " + var54_82);
                                }
                                var45_68.put("ConsoleDRCIndex", new UnsignedInt32(var54_82));
                                var56_85 = this._nvramDInputStream.readInt();
                                var56_85 &= -1L;
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "altConsoleDRCIndex = " + String.valueOf(var56_85));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: altConsoleDRCIndex = " + var56_85);
                                }
                                var45_68.put("AltConsoleDRCIndex", new UnsignedInt32(var56_85));
                                var58_89 = this._nvramDInputStream.readInt();
                                var58_89 &= -1L;
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "ecsDRCIndex = " + String.valueOf(var58_89));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: ecsDRCIndex = " + var58_89);
                                }
                                var45_68.put("ECSDRCIndex", new UnsignedInt32(var58_89));
                                var60_91 = (short)this._nvramDInputStream.readUnsignedByte();
                                var61_92 = new Vector<Boolean>();
                                for (var62_95 = 0; var62_95 < this.SIZE_OF_TAGGED_IO_INFO_VECTOR; ++var62_95) {
                                    var63_96 = var60_91 >> var62_95 & 1;
                                    if (var63_96 == 1) {
                                        var61_92.addElement(new Boolean(true));
                                        continue;
                                    }
                                    var61_92.addElement(new Boolean(false));
                                }
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "TaggedIOInfo = " + String.valueOf(var60_91));
                                    Trace.trace("apnvhscF", "TaggedIOInfoVector = " + String.valueOf(var61_92));
                                }
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: TaggedIOInfo = " + var60_91);
                                    System.out.println("In buildNVRAM: TaggedIOInfoVector = " + var61_92);
                                }
                                var45_68.put("TaggedIOInfo", var61_92);
                                var13_14 = new Object[]{new Integer(var29_45), new Short(var40_63), var45_68};
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: profileID = " + var32_51 + " offset = " + var29_45 + " len = " + var40_63 + " properties = " + var45_68 + " partitionID = " + var47_70);
                                    System.out.println();
                                }
                                var62_94 = new Integer(var32_51);
                                this._profileTable.put(var62_94, var13_14);
                                this._profilesAtPartitionTable[var47_70].add(var62_94);
                            }
                        } else {
                            var47_70 = 0;
                            var45_68.put("SettingID", new UnsignedInt16(var32_51));
                            var45_68.put("UserDefinedName", var25_30);
                            var45_68.put("FullSysPartProf", new UnsignedInt8(0));
                            var47_70 = this._nvramDInputStream.readUnsignedShort();
                            var45_68.put("partitionID", new UnsignedInt16((int)var47_70));
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "partitionID = " + String.valueOf(var47_70));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: partitionID = " + var47_70);
                            }
                            var43_66 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: bootMode = " + var43_66);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "bootMode = " + String.valueOf(var43_66));
                            }
                            var45_68.put("BootMode", new UnsignedInt8(var43_66));
                            var48_73 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "sfpSurveil = " + String.valueOf(var48_73));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM:sfpSurveil= " + var48_73);
                            }
                            var45_68.put("SFPSurveillance", new UnsignedInt8(var48_73));
                            var49_74 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: numCPU = " + var49_74);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "desiredCPUNum = " + String.valueOf(var49_74));
                            }
                            var45_68.put("DesiredCPUCount", new UnsignedInt16((int)var49_74));
                            var50_77 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: minCPU = " + var50_77);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "requiredCPUNum = " + String.valueOf(var50_77));
                            }
                            var45_68.put("MinimumCPUCount", new UnsignedInt16(var50_77));
                            var51_78 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: maxCPU = " + var51_78);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "maxCPUNum = " + String.valueOf(var51_78));
                            }
                            var45_68.put("MaximumCPUCount", new UnsignedInt16(var51_78));
                            var52_80 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "procMode = " + String.valueOf(var52_80));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: procMode= " + var52_80);
                            }
                            var45_68.put("ProcMode", new UnsignedInt8(var52_80));
                            var53_81 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "sharingMode = " + String.valueOf(var53_81));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: sharingMode= " + var53_81);
                            }
                            var45_68.put("SharingMode", new UnsignedInt8(var53_81));
                            var54_83 = (short)this._nvramDInputStream.readUnsignedByte();
                            var55_84 = new Vector<Boolean>();
                            for (var56_86 = 0; var56_86 < this.SIZE_OF_TAGGED_IO_INFO_VECTOR; ++var56_86) {
                                var57_88 = var54_83 >> var56_86 & 1;
                                if (var57_88 == 1) {
                                    var55_84.addElement(new Boolean(true));
                                    continue;
                                }
                                var55_84.addElement(new Boolean(false));
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "TaggedIOInfo = " + String.valueOf(var54_83));
                                Trace.trace("apnvhscF", "TaggedIOInfoVector = " + String.valueOf(var55_84));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: TaggedIOInfo = " + var54_83);
                                System.out.println("In buildNVRAM: TaggedIOInfoVector = " + var55_84);
                            }
                            var45_68.put("TaggedIOInfo", var55_84);
                            var56_86 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "uncappedWeight = " + String.valueOf(var56_86));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: uncappedWeight= " + var56_86);
                            }
                            var45_68.put("UncappedWeight", new UnsignedInt8(var56_86));
                            var57_87 = this._nvramDInputStream.readInt();
                            var57_87 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "desiredProcUnits = " + String.valueOf(var57_87));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: desiredProcUnits = " + var57_87);
                            }
                            var45_68.put("DesiredProcUnit", new UnsignedInt32(var57_87));
                            var59_90 = this._nvramDInputStream.readInt();
                            var59_90 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "requiredProcUnits = " + String.valueOf(var59_90));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: requiredProcUnits = " + var59_90);
                            }
                            var45_68.put("MinProcUnit", new UnsignedInt32(var59_90));
                            var61_93 = this._nvramDInputStream.readInt();
                            var61_93 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "maxProcUnits = " + String.valueOf(var61_93));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: maxProcUnits = " + var61_93);
                            }
                            var45_68.put("MaxProcUnit", new UnsignedInt32(var61_93));
                            var63_97 = this._nvramDInputStream.readInt();
                            var63_97 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "desiredMemSize = " + String.valueOf(var63_97));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: memSize = " + var63_97);
                            }
                            var45_68.put("DesiredMemory", new UnsignedInt32(var63_97));
                            var65_98 = this._nvramDInputStream.readInt();
                            var65_98 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "requiredMemSize = " + String.valueOf(var65_98));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: minMem = " + var65_98);
                            }
                            var45_68.put("MinimumMemory", new UnsignedInt32(var65_98));
                            var67_99 = this._nvramDInputStream.readInt();
                            var67_99 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "maxMemSize = " + String.valueOf(var67_99));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: maxMem = " + var67_99);
                            }
                            var45_68.put("MaximumMemory", new UnsignedInt32(var67_99));
                            var69_100 = this.readUnsignedInt(this._nvramDInputStream);
                            var71_101 = this.readUnsignedInt(this._nvramDInputStream);
                            var73_102 = this.readUnsignedInt(this._nvramDInputStream);
                            var75_103 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "reserve1CurrMem = " + String.valueOf(var69_100));
                                Trace.trace("apnvhscF", "reserve1MaxMem = " + String.valueOf(var71_101));
                                Trace.trace("apnvhscF", "reserve1MinMem = " + String.valueOf(var73_102));
                                Trace.trace("apnvhscF", "reserve1Type = " + String.valueOf(var75_103));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: reserve1CurrMem = " + var69_100);
                                System.out.println("In buildNVRAM: reserve1MaxMem = " + var71_101);
                                System.out.println("In buildNVRAM: reserve1MinMem = " + var73_102);
                                System.out.println("In buildNVRAM: reserve1Type = " + var75_103);
                            }
                            var45_68.put("Reserve1CurrMem", new UnsignedInt32(var69_100));
                            var45_68.put("Reserve1MaxMem", new UnsignedInt32(var71_101));
                            var45_68.put("Reserve1MinMem", new UnsignedInt32(var73_102));
                            var45_68.put("Reserve1Type", new UnsignedInt8(var75_103));
                            var76_104 = this.readUnsignedInt(this._nvramDInputStream);
                            var78_105 = this.readUnsignedInt(this._nvramDInputStream);
                            var80_106 = this.readUnsignedInt(this._nvramDInputStream);
                            var82_107 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "reserve2CurrMem = " + String.valueOf(var76_104));
                                Trace.trace("apnvhscF", "reserve2MaxMem = " + String.valueOf(var78_105));
                                Trace.trace("apnvhscF", "reserve2MinMem = " + String.valueOf(var80_106));
                                Trace.trace("apnvhscF", "reserve2Type = " + String.valueOf(var82_107));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: reserve2CurrMem = " + var76_104);
                                System.out.println("In buildNVRAM: reserve2MaxMem = " + var78_105);
                                System.out.println("In buildNVRAM: reserve2MinMem = " + var80_106);
                                System.out.println("In buildNVRAM: reserve2Type = " + var82_107);
                            }
                            var45_68.put("Reserve2CurrMem", new UnsignedInt32(var76_104));
                            var45_68.put("Reserve2MaxMem", new UnsignedInt32(var78_105));
                            var45_68.put("Reserve2MinMem", new UnsignedInt32(var80_106));
                            var45_68.put("Reserve2Type", new UnsignedInt8(var82_107));
                            var83_108 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "autoIPLEnabled = " + String.valueOf(var83_108));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: autoIPLEnabled= " + var83_108);
                            }
                            var45_68.put("AutoIPLEnabled", new UnsignedInt8(var83_108));
                            var84_109 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "virtOptiConnect = " + String.valueOf(var84_109));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: virtOptiConnect= " + var84_109);
                            }
                            var45_68.put("VirtualOptiConnectPool", new UnsignedInt8(var84_109));
                            var85_110 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "virtHSLOptiConnect = " + String.valueOf(var85_110));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: virtHSLOptiConnect= " + var85_110);
                            }
                            var45_68.put("HSLOptiConnectPool", new UnsignedInt8(var85_110));
                            var86_111 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: desiredInteractPerf = " + var86_111);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "desiredInteractPerf = " + String.valueOf(var86_111));
                            }
                            var45_68.put("DesiredInteractivePerf", new UnsignedInt16(var86_111));
                            var87_112 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: minInteractPerf = " + var87_112);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "minInteractPerf = " + String.valueOf(var87_112));
                            }
                            var45_68.put("MinInteractivePerf", new UnsignedInt16(var87_112));
                            var88_113 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: maxInteractPerf = " + var88_113);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "maxInteractPerf = " + String.valueOf(var88_113));
                            }
                            var45_68.put("MaxInteractivePerf", new UnsignedInt16(var88_113));
                            var89_114 = this._nvramDInputStream.readInt();
                            var89_114 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "loadSrcDRCIndex = " + String.valueOf(var89_114));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: loadSrcDRCIndex = " + var89_114);
                            }
                            var45_68.put("LoadSourceDRCIndex", new UnsignedInt32(var89_114));
                            var91_115 = this._nvramDInputStream.readInt();
                            var91_115 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "altLoadSrcDRCIndex = " + String.valueOf(var91_115));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: altLoadSrcDRCIndex = " + var91_115);
                            }
                            var45_68.put("AltLoadSourceDRCIndex", new UnsignedInt32(var91_115));
                            var93_116 = this._nvramDInputStream.readInt();
                            var93_116 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "consoleDRCIndex = " + String.valueOf(var93_116));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: consoleDRCIndex = " + var93_116);
                            }
                            var45_68.put("ConsoleDRCIndex", new UnsignedInt32(var93_116));
                            var95_117 = this._nvramDInputStream.readInt();
                            var95_117 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "altConsoleDRCIndex = " + String.valueOf(var95_117));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: altConsoleDRCIndex = " + var95_117);
                            }
                            var45_68.put("AltConsoleDRCIndex", new UnsignedInt32(var95_117));
                            var97_118 = this._nvramDInputStream.readInt();
                            var97_118 &= -1L;
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "ecsDRCIndex = " + String.valueOf(var97_118));
                            }
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: ecsDRCIndex = " + var97_118);
                            }
                            var45_68.put("ECSDRCIndex", new UnsignedInt32(var97_118));
                            var99_119 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: numHostingPartitions = " + var99_119);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "numHostingPartitions = " + String.valueOf(var99_119));
                            }
                            if (var99_119 != 0) {
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("numHostingPartitions != 0");
                                }
                                var100_121 = new Vector<UnsignedInt16>();
                                var100_121.setSize(var99_119);
                                for (var101_122 = 0; var101_122 < var99_119; ++var101_122) {
                                    var102_123 = this._nvramDInputStream.readUnsignedShort();
                                    var100_121.setElementAt(new UnsignedInt16(var102_123), var101_122);
                                    if (!PIHMCSaveArea.DEBUG_ON) continue;
                                    System.out.println("partition id = " + var102_123);
                                }
                                var45_68.put("HostingPartitions", var100_121);
                            }
                            var100_120 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: maxVirtualSlots = " + var100_120);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "maxVirtualSlots = " + String.valueOf(var100_120));
                            }
                            var45_68.put("MaxVirtualSlots", new UnsignedInt16(var100_120));
                            var101_122 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: numVirtSerialConfig = " + var101_122);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "numVirtSerialConfig = " + String.valueOf(var101_122));
                            }
                            if (var101_122 != 0) {
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("numVirtSerialConfig != 0");
                                }
                                var102_124 = new Vector<UnsignedInt16>();
                                var103_127 = new Vector<Object>();
                                var104_129 = new Vector<Object>();
                                var105_131 = new Vector<Object>();
                                var106_132 = new Vector<Object>();
                                var107_133 = new Vector<UnsignedInt16>();
                                for (var108_136 = 0; var108_136 < var101_122; ++var108_136) {
                                    var109_139 = this._nvramDInputStream.readUnsignedShort();
                                    var110_144 = new UnsignedInt16(var109_139);
                                    var102_124.add(var110_144);
                                    var111_149 = (short)this._nvramDInputStream.readUnsignedByte();
                                    var112_156 = new UnsignedInt8(var111_149);
                                    var103_127.add(var112_156);
                                    var113_162 = (short)this._nvramDInputStream.readUnsignedByte();
                                    var114_167 = (short)(var113_162 >>> 3);
                                    var113_162 = (short)(var113_162 & 7);
                                    if (PIHMCSaveArea.DEBUG_ON) {
                                        System.out.println("REQUIRED BIT = " + var114_167);
                                        System.out.println("virtSerialSupportHMCClient = " + var113_162);
                                    }
                                    var115_171 = new UnsignedInt8(var113_162);
                                    var104_129.add(var115_171);
                                    var116_175 = null;
                                    var116_175 = var114_167 == 1 ? new String("R") : new String("D");
                                    var105_131.add(var116_175);
                                    var117_176 = this._nvramDInputStream.readUnsignedShort();
                                    var118_180 = new UnsignedInt16(var117_176);
                                    var106_132.add(var118_180);
                                    var119_184 = this._nvramDInputStream.readUnsignedShort();
                                    var120_188 = new UnsignedInt16(var119_184);
                                    var107_133.add(var120_188);
                                }
                                var45_68.put("VirSerialAdapters", var102_124);
                                var45_68.put("VirSerialDeviceAttributes", var103_127);
                                var45_68.put("VirSerialSupportHMCClients", var104_129);
                                var45_68.put("VirSerialSlotReqDesAttribute", var105_131);
                                var45_68.put("VirSerialServerLPARs", var106_132);
                                var45_68.put("VirSerialServerSlotNum", var107_133);
                            }
                            var102_123 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: numVirtSCSIConfig = " + var102_123);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "numVirtSCSIConfig = " + String.valueOf(var102_123));
                            }
                            if (var102_123 != 0) {
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("numVirtSCSIConfig != 0");
                                }
                                var103_127 = new Vector<E>();
                                var104_129 = new Vector<E>();
                                var105_131 = new Vector<E>();
                                var106_132 = new Vector<E>();
                                var107_133 = new Vector<E>();
                                var108_137 = new Vector<UnsignedInt16>();
                                for (var109_139 = 0; var109_139 < var102_123; ++var109_139) {
                                    var110_145 = this._nvramDInputStream.readUnsignedShort();
                                    var111_150 = new UnsignedInt16(var110_145);
                                    var103_127.add(var111_150);
                                    var112_157 = (short)this._nvramDInputStream.readUnsignedByte();
                                    var113_163 = new UnsignedInt8(var112_157);
                                    var104_129.add(var113_163);
                                    var114_167 = (short)this._nvramDInputStream.readUnsignedByte();
                                    var115_172 = (byte)(var114_167 >>> 3);
                                    var114_167 = (short)(var114_167 & 7);
                                    if (PIHMCSaveArea.DEBUG_ON) {
                                        System.out.println("REQUIRED BIT = " + var115_172);
                                        System.out.println("virtSCSISupportHMCClient = " + var114_167);
                                    }
                                    var116_175 = new UnsignedInt8(var114_167);
                                    var105_131.add(var116_175);
                                    var117_177 = null;
                                    var117_177 = var115_172 == 1 ? new String("R") : new String("D");
                                    var106_132.add(var117_177);
                                    var118_181 = this._nvramDInputStream.readUnsignedShort();
                                    var119_185 = new UnsignedInt16(var118_181);
                                    var107_133.add(var119_185);
                                    var120_189 = this._nvramDInputStream.readUnsignedShort();
                                    var121_192 = new UnsignedInt16(var120_189);
                                    var108_137.add(var121_192);
                                }
                                var45_68.put("VirSCSIAdapters", var103_127);
                                var45_68.put("VirSCSIDeviceAttributes", var104_129);
                                var45_68.put("VirSCSISupportHMCClients", var105_131);
                                var45_68.put("VirSCSISlotReqDesAttribute", var106_132);
                                var45_68.put("VirSCSIServerLPARs", var107_133);
                                var45_68.put("VirSCSIServerSlotNum", var108_137);
                            }
                            var103_126 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: numVirtSMCAConfig = " + var103_126);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "numVirtSMCAConfig = " + String.valueOf(var103_126));
                            }
                            if (var103_126 != 0) {
                                var104_129 = new Vector<E>();
                                var105_131 = new Vector<E>();
                                var106_132 = new Vector<E>();
                                var107_133 = new Vector<E>();
                                var108_138 = new Vector<UnsignedInt16>();
                                for (var109_139 = 0; var109_139 < var103_126; ++var109_139) {
                                    var110_146 = this._nvramDInputStream.readUnsignedShort();
                                    var111_151 = new UnsignedInt16(var110_146);
                                    var104_129.add(var111_151);
                                    var112_158 = this.readUnsignedInt(this._nvramDInputStream);
                                    var114_168 = new UnsignedInt32(var112_158);
                                    var105_131.add(var114_168);
                                    var115_173 = this.readUnsignedInt(this._nvramDInputStream);
                                    var117_178 = new UnsignedInt32(var115_173);
                                    var106_132.add(var117_178);
                                    var118_182 = this._nvramDInputStream.readUnsignedShort();
                                    var119_186 = new UnsignedInt16(var118_182);
                                    var107_133.add(var119_186);
                                    var120_190 = this._nvramDInputStream.readUnsignedShort();
                                    var121_192 = new UnsignedInt16(var120_190);
                                    var108_138.add(var121_192);
                                }
                                var45_68.put("SMCAVirSlotNum", var104_129);
                                var45_68.put("SMCADRCIndex", var105_131);
                                var45_68.put("SMCARIOBus", var106_132);
                                var45_68.put("SMCARemoteLparID", var107_133);
                                var45_68.put("SMCARemoteVirSlotNum", var108_138);
                            }
                            var104_128 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: numSlots = " + var104_128);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "numSlots = " + String.valueOf(var104_128));
                            }
                            if (var104_128 != 0) {
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("numSlots != 0");
                                }
                                var105_131 = new Vector<E>(var104_128);
                                var106_132 = new Vector<E>(var104_128);
                                var107_133 = new Vector<E>(var104_128);
                                for (var108_136 = 0; var108_136 < var104_128; ++var108_136) {
                                    var109_141 = this._nvramDInputStream.readInt();
                                    var111_152 = new UnsignedInt32(var109_141 &= -1L);
                                    var105_131.add(var111_152);
                                    var112_159 = (short)this._nvramDInputStream.readUnsignedByte();
                                    if (var112_159 == 1) {
                                        var106_132.add("r");
                                    } else {
                                        var106_132.add("d");
                                    }
                                    var113_164 = this._nvramDInputStream.readUnsignedShort();
                                    var114_169 = new UnsignedInt16(var113_164);
                                    var107_133.add(var114_169);
                                }
                                var45_68.put("IOSlots", var105_131);
                                var45_68.put("IORequirement", var106_132);
                                var45_68.put("IOPoolIDs", var107_133);
                            }
                            var105_130 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: numIOPools for partition = " + var105_130);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "numIOPools for partition = " + String.valueOf(var105_130));
                            }
                            if (var105_130 != 0) {
                                var106_132 = new Vector<E>(var105_130);
                                for (var107_134 = 0; var107_134 < var105_130; ++var107_134) {
                                    var108_136 = this._nvramDInputStream.readUnsignedShort();
                                    var109_142 = new UnsignedInt16(var108_136);
                                    var106_132.add(var109_142);
                                }
                                var45_68.put("PartitionIOPools", var106_132);
                            }
                            var106_132 = new Vector<E>();
                            var107_133 = new Vector<E>();
                            var108_136 = 0;
                            var109_139 = 0;
                            var109_139 = (short)this._nvramDInputStream.readUnsignedByte();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: Number of SMA Adapters = " + var109_139);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "Number SMA Adapters = " + String.valueOf(var109_139));
                            }
                            if (var109_139 == 0) {
                                var45_68.put("SNIConfigMode", new UnsignedInt8((short)var108_136));
                                var45_68.put("SNIDeviceID", var106_132);
                                var45_68.put("SNIWindows", var107_133);
                            } else {
                                var108_136 = (short)this._nvramDInputStream.readUnsignedByte();
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: SMA Config Mode = " + var108_136);
                                }
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "SMA Config Mode = " + String.valueOf(var108_136));
                                }
                                var45_68.put("SNIConfigMode", new UnsignedInt8((short)var108_136));
                                for (var110_147 = 0; var110_147 < var109_139; ++var110_147) {
                                    var111_153 = this._nvramDInputStream.readInt();
                                    var113_165 = String.valueOf(var111_153 &= -1L);
                                    var106_132.add(var113_165);
                                }
                                for (var110_147 = 0; var110_147 < var109_139; ++var110_147) {
                                    var111_154 = this._nvramDInputStream.readUnsignedShort();
                                    var112_160 = new UnsignedInt16(var111_154);
                                    var107_133.add(var112_160);
                                }
                                var45_68.put("SNIDeviceID", var106_132);
                                var45_68.put("SNIWindows", var107_133);
                            }
                            var110_143 = this._nvramDInputStream.readUnsignedShort();
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVARM: numVLANSlots = " + var110_143);
                            }
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "numVLANSlots = " + String.valueOf(var110_143));
                            }
                            if (var110_143 != 0) {
                                if (PIHMCSaveArea.DEBUG_ON) {
                                    System.out.println("numVLANSlots != 0");
                                }
                                var111_155 = new Vector<UnsignedInt16>();
                                var112_161 = new Vector<UnsignedInt8>();
                                var113_166 = new Vector<UnsignedInt8>();
                                var114_170 = new Vector<String>();
                                var115_174 = new Vector<UnsignedInt16>();
                                var116_175 = new Vector<E>();
                                var117_179 = new Vector<UnsignedInt16>();
                                for (var118_183 = 0; var118_183 < var110_143; ++var118_183) {
                                    var119_187 = this._nvramDInputStream.readUnsignedShort();
                                    var120_191 = new UnsignedInt16(var119_187);
                                    var111_155.add(var120_191);
                                    var121_193 = (short)this._nvramDInputStream.readUnsignedByte();
                                    var122_194 = new UnsignedInt8(var121_193);
                                    var112_161.add(var122_194);
                                    var123_195 = (short)this._nvramDInputStream.readUnsignedByte();
                                    var124_196 = (byte)(var123_195 >>> 3);
                                    var123_195 = (short)(var123_195 & 7);
                                    var125_197 = new UnsignedInt8(var123_195);
                                    var113_166.add(var125_197);
                                    if (PIHMCSaveArea.DEBUG_ON) {
                                        System.out.println("REQUIRED BIT = " + var124_196);
                                        System.out.println("trunkAdapter = " + var123_195);
                                    }
                                    var126_198 = null;
                                    var126_198 = var124_196 == 1 ? new String("R") : new String("D");
                                    var114_170.add(var126_198);
                                    var127_199 = this._nvramDInputStream.readUnsignedShort();
                                    var128_200 = new UnsignedInt16(var127_199);
                                    var115_174.add(var128_200);
                                    var129_201 = this._nvramDInputStream.readUnsignedShort();
                                    var130_202 = new UnsignedInt16(var129_201);
                                    var116_175.add(var130_202);
                                    if (var129_201 == 0) continue;
                                    for (var131_203 = 0; var131_203 < var129_201; ++var131_203) {
                                        var132_204 = this._nvramDInputStream.readUnsignedShort();
                                        var133_205 = new UnsignedInt16(var132_204);
                                        var117_179.add(var133_205);
                                    }
                                }
                                var45_68.put("VirtualLanSlotIDs", var111_155);
                                var45_68.put("IEEE", var112_161);
                                var45_68.put("VLANTrunkAdapter", var113_166);
                                var45_68.put("VLANSlotReqDesAttribute", var114_170);
                                var45_68.put("PVLANID", var115_174);
                                var45_68.put("AddVlanNum", var116_175);
                                var45_68.put("AddVlans", var117_179);
                            }
                            var13_14 = new Object[]{new Integer(var29_45), new Short(var40_63), var45_68};
                            if (PIHMCSaveArea.DEBUG_ON) {
                                System.out.println("In buildNVRAM: profileID = " + var32_51 + " offset = " + var29_45 + " len = " + var40_63 + " properties = " + var45_68 + " partitionID = " + var47_70);
                                System.out.println();
                            }
                            var111_148 = new Integer(var32_51);
                            this._profileTable.put(var111_148, var13_14);
                            this._profilesAtPartitionTable[var47_70].add(var111_148);
                        }
                        this._nvramDataSize = var29_45 += var40_63;
                        continue;
                    }
                    if (var41_64 == 255) {
                        if (3 <= Trace.LEVEL) {
                            Trace.trace("apnvhscD", "Invalid profile - Skip the profile");
                        }
                        if (PIHMCSaveArea.DEBUG_ON) {
                            System.out.println("Invalid profile");
                            System.out.println();
                        }
                        this._nvramDInputStream.skipBytes(var40_63 - 3);
                        this._nvramDataSize = var29_45 += var40_63;
                        continue;
                    }
                    var29_45 = this._nvramData.length;
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("apnvhscD", "No more profile - EXIT");
                    }
                    if (!PIHMCSaveArea.DEBUG_ON) continue;
                    System.out.println("In buildNVRAM: no more profile");
                }
                break block295;
lbl1295:
                // 1 sources

                if (3 <= Trace.LEVEL) {
                    Trace.trace("apnvhscD", "DRAWER_PROFILE_INFO NOT change - drawer and profiles dont' need to be updated");
                }
                if (PIHMCSaveArea.DEBUG_ON) {
                    System.out.println("drawer and profiles don't need to be update");
                }
                if (this._nvramDataSize <= 0) {
                    this._nvramDataSize = var37_56;
                }
            }
            if (var3_3) {
                this._backupToLocalFile();
            }
            if (var12_13 > var10_11 && var11_12 > this._templateVersion || this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                System.out.println("in buildNVRAM: CALLING migration ==============================");
                System.out.println("fspVerIndex = " + var12_13);
                System.out.println("templateVerIndex = " + var10_11);
                System.out.println("NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                System.out.println("_releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                this.migration();
            }
            {
                catch (Throwable var38_58) {
                    var38_58.printStackTrace();
                    HSCLogUtils.serverLog(var38_58, HSCLogUtils._NVRAMClassLogInfo);
                    if (var38_58 instanceof PIHscServerException) {
                        throw (PIHscServerException)var38_58;
                    }
                    throw new PIHscServerException("0007", var38_58);
                }
            }
            var135_36 = null;
            if (PIHMCSaveArea.DEBUG_ON) {
                System.out.println("End of buildNVRAM");
                System.out.println("********************************************");
                System.out.println();
                System.out.println();
            }
            {
                catch (Throwable var134_206) {
                    var135_37 = null;
                    if (PIHMCSaveArea.DEBUG_ON) {
                        System.out.println("End of buildNVRAM");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                    throw var134_206;
                }
            }
            var23_24 = var6_6;
            return (boolean)var23_24;
        }
        catch (Throwable var7_8) {
            var7_8.printStackTrace();
            HSCLogUtils.serverLog(var7_8, HSCLogUtils._NVRAMClassLogInfo);
            if (var7_8 instanceof PIHscServerException) {
                throw (PIHscServerException)var7_8;
            }
            throw new PIHscServerException("000A", var7_8);
        }
        catch (Throwable var136_207) {
            throw var136_207;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- buildNVRAM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getActivatedLPARProfile(short s) throws PIHscServerException {
        Hashtable hashtable;
        block16: {
            int n = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getActivatedLPARProfile");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getActivatedLPARProfile: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                hashtable = this._getActivatedLPARProfile(s, true);
                Object var8_9 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("000B", throwable);
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return hashtable;
    }

    /*
     * Exception decompiling
     */
    private Hashtable _getActivatedLPARProfile(short var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getActivatedSysProfile() throws PIHscServerException {
        Hashtable hashtable;
        block16: {
            int n = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getActivatedSysProfile");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getActivatedSysProfile: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                hashtable = this._getActivatedSysProfile(true);
                Object var7_8 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("000C", throwable);
                }
                catch (Throwable throwable2) {
                    Object var7_9 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return hashtable;
    }

    /*
     * Exception decompiling
     */
    private Hashtable _getActivatedSysProfile(boolean var1_1) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllSysProfiles() throws PIHscServerException {
        Vector vector;
        block16: {
            int n = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getAllSysProfiles");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getAllSysProfiles: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                vector = this._getAllSysProfiles(true);
                Object var7_8 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("000D", throwable);
                }
                catch (Throwable throwable2) {
                    Object var7_9 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return vector;
    }

    /*
     * Exception decompiling
     */
    private Vector _getAllSysProfiles(boolean var1_1) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDefaultLPARProfile(int n) throws PIHscServerException {
        Hashtable hashtable;
        block16: {
            int n2 = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getDefaultLPARProfile");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getDefaultLPARProfile: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                hashtable = this._getDefaultLPARProfile(n, true);
                Object var8_9 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("000E", throwable);
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return hashtable;
    }

    /*
     * Exception decompiling
     */
    private Hashtable _getDefaultLPARProfile(int var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDefaultSysProfile() throws PIHscServerException {
        Hashtable hashtable;
        block16: {
            int n = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getDefaultSysProfile");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getDefaultSysProfile: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                hashtable = this._getDefaultSysProfile(true);
                Object var7_8 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("000F", throwable);
                }
                catch (Throwable throwable2) {
                    Object var7_9 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return hashtable;
    }

    /*
     * Exception decompiling
     */
    private Hashtable _getDefaultSysProfile(boolean var1_1) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getLPARProfile(int n) throws PIHscServerException {
        Hashtable hashtable;
        block15: {
            int n2 = 128;
            boolean bl = false;
            try {
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getLPARProfile: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                hashtable = this._getLPARProfile(n, true);
                Object var8_9 = null;
                if (!bl) break block15;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0010", throwable);
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return hashtable;
    }

    /*
     * Exception decompiling
     */
    private Hashtable _getLPARProfile(int var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getLPARProfilesAtPartition(int n) throws PIHscServerException {
        Vector vector;
        block15: {
            int n2 = 128;
            boolean bl = false;
            try {
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getLPARProfilesAtPartition: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                vector = this._getLPARProfilesAtPartition(n, true);
                Object var8_9 = null;
                if (!bl) break block15;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0011", throwable);
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return vector;
    }

    /*
     * Exception decompiling
     */
    private Vector _getLPARProfilesAtPartition(int var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getSysProfile(int n) throws PIHscServerException {
        Hashtable hashtable;
        block16: {
            int n2 = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getSysProfile");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getSysProfile: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                hashtable = this._getSysProfile(n, true);
                Object var8_9 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0012", throwable);
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return hashtable;
    }

    /*
     * Exception decompiling
     */
    private Hashtable _getSysProfile(int var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeLPARProfile(int n) throws PIHscServerException {
        block13: {
            int n2 = 1;
            boolean bl = false;
            try {
                try {
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in removeLPARProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._removeLPARProfile(n, true);
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0013", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var8_7 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * Exception decompiling
     */
    private int[] _removeLPARProfile(int var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeSysProfile(int n) throws PIHscServerException {
        block14: {
            int n2 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In removeSysProfile");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in removeSysProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._removeSysProfile(n, true);
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0014", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var8_7 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * Exception decompiling
     */
    private void _removeSysProfile(int var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLPARProfile(String string, int n, Hashtable hashtable, String string2) throws PIHscServerException {
        boolean bl;
        int n2;
        block17: {
            block15: {
                block16: {
                    n2 = 1;
                    bl = false;
                    try {
                        try {
                            short s;
                            Object object = this.saveAreaFileSyncObj;
                            synchronized (object) {
                                while (this.isSaveAreaFileOpen) {
                                    try {
                                        if (DEBUG_ON) {
                                            System.out.println("Waiting for file to close....");
                                        }
                                        Thread.sleep(200L);
                                    }
                                    catch (Exception exception) {}
                                }
                                this.isSaveAreaFileOpen = true;
                            }
                            object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                            if (object == null) {
                                if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                                System.out.println("in saveLPARProfile: open file failed");
                                throw new PIHscServerException("004c", null);
                            }
                            bl = true;
                            if (hashtable.get("FullSysPartProf") != null && (s = ((UnsignedInt8)hashtable.get("FullSysPartProf")).shortValue()) == 1) {
                                this._saveFSPMProfile(string, n, hashtable, string2, true);
                                Object var11_11 = null;
                                if (!bl) break block15;
                                break block16;
                            }
                            this._saveLPARProfile(string, n, hashtable, string2, true);
                            break block17;
                        }
                        catch (Throwable throwable) {
                            n2 = 255;
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                            if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0015", throwable);
                            throw (PIHscServerException)throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (bl) {
                            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                        }
                        this.isSaveAreaFileOpen = false;
                        throw throwable;
                    }
                }
                this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
            }
            this.isSaveAreaFileOpen = false;
            return;
        }
        Object var11_12 = null;
        if (bl) {
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * Exception decompiling
     */
    private void _saveFSPMProfile(String var1_1, int var2_2, Hashtable var3_3, String var4_4, boolean var5_5) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void _saveLPARProfile(String var1_1, int var2_2, Hashtable var3_3, String var4_4, boolean var5_5) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveSysProfile(String string, int n, Hashtable hashtable, String string2) throws PIHscServerException {
        block14: {
            int n2 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In saveSysProfile");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in saveSysProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._saveSysProfile(string, n, hashtable, string2, true);
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0016", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var11_10 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveSysProfile(int n, Hashtable hashtable, String string) throws PIHscServerException {
        block14: {
            int n2 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In saveSysProfile");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in saveSysProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._saveSysProfile(n, hashtable, string, true);
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0016", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var10_9 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _saveSysProfile(int n, Hashtable hashtable, String string, boolean bl) throws PIHscServerException {
        block16: {
            try {
                Hashtable hashtable2;
                if (1 <= Trace.LEVEL) {
                    Trace.trace("apnvhscT", "-> _saveSysProfile");
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apnvhscF", "profileID = " + n);
                    Trace.trace("apnvhscF", "properties = " + hashtable);
                    Trace.trace("apnvhscF", "newName = " + string);
                }
                if (DEBUG_ON) {
                    System.out.println("********************************************");
                    System.out.println("In _saveSysProfile");
                }
                try {
                    if (bl) {
                        this.buildNVRAM(false, null, true, true, false);
                    }
                    Object[] objectArray = new Object[3];
                    Integer n2 = new Integer(n);
                    objectArray = (Object[])this._profileTable.get(n2);
                    hashtable2 = (Hashtable)objectArray[2];
                    if (hashtable2 == null) {
                        Object var10_9 = null;
                        if (DEBUG_ON) {
                            System.out.println("End of _saveSysProfile");
                            System.out.println("***********************************************");
                            System.out.println();
                            System.out.println();
                        }
                        if (1 > Trace.LEVEL) return;
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (!DEBUG_ON) throw throwable;
                    System.out.println("End of _saveSysProfile");
                    System.out.println("***********************************************");
                    System.out.println();
                    System.out.println();
                    throw throwable;
                }
                {
                    String string2 = (String)hashtable2.get("UserDefinedName");
                    this._saveSysProfile(string2, n, hashtable, string, true);
                    Object var10_10 = null;
                    if (!DEBUG_ON) return;
                    System.out.println("End of _saveSysProfile");
                    System.out.println("***********************************************");
                    System.out.println();
                    System.out.println();
                    return;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0016", throwable);
                throw (PIHscServerException)throwable;
            }
        }
        Trace.trace("apnvhscT", "<- _saveSysProfile");
        return;
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- _saveSysProfile");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void _saveSysProfile(String var1_1, int var2_2, Hashtable var3_3, String var4_4, boolean var5_5) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createLPARProfile(int n, String string, Hashtable hashtable) throws PIHscServerException {
        int n2;
        block18: {
            boolean bl;
            int n3;
            int n4;
            block16: {
                int n5;
                block17: {
                    n4 = 1;
                    n3 = 0;
                    bl = false;
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (DEBUG_ON) {
                            System.out.println("in createLPARProfile: open file failed");
                        }
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    System.out.println("================================================================================");
                    System.out.println("================================================================================");
                    System.out.println("================================================================================");
                    System.out.println("properties = " + hashtable);
                    if (hashtable.get("FullSysPartProf") == null) break block16;
                    System.out.println("=================== GOT A PROPERTY =============================================================");
                    short s = ((UnsignedInt8)hashtable.get("FullSysPartProf")).shortValue();
                    System.out.println("=================== GOT A PROPERTY = " + s);
                    if (s != 1) break block16;
                    n5 = n3 = this._createFSPMProfile(n, string, hashtable, true);
                    Object var11_14 = null;
                    if (!bl) break block17;
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n4);
                }
                this.isSaveAreaFileOpen = false;
                return n5;
            }
            try {
                n2 = n3 = this._createLPARProfile(n, string, hashtable, true);
                Object var11_15 = null;
                if (!bl) break block18;
            }
            catch (Throwable throwable) {
                try {
                    n4 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0017", throwable);
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n4);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n4);
        }
        this.isSaveAreaFileOpen = false;
        return n2;
    }

    /*
     * Exception decompiling
     */
    private int _createFSPMProfile(int var1_1, String var2_2, Hashtable var3_3, boolean var4_4) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int _createFSPMProfile_2(int var1_1, String var2_2, Hashtable var3_3, boolean var4_4) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int _createLPARProfile(int var1_1, String var2_2, Hashtable var3_3, boolean var4_4) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createSysProfile(String string, Hashtable hashtable) throws PIHscServerException {
        int n;
        block16: {
            int n2 = 1;
            boolean bl = false;
            try {
                int n3;
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In createSysProfile");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in createSysProfile: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                n = n3 = this._createSysProfile(string, hashtable, true);
                Object var10_11 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                try {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0018", throwable);
                }
                catch (Throwable throwable2) {
                    Object var10_12 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return n;
    }

    /*
     * Exception decompiling
     */
    private int _createSysProfile(String var1_1, Hashtable var2_2, boolean var3_3) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setActivatedLPARProfile(int n, int n2) throws PIHscServerException {
        block14: {
            int n3 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setActivatedLPARProfile");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    int n4 = (Integer)this.saveAreaDataTableOffsets.get(PROFILE_INFO_CHECKSUM);
                    FspFileOpenResponse fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n4);
                    if (fspFileOpenResponse == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setActivatedLPARProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._setActivatedLPARProfile(n, n2, true);
                }
                catch (Throwable throwable) {
                    n3 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0019", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var9_10 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * Exception decompiling
     */
    private void _setActivatedLPARProfile(int var1_1, int var2_2, boolean var3_3) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDefaultLPARProfile(int n, int n2) throws PIHscServerException {
        block14: {
            int n3 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setDefaultLPARProfile");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    int n4 = (Integer)this.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE_CHECKSUM);
                    FspFileOpenResponse fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n4);
                    if (fspFileOpenResponse == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setDefaultLPARProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._setDefaultLPARProfile(n, n2, true);
                }
                catch (Throwable throwable) {
                    n3 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("001B", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var9_10 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * Exception decompiling
     */
    private void _setDefaultLPARProfile(int var1_1, int var2_2, boolean var3_3) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cleanUp() throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTime(byte[] byArray, byte[] byArray2) {
        int n;
        block96: {
            block62: {
                int n2;
                block95: {
                    block93: {
                        int n3;
                        block94: {
                            int n4;
                            int n5;
                            block91: {
                                int n6;
                                block92: {
                                    block89: {
                                        int n7;
                                        block90: {
                                            byte by;
                                            byte by2;
                                            block87: {
                                                int n8;
                                                block88: {
                                                    block85: {
                                                        int n9;
                                                        block86: {
                                                            byte by3;
                                                            byte by4;
                                                            block83: {
                                                                int n10;
                                                                block84: {
                                                                    block81: {
                                                                        int n11;
                                                                        block82: {
                                                                            byte by5;
                                                                            byte by6;
                                                                            block79: {
                                                                                int n12;
                                                                                block80: {
                                                                                    block77: {
                                                                                        int n13;
                                                                                        block78: {
                                                                                            byte by7;
                                                                                            byte by8;
                                                                                            block75: {
                                                                                                int n14;
                                                                                                block76: {
                                                                                                    block73: {
                                                                                                        int n15;
                                                                                                        block74: {
                                                                                                            byte by9;
                                                                                                            byte by10;
                                                                                                            block71: {
                                                                                                                int n16;
                                                                                                                block72: {
                                                                                                                    block69: {
                                                                                                                        int n17;
                                                                                                                        block70: {
                                                                                                                            int n18;
                                                                                                                            int n19;
                                                                                                                            block67: {
                                                                                                                                int n20;
                                                                                                                                block68: {
                                                                                                                                    block65: {
                                                                                                                                        int n21;
                                                                                                                                        block66: {
                                                                                                                                            block63: {
                                                                                                                                                int n22;
                                                                                                                                                block64: {
                                                                                                                                                    if (1 <= Trace.LEVEL) {
                                                                                                                                                        Trace.trace("apnvhscT", "-> compareTime");
                                                                                                                                                    }
                                                                                                                                                    if (2 <= Trace.LEVEL) {
                                                                                                                                                        Trace.trace("apnvhscF", "time1 = " + byArray);
                                                                                                                                                        Trace.trace("apnvhscF", "time2 = " + byArray2);
                                                                                                                                                    }
                                                                                                                                                    if (DEBUG_ON) {
                                                                                                                                                        System.out.print("********************");
                                                                                                                                                        System.out.println("*********************");
                                                                                                                                                        System.out.println("In compareTime method");
                                                                                                                                                    }
                                                                                                                                                    try {
                                                                                                                                                        if (byArray.length != 11 || byArray2.length != 11) break block62;
                                                                                                                                                        if (byArray[0] != 0 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 0 || byArray[4] != 0 || byArray[5] != 0 || byArray[6] != 0 || byArray[7] != 0 || byArray[8] != 0 || byArray[9] != 0 || byArray[10] != 0) break block63;
                                                                                                                                                        n22 = -1;
                                                                                                                                                        Object var19_7 = null;
                                                                                                                                                        if (1 > Trace.LEVEL) break block64;
                                                                                                                                                    }
                                                                                                                                                    catch (Throwable throwable) {
                                                                                                                                                        block97: {
                                                                                                                                                            Object var19_25 = null;
                                                                                                                                                            if (1 <= Trace.LEVEL) {
                                                                                                                                                                Trace.trace("apnvhscT", "<- compareTime");
                                                                                                                                                            }
                                                                                                                                                            if (!DEBUG_ON) break block97;
                                                                                                                                                            System.out.println("End of compareTime method");
                                                                                                                                                            System.out.print("********************");
                                                                                                                                                            System.out.println("********************");
                                                                                                                                                        }
                                                                                                                                                        throw throwable;
                                                                                                                                                    }
                                                                                                                                                    Trace.trace("apnvhscT", "<- compareTime");
                                                                                                                                                }
                                                                                                                                                if (DEBUG_ON) {
                                                                                                                                                    System.out.println("End of compareTime method");
                                                                                                                                                    System.out.print("********************");
                                                                                                                                                    System.out.println("********************");
                                                                                                                                                }
                                                                                                                                                return n22;
                                                                                                                                            }
                                                                                                                                            if (byArray2[0] != 0 || byArray2[1] != 0 || byArray2[2] != 0 || byArray2[3] != 0 || byArray2[4] != 0 || byArray2[5] != 0 || byArray2[6] != 0 || byArray2[7] != 0 || byArray2[8] != 0 || byArray2[9] != 0 || byArray2[10] != 0) break block65;
                                                                                                                                            n21 = 1;
                                                                                                                                            Object var19_8 = null;
                                                                                                                                            if (1 > Trace.LEVEL) break block66;
                                                                                                                                            Trace.trace("apnvhscT", "<- compareTime");
                                                                                                                                        }
                                                                                                                                        if (DEBUG_ON) {
                                                                                                                                            System.out.println("End of compareTime method");
                                                                                                                                            System.out.print("********************");
                                                                                                                                            System.out.println("********************");
                                                                                                                                        }
                                                                                                                                        return n21;
                                                                                                                                    }
                                                                                                                                    n19 = byArray[0] << 8 | 0xFF & byArray[1];
                                                                                                                                    if (DEBUG_ON) {
                                                                                                                                        System.out.println("In compareTime: year1 = " + n19);
                                                                                                                                    }
                                                                                                                                    if (3 <= Trace.LEVEL) {
                                                                                                                                        Trace.trace("apnvhscD", "year1 = " + String.valueOf(n19));
                                                                                                                                    }
                                                                                                                                    n18 = byArray2[0] << 8 | 0xFF & byArray2[1];
                                                                                                                                    if (DEBUG_ON) {
                                                                                                                                        System.out.println("In compareTime: year2 = " + n18);
                                                                                                                                    }
                                                                                                                                    if (3 <= Trace.LEVEL) {
                                                                                                                                        Trace.trace("apnvhscD", "year2 = " + String.valueOf(n18));
                                                                                                                                    }
                                                                                                                                    if (n19 <= n18) break block67;
                                                                                                                                    n20 = 1;
                                                                                                                                    Object var19_9 = null;
                                                                                                                                    if (1 > Trace.LEVEL) break block68;
                                                                                                                                    Trace.trace("apnvhscT", "<- compareTime");
                                                                                                                                }
                                                                                                                                if (DEBUG_ON) {
                                                                                                                                    System.out.println("End of compareTime method");
                                                                                                                                    System.out.print("********************");
                                                                                                                                    System.out.println("********************");
                                                                                                                                }
                                                                                                                                return n20;
                                                                                                                            }
                                                                                                                            if (n18 <= n19) break block69;
                                                                                                                            n17 = -1;
                                                                                                                            Object var19_10 = null;
                                                                                                                            if (1 > Trace.LEVEL) break block70;
                                                                                                                            Trace.trace("apnvhscT", "<- compareTime");
                                                                                                                        }
                                                                                                                        if (DEBUG_ON) {
                                                                                                                            System.out.println("End of compareTime method");
                                                                                                                            System.out.print("********************");
                                                                                                                            System.out.println("********************");
                                                                                                                        }
                                                                                                                        return n17;
                                                                                                                    }
                                                                                                                    by10 = byArray[2];
                                                                                                                    if (3 <= Trace.LEVEL) {
                                                                                                                        Trace.trace("apnvhscD", "month1 = " + String.valueOf(byArray[2]));
                                                                                                                    }
                                                                                                                    by9 = byArray2[2];
                                                                                                                    if (3 <= Trace.LEVEL) {
                                                                                                                        Trace.trace("apnvhscD", "year2 = " + String.valueOf(byArray2[2]));
                                                                                                                    }
                                                                                                                    if (by10 <= by9) break block71;
                                                                                                                    n16 = 1;
                                                                                                                    Object var19_11 = null;
                                                                                                                    if (1 > Trace.LEVEL) break block72;
                                                                                                                    Trace.trace("apnvhscT", "<- compareTime");
                                                                                                                }
                                                                                                                if (DEBUG_ON) {
                                                                                                                    System.out.println("End of compareTime method");
                                                                                                                    System.out.print("********************");
                                                                                                                    System.out.println("********************");
                                                                                                                }
                                                                                                                return n16;
                                                                                                            }
                                                                                                            if (by9 <= by10) break block73;
                                                                                                            n15 = -1;
                                                                                                            Object var19_12 = null;
                                                                                                            if (1 > Trace.LEVEL) break block74;
                                                                                                            Trace.trace("apnvhscT", "<- compareTime");
                                                                                                        }
                                                                                                        if (DEBUG_ON) {
                                                                                                            System.out.println("End of compareTime method");
                                                                                                            System.out.print("********************");
                                                                                                            System.out.println("********************");
                                                                                                        }
                                                                                                        return n15;
                                                                                                    }
                                                                                                    by8 = byArray[3];
                                                                                                    if (3 <= Trace.LEVEL) {
                                                                                                        Trace.trace("apnvhscD", "day1 = " + String.valueOf(byArray[3]));
                                                                                                    }
                                                                                                    by7 = byArray2[3];
                                                                                                    if (3 <= Trace.LEVEL) {
                                                                                                        Trace.trace("apnvhscD", "day2 = " + String.valueOf(byArray2[3]));
                                                                                                    }
                                                                                                    if (by8 <= by7) break block75;
                                                                                                    if (DEBUG_ON) {
                                                                                                        System.out.println("End of compareTime method");
                                                                                                    }
                                                                                                    n14 = 1;
                                                                                                    Object var19_13 = null;
                                                                                                    if (1 > Trace.LEVEL) break block76;
                                                                                                    Trace.trace("apnvhscT", "<- compareTime");
                                                                                                }
                                                                                                if (DEBUG_ON) {
                                                                                                    System.out.println("End of compareTime method");
                                                                                                    System.out.print("********************");
                                                                                                    System.out.println("********************");
                                                                                                }
                                                                                                return n14;
                                                                                            }
                                                                                            if (by7 <= by8) break block77;
                                                                                            n13 = -1;
                                                                                            Object var19_14 = null;
                                                                                            if (1 > Trace.LEVEL) break block78;
                                                                                            Trace.trace("apnvhscT", "<- compareTime");
                                                                                        }
                                                                                        if (DEBUG_ON) {
                                                                                            System.out.println("End of compareTime method");
                                                                                            System.out.print("********************");
                                                                                            System.out.println("********************");
                                                                                        }
                                                                                        return n13;
                                                                                    }
                                                                                    by6 = byArray[4];
                                                                                    if (3 <= Trace.LEVEL) {
                                                                                        Trace.trace("apnvhscD", "hour1 = " + String.valueOf(byArray[4]));
                                                                                    }
                                                                                    by5 = byArray2[4];
                                                                                    if (3 <= Trace.LEVEL) {
                                                                                        Trace.trace("apnvhscD", "hour2 = " + String.valueOf(byArray2[4]));
                                                                                    }
                                                                                    if (by6 <= by5) break block79;
                                                                                    n12 = 1;
                                                                                    Object var19_15 = null;
                                                                                    if (1 > Trace.LEVEL) break block80;
                                                                                    Trace.trace("apnvhscT", "<- compareTime");
                                                                                }
                                                                                if (DEBUG_ON) {
                                                                                    System.out.println("End of compareTime method");
                                                                                    System.out.print("********************");
                                                                                    System.out.println("********************");
                                                                                }
                                                                                return n12;
                                                                            }
                                                                            if (by5 <= by6) break block81;
                                                                            n11 = -1;
                                                                            Object var19_16 = null;
                                                                            if (1 > Trace.LEVEL) break block82;
                                                                            Trace.trace("apnvhscT", "<- compareTime");
                                                                        }
                                                                        if (DEBUG_ON) {
                                                                            System.out.println("End of compareTime method");
                                                                            System.out.print("********************");
                                                                            System.out.println("********************");
                                                                        }
                                                                        return n11;
                                                                    }
                                                                    by4 = byArray[5];
                                                                    if (3 <= Trace.LEVEL) {
                                                                        Trace.trace("apnvhscD", "minute1 = " + String.valueOf(byArray[5]));
                                                                    }
                                                                    by3 = byArray2[5];
                                                                    if (3 <= Trace.LEVEL) {
                                                                        Trace.trace("apnvhscD", "minute2 = " + String.valueOf(byArray2[5]));
                                                                    }
                                                                    if (by4 <= by3) break block83;
                                                                    n10 = 1;
                                                                    Object var19_17 = null;
                                                                    if (1 > Trace.LEVEL) break block84;
                                                                    Trace.trace("apnvhscT", "<- compareTime");
                                                                }
                                                                if (DEBUG_ON) {
                                                                    System.out.println("End of compareTime method");
                                                                    System.out.print("********************");
                                                                    System.out.println("********************");
                                                                }
                                                                return n10;
                                                            }
                                                            if (by3 <= by4) break block85;
                                                            n9 = -1;
                                                            Object var19_18 = null;
                                                            if (1 > Trace.LEVEL) break block86;
                                                            Trace.trace("apnvhscT", "<- compareTime");
                                                        }
                                                        if (DEBUG_ON) {
                                                            System.out.println("End of compareTime method");
                                                            System.out.print("********************");
                                                            System.out.println("********************");
                                                        }
                                                        return n9;
                                                    }
                                                    by2 = byArray[6];
                                                    if (3 <= Trace.LEVEL) {
                                                        Trace.trace("apnvhscD", "second1 = " + String.valueOf(byArray[6]));
                                                    }
                                                    by = byArray2[6];
                                                    if (3 <= Trace.LEVEL) {
                                                        Trace.trace("apnvhscD", "second2 = " + String.valueOf(byArray2[6]));
                                                    }
                                                    if (by2 <= by) break block87;
                                                    n8 = 1;
                                                    Object var19_19 = null;
                                                    if (1 > Trace.LEVEL) break block88;
                                                    Trace.trace("apnvhscT", "<- compareTime");
                                                }
                                                if (DEBUG_ON) {
                                                    System.out.println("End of compareTime method");
                                                    System.out.print("********************");
                                                    System.out.println("********************");
                                                }
                                                return n8;
                                            }
                                            if (by <= by2) break block89;
                                            n7 = -1;
                                            Object var19_20 = null;
                                            if (1 > Trace.LEVEL) break block90;
                                            Trace.trace("apnvhscT", "<- compareTime");
                                        }
                                        if (DEBUG_ON) {
                                            System.out.println("End of compareTime method");
                                            System.out.print("********************");
                                            System.out.println("********************");
                                        }
                                        return n7;
                                    }
                                    n5 = (0xFF & byArray[7]) << 24 | (0xFF & byArray[8]) << 16 | (0xFF & byArray[9]) << 8 | 0xFF & byArray[10];
                                    if (DEBUG_ON) {
                                        System.out.println("In compareTime: microsecond1 = " + n5);
                                    }
                                    if (3 <= Trace.LEVEL) {
                                        Trace.trace("apnvhscD", "microsecond1 = " + String.valueOf(n5));
                                    }
                                    n4 = (0xFF & byArray2[7]) << 24 | (0xFF & byArray2[8]) << 16 | (0xFF & byArray2[9]) << 8 | 0xFF & byArray2[10];
                                    if (DEBUG_ON) {
                                        System.out.println("In compareTime: microsecond2 = " + n4);
                                    }
                                    if (3 <= Trace.LEVEL) {
                                        Trace.trace("apnvhscD", "microsecond2 = " + String.valueOf(n4));
                                    }
                                    if (n5 <= n4) break block91;
                                    n6 = 1;
                                    Object var19_21 = null;
                                    if (1 > Trace.LEVEL) break block92;
                                    Trace.trace("apnvhscT", "<- compareTime");
                                }
                                if (DEBUG_ON) {
                                    System.out.println("End of compareTime method");
                                    System.out.print("********************");
                                    System.out.println("********************");
                                }
                                return n6;
                            }
                            if (n4 <= n5) break block93;
                            n3 = -1;
                            Object var19_22 = null;
                            if (1 > Trace.LEVEL) break block94;
                            Trace.trace("apnvhscT", "<- compareTime");
                        }
                        if (DEBUG_ON) {
                            System.out.println("End of compareTime method");
                            System.out.print("********************");
                            System.out.println("********************");
                        }
                        return n3;
                    }
                    n2 = 0;
                    Object var19_23 = null;
                    if (1 > Trace.LEVEL) break block95;
                    Trace.trace("apnvhscT", "<- compareTime");
                }
                if (DEBUG_ON) {
                    System.out.println("End of compareTime method");
                    System.out.print("********************");
                    System.out.println("********************");
                }
                return n2;
            }
            if (DEBUG_ON) {
                System.out.println("problem with the time stamp passed: length not equal");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "compareTimeMethod returning - (-1) -- problem with the time stamp passed");
            }
            n = -1;
            Object var19_24 = null;
            if (1 > Trace.LEVEL) break block96;
            Trace.trace("apnvhscT", "<- compareTime");
        }
        if (DEBUG_ON) {
            System.out.println("End of compareTime method");
            System.out.print("********************");
            System.out.println("********************");
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    private int updateNVRAMCache(File var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String setLength(String string, int n) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> setLength");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "str = " + string);
            Trace.trace("apnvhscF", "length = " + n);
        }
        if (DEBUG_ON) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In setLength");
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setLength(n);
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- setLength");
        }
        if (DEBUG_ON) {
            System.out.println("End of setLength");
            System.out.print("********************");
            System.out.println("********************");
        }
        return stringBuffer.toString();
    }

    byte[] getTime(FspCecTime fspCecTime) {
        if (DEBUG_ON) {
            System.out.println("***************************In getTime method");
            System.out.println("TIME: " + fspCecTime.toString());
        }
        byte[] byArray = new byte[11];
        int n = fspCecTime.getYear();
        if (DEBUG_ON) {
            System.out.println("Year = " + n);
        }
        byArray[0] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)(n & 0xFF);
        byArray[2] = (byte)(fspCecTime.getMonth() & 0xFF);
        if (DEBUG_ON) {
            System.out.println("Month = " + byArray[2]);
        }
        byArray[3] = (byte)(fspCecTime.getDay() & 0xFF);
        if (DEBUG_ON) {
            System.out.println("Day = " + byArray[3]);
        }
        byArray[4] = (byte)(fspCecTime.getHour() & 0xFF);
        if (DEBUG_ON) {
            System.out.println("Hour = " + byArray[4]);
        }
        byArray[5] = (byte)(fspCecTime.getMinute() & 0xFF);
        if (DEBUG_ON) {
            System.out.println("Minute = " + byArray[5]);
        }
        byArray[6] = (byte)(fspCecTime.getSecond() & 0xFF);
        if (DEBUG_ON) {
            System.out.println("Seconds = " + byArray[6]);
        }
        int n2 = fspCecTime.getMicroSec();
        byArray[7] = (byte)((n2 & 0xFF000000) >> 24);
        byArray[8] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[9] = (byte)((n2 & 0xFF00) >> 8);
        byArray[10] = (byte)(n2 & 0xFF);
        if (DEBUG_ON) {
            System.out.println("Microseconds = " + n2);
        }
        if (DEBUG_ON) {
            System.out.println("***************************End of getTime method");
            System.out.println();
            System.out.println();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicatedAtPartition(int n, String string) throws PIHscServerException {
        boolean bl;
        block15: {
            boolean bl2 = false;
            int n2 = 128;
            try {
                boolean bl3;
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in isDuplicatedAtPartition: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl2 = true;
                bl = bl3 = this._isDuplicatedAtPartition(n, string, true);
                Object var10_11 = null;
                if (!bl2) break block15;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("001F", throwable);
                }
                catch (Throwable throwable2) {
                    Object var10_12 = null;
                    if (bl2) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return bl;
    }

    /*
     * Exception decompiling
     */
    public boolean _isDuplicatedAtPartition(int var1_1, String var2_2, boolean var3_3) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String decodeTime(byte[] byArray) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> decodeTime");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "time = " + byArray);
        }
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        int n7 = 6;
        byte[] byArray2 = new byte[11];
        long l = new BigInteger(byArray).longValue();
        byArray2[n7] = (byte)(l & 0x3FL);
        byArray2[n6] = (byte)((l & 0xFC0L) >>> 6);
        byArray2[n5] = (byte)((l & 0x1F000L) >>> 12);
        byArray2[n4] = (byte)((l & 0x3E0000L) >>> 17);
        byArray2[n3] = (byte)((l & 0x3C00000L) >>> 22);
        byArray2[n2] = (byte)(l >>> 26 & 0x3FFFL);
        byArray2[n] = (byte)((l >>> 26 & 0x3FFFL) >>> 8);
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- decodeTime");
        }
        return new String(byArray2);
    }

    public static byte[] encodeTime(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> encodeTime");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "time = " + string);
        }
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        int n7 = 6;
        byte[] byArray = string.getBytes();
        long l = 0L;
        byte[] byArray2 = new byte[5];
        l |= (long)(byArray[n7] & 0x3F);
        l |= (long)((byArray[n6] & 0x3F) << 6);
        l |= (long)((byArray[n5] & 0x1F) << 12);
        l |= (long)((byArray[n4] & 0x1F) << 17);
        l |= (long)((byArray[n3] & 0xF) << 22);
        byArray2[4] = (byte)(l |= ((long)(0xFF & byArray[n2]) | (long)(byArray[n] << 8)) << 26);
        byArray2[3] = (byte)(l >>> 8);
        byArray2[2] = (byte)(l >>> 16);
        byArray2[1] = (byte)(l >>> 24);
        byArray2[0] = (byte)(l >>> 32);
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- encodeTime");
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteLparProfileFromSysProfile(int n, int n2) throws PIHscServerException {
        block14: {
            int n3 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In deleteLparProfileFromSysProfile");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in deleteLparProfileFromSysProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._deleteLparProfileFromSysProfile(n, n2, true);
                }
                catch (Throwable throwable) {
                    n3 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0020", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var9_8 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
        }
        this.isSaveAreaFileOpen = false;
    }

    private void _deleteLparProfileFromSysProfile(int n, int n2, boolean bl) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> _deleteLparProfileFromSysProfile");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "sysProfID = " + n);
                Trace.trace("apnvhscF", "lparProfID = " + n2);
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In _deleteLparProfileFromSysProfile");
                System.out.println("sysProfID = " + n);
                System.out.println("lparProfID = " + n2);
            }
            if (bl) {
                this.buildNVRAM(false, null, true, true, false);
            }
            Integer n3 = new Integer(n);
            Integer n4 = new Integer(n2);
            Object[] objectArray = (Object[])this._profileTable.get(n3);
            if (objectArray == null) {
                if (DEBUG_ON) {
                    System.out.println("info == null");
                }
                return;
            }
            if (DEBUG_ON) {
                System.out.println("info != null");
            }
            Hashtable hashtable = (Hashtable)objectArray[2];
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "properties = " + hashtable);
            }
            String string = (String)hashtable.get("UserDefinedName");
            Vector vector = null;
            vector = (Vector)hashtable.get("ProfileList");
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "profList = " + vector);
            }
            if (DEBUG_ON) {
                System.out.println("profList = " + vector);
            }
            if (vector == null) {
                if (DEBUG_ON) {
                    System.out.println("profList == null");
                }
                return;
            }
            int n5 = vector.indexOf(n4);
            if (DEBUG_ON) {
                System.out.println("in _deleteLparProfileFromSysProfile: ");
                System.out.println("index = " + n5);
            }
            if (n5 == -1) {
                return;
            }
            vector.removeElementAt(n5);
            hashtable.put("ProfileList", vector);
            this._saveSysProfile(string, n, hashtable, null, bl);
            if (DEBUG_ON) {
                System.out.println("End of _deleteLparProfileFromSysProfile");
                System.out.println("****************************************");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0020", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- deleteLparProfileFromSysProfile");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addLparProfileToSysProfile(int n, int n2) throws PIHscServerException {
        block14: {
            int n3 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In addLparProfileToSysProfile");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in addLparProfileToSysProfile: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._addLparProfileToSysProfile(n, n2, true);
                }
                catch (Throwable throwable) {
                    n3 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0021", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var9_8 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n3);
        }
        this.isSaveAreaFileOpen = false;
    }

    private void _addLparProfileToSysProfile(int n, int n2, boolean bl) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> addLparProfileToSysProfile");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "sysProfID = " + n);
                Trace.trace("apnvhscF", "lparProfID = " + n2);
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In addLparProfileToSysProfile");
                System.out.println("sysProfID = " + n);
                System.out.println("lparProfID = " + n2);
            }
            if (bl) {
                this.buildNVRAM(false, null, true, true, false);
            }
            Integer n3 = new Integer(n);
            Integer n4 = new Integer(n2);
            Object[] objectArray = (Object[])this._profileTable.get(n3);
            if (objectArray == null) {
                return;
            }
            Hashtable hashtable = (Hashtable)objectArray[2];
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "properties = " + hashtable);
            }
            String string = (String)hashtable.get("UserDefinedName");
            Vector<Integer> vector = null;
            vector = (Vector<Integer>)hashtable.get("ProfileList");
            if (vector == null) {
                vector = new Vector<Integer>();
            }
            vector.addElement(n4);
            hashtable.put("ProfileList", vector);
            this._saveSysProfile(string, n, hashtable, null, bl);
            if (DEBUG_ON) {
                System.out.println("End of _addLparProfToSysProfile");
                System.out.println("****************************************");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0021", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- addLparProfileToSysProfile");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSysProfileUserDefName(int n, String string) throws PIHscServerException {
        block14: {
            int n2 = 1;
            boolean bl = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setSysProfileUserDefName");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setSysProfileUserDefName: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._setSysProfileUserDefName(n, string, true);
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0032", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var9_8 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * Exception decompiling
     */
    private void _setSysProfileUserDefName(int var1_1, String var2_2, boolean var3_3) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPartitionName(int n) throws PIHscServerException {
        String string;
        block17: {
            int n2 = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getPartitionName");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getPartitionName: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                this.buildNVRAM(false, null, true, true, true);
                if (DEBUG_ON) {
                    System.out.println("return = " + this._partitionNameTable[n - 1]);
                    System.out.println("return = " + this._partitionTable[n - 1]);
                    System.out.println("End of getPartitionName");
                    System.out.println("****************************************");
                }
                string = this._partitionTable[n - 1];
                Object var8_9 = null;
                if (!bl) break block17;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0022", throwable);
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllPartitionNames() throws PIHscServerException {
        String[] stringArray;
        block18: {
            int n = 128;
            boolean bl = false;
            try {
                if (1 <= Trace.LEVEL) {
                    Trace.trace("apnvhscT", "-> getAllPartitionNames");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                bl = true;
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getAllPartitionNames");
                }
                this.buildNVRAM(false, null, true, true, true);
                String[] stringArray2 = new String[this.NUM_PARTITION_SLOTS];
                for (int i = 0; i < this.NUM_PARTITION_SLOTS; ++i) {
                    stringArray2[i] = this._partitionTable[i] == null || this._partitionTable[i].trim().length() == 0 ? "" : this._partitionTable[i];
                    if (DEBUG_ON) {
                        System.out.println("lparNames[" + (i + 1) + "] = " + stringArray2[i]);
                    }
                    if (2 > Trace.LEVEL) continue;
                    Trace.trace("apnvhscF", "lparNames[" + i + "] = " + stringArray2[i]);
                }
                if (DEBUG_ON) {
                    System.out.println("num of lpar slots = " + this.NUM_PARTITION_SLOTS);
                    System.out.println("End of getAllPartitionNames");
                    System.out.println("****************************************");
                }
                stringArray = stringArray2;
                Object var7_10 = null;
                if (!bl) break block18;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0023", throwable);
                }
                catch (Throwable throwable2) {
                    Object var7_11 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPartitionName(int n, String string) throws PIHscServerException {
        block21: {
            int n2 = 1;
            boolean bl = false;
            try {
                try {
                    int n3;
                    int n4;
                    int n5;
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setPartitionName");
                        System.out.println("lparID = " + n);
                        System.out.println("lparName = " + string);
                    }
                    Object var5_5 = null;
                    Object var6_7 = null;
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    int n6 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
                    FspFileOpenResponse fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n6);
                    if (fspFileOpenResponse == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setPartitionName: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this.buildNVRAM(false, null, true, true, false);
                    this._partitionTable[n - 1] = string;
                    byte[] byArray = null;
                    if (string == null) {
                        byArray = new byte[48];
                    } else {
                        n5 = string.length();
                        if (n5 != 47) {
                            string = this.setLength(string, 47);
                        }
                        byArray = string.getBytes("US-ASCII");
                    }
                    n5 = (Integer)this.saveAreaDataTableOffsets.get(VERSION_BASED_PARTITION_TABLE_DATA);
                    int n7 = (n - 1) * this.SIZE_OF_LPAR_INFO + n5;
                    for (n4 = 0; n4 < 47; ++n4) {
                        this._nvramData[n4 + n7] = byArray[n4];
                    }
                    n4 = (Integer)this.saveAreaDataTableOffsets.get(GLOBAL_TIMESTAMP);
                    int n8 = (Integer)this.saveAreaDataTableOffsets.get(LAST_MODIFIED_PARTITION_TABLE_TIMESTAMP);
                    int n9 = (Integer)this.saveAreaDataTableOffsets.get(PRIOR_MODIFIED_PARTITION_TABLE_TIMESTAMP);
                    int n10 = (Integer)this.saveAreaDataTableOffsets.get(MODIFIED_PARTITION_TABLE_STARTING_OFFSET);
                    int n11 = (Integer)this.saveAreaDataTableOffsets.get(MODIFIED_PARTITION_TABLE_LEN);
                    FspCecTime fspCecTime = this._cecMgr.getCmdHelper().getCecTimeOfDay(this._cecMgr.getCecName());
                    byte[] byArray2 = this.getTime(fspCecTime);
                    for (n3 = 0; n3 < 11; ++n3) {
                        this._nvramData[n4 + n3] = byArray2[n3];
                        this._nvramData[n9 + n3] = this._nvramData[n8 + n3];
                    }
                    for (n3 = 0; n3 < 11; ++n3) {
                        this._nvramData[n8 + n3] = byArray2[n3];
                    }
                    this.writeIntToNvramData(n7, n10);
                    this.writeIntToNvramData(48, n11);
                    n3 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
                    int n12 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n4, n3 - n4);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, n12, (short)8);
                    int n13 = (Integer)this.saveAreaDataTableOffsets.get(NUM_PARTITIONS);
                    int n14 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n13, n14 - n13);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, n3, (short)8);
                    this._nvramTimestamp = (byte[])byArray2.clone();
                    this._partitionTableTimestamp = (byte[])byArray2.clone();
                    this._backupToLocalFile();
                    byte[] byArray3 = new byte[n3 - n12];
                    System.arraycopy(this._nvramData, n12, byArray3, 0, n3 - n12);
                    this._writeDataToFSP(byArray3, n12, n3 - n12);
                    byArray3 = new byte[8];
                    System.arraycopy(this._nvramData, n3, byArray3, 0, 8);
                    this._writeDataToFSP(byArray3, n3, 8);
                    this._writeDataToFSP(byArray, n5 + (n - 1) * this.SIZE_OF_LPAR_INFO, 47);
                    if (DEBUG_ON) {
                        System.out.println("End of setPartitionName");
                        System.out.println("****************************************");
                    }
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0024", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var25_27 = null;
                if (!bl) break block21;
            }
            catch (Throwable throwable) {
                Object var25_28 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPartitionInfo(int n, String string, short s) throws PIHscBaseException {
        block22: {
            int n2 = 1;
            boolean bl = false;
            s = (short)(s & 0xFF);
            try {
                try {
                    int n3;
                    int n4;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("apnvhscT", "-> setPartitionInfo");
                    }
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setPartitionInfo");
                        System.out.println("lparID = " + n);
                        System.out.println("lparName = " + string);
                        System.out.println("osType = " + s);
                    }
                    Object var6_6 = null;
                    Object var7_8 = null;
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    int n5 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
                    FspFileOpenResponse fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n5);
                    if (fspFileOpenResponse == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setPartitionInfo: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this.buildNVRAM(false, null, true, true, false);
                    this._partitionTable[n - 1] = string;
                    this._partitionOSTypeTable[n - 1] = s;
                    byte[] byArray = null;
                    if (string == null) {
                        byArray = new byte[48];
                    } else {
                        n4 = string.length();
                        if (n4 != 47) {
                            string = this.setLength(string, 47);
                        }
                        byArray = string.getBytes("US-ASCII");
                    }
                    n4 = (Integer)this.saveAreaDataTableOffsets.get(VERSION_BASED_PARTITION_TABLE_DATA);
                    int n6 = (n - 1) * this.SIZE_OF_LPAR_INFO + n4;
                    for (int i = 0; i < 47; ++i) {
                        this._nvramData[i + n6] = byArray[i];
                    }
                    this._nvramData[++i + n6] = (byte)s;
                    int n7 = (Integer)this.saveAreaDataTableOffsets.get(GLOBAL_TIMESTAMP);
                    int n8 = (Integer)this.saveAreaDataTableOffsets.get(LAST_MODIFIED_PARTITION_TABLE_TIMESTAMP);
                    int n9 = (Integer)this.saveAreaDataTableOffsets.get(PRIOR_MODIFIED_PARTITION_TABLE_TIMESTAMP);
                    int n10 = (Integer)this.saveAreaDataTableOffsets.get(MODIFIED_PARTITION_TABLE_STARTING_OFFSET);
                    int n11 = (Integer)this.saveAreaDataTableOffsets.get(MODIFIED_PARTITION_TABLE_LEN);
                    FspCecTime fspCecTime = this._cecMgr.getCmdHelper().getCecTimeOfDay(this._cecMgr.getCecName());
                    byte[] byArray2 = this.getTime(fspCecTime);
                    for (n3 = 0; n3 < 11; ++n3) {
                        this._nvramData[n7 + n3] = byArray2[n3];
                        this._nvramData[n9 + n3] = this._nvramData[n8 + n3];
                    }
                    for (n3 = 0; n3 < 11; ++n3) {
                        this._nvramData[n8 + n3] = byArray2[n3];
                    }
                    this.writeIntToNvramData(n6, n10);
                    this.writeIntToNvramData(49, n11);
                    n3 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
                    int n12 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n7, n3 - n7);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, n12, (short)8);
                    int n13 = (Integer)this.saveAreaDataTableOffsets.get(NUM_PARTITIONS);
                    int n14 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n13, n14 - n13);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, n3, (short)8);
                    System.out.println("numPartitionsOffset = " + n13);
                    System.out.println("(defaultProfTableChecksumOffset - numPartitionsOffset) = " + (n14 - n13));
                    System.out.println("_checksum = " + this._checksum);
                    this._nvramTimestamp = (byte[])byArray2.clone();
                    this._partitionTableTimestamp = (byte[])byArray2.clone();
                    this._backupToLocalFile();
                    byte[] byArray3 = new byte[n3 - n12];
                    System.arraycopy(this._nvramData, n12, byArray3, 0, n3 - n12);
                    this._writeDataToFSP(byArray3, n12, n3 - n12);
                    byArray3 = new byte[8];
                    System.arraycopy(this._nvramData, n3, byArray3, 0, 8);
                    this._writeDataToFSP(byArray3, n3, 8);
                    byArray3 = new byte[this.SIZE_OF_LPAR_INFO];
                    System.arraycopy(this._nvramData, n4 + (n - 1) * this.SIZE_OF_LPAR_INFO, byArray3, 0, this.SIZE_OF_LPAR_INFO);
                    this._writeDataToFSP(byArray3, n4 + (n - 1) * this.SIZE_OF_LPAR_INFO, this.SIZE_OF_LPAR_INFO);
                    if (DEBUG_ON) {
                        System.out.println("End of setPartitionInfo");
                        System.out.println("****************************************");
                    }
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0024", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var27_29 = null;
                if (!bl) break block22;
            }
            catch (Throwable throwable) {
                Object var27_30 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    private void writeIntegralToNvramData(long l, int n, short s) {
        int n2;
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> writeIntegralToNvramData");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "integral = " + l);
            Trace.trace("apnvhscF", "offset = " + n);
            Trace.trace("apnvhscF", "length = " + s);
        }
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In writeIntegralToNvramData");
            System.out.println("integral = " + l);
            System.out.println("offset = " + n);
            System.out.println("length = " + s);
        }
        int n3 = 0;
        if (s == 8) {
            n2 = 0;
            while (n2 < 4) {
                this._nvramData[n + n3] = (byte)(l >>> (8 - n3 - 1) * 8);
                ++n2;
                ++n3;
            }
        }
        if (s >= 4) {
            n2 = 0;
            while (n2 < 2) {
                this._nvramData[n + n3] = (byte)(l >>> (8 - n3 - 1) * 8);
                ++n2;
                ++n3;
            }
        }
        if (s >= 2) {
            n2 = 0;
            while (n2 < 1) {
                this._nvramData[n + n3] = (byte)(l >>> (8 - n3 - 1) * 8);
                ++n2;
                ++n3;
            }
        }
        if (s >= 1) {
            this._nvramData[n + n3] = (byte)l;
        }
        if (DEBUG_ON) {
            System.out.println("End of writeIntegralToNvramData");
            System.out.println("****************************************");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- writeIntegralToNvramData");
        }
    }

    private void writeIntToNvramData(int n, int n2) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> writeIntToNvramData");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "int = " + n);
            Trace.trace("apnvhscF", "offset = " + n2);
        }
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In writeIntToNvramData");
            System.out.println("int = " + n);
            System.out.println("offset = " + n2);
        }
        this._nvramData[n2] = (byte)(n >>> 24);
        this._nvramData[n2 + 1] = (byte)(n >>> 16);
        this._nvramData[n2 + 2] = (byte)(n >>> 8);
        this._nvramData[n2 + 3] = (byte)(n & 0xFF);
        if (DEBUG_ON) {
            for (int i = 0; i < 4; ++i) {
                System.out.println("_nvramData[" + (n2 + i) + "] = " + this._nvramData[n2 + i]);
            }
        }
        if (DEBUG_ON) {
            System.out.println("End of writeIntegralToNvramData");
            System.out.println("****************************************");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- writeIntegralToNvramData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIHMCSaveArea buildNVRAMFromLocalCopy(File file, boolean bl, boolean bl2) throws PIHscServerException {
        PIHMCSaveArea pIHMCSaveArea;
        boolean bl3;
        int n;
        block26: {
            n = 1;
            bl3 = false;
            try {
                if (bl) {
                    this.NVRAM_SIZE = (int)this._cecMgr.getCmdHelper().getFileSize(7, 0L);
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (DEBUG_ON) {
                            System.out.println("in PIHMCSaveArea initialize(): open file failed");
                        }
                        throw new PIHscServerException("004c", null);
                    }
                    bl3 = true;
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace("apnvhscT", " -> buildNVRAMFromLocalCopy");
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apnvhscF", "restoreFile = " + file);
                    Trace.trace("apnvhscF", "writeToFSP = " + bl);
                    Trace.trace("apnvhscF", "writeToBackup = " + bl2);
                }
                if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                    System.out.println("in buildNVRAMFromLocalCopy: _fspVersion is null");
                    this._fspVersion = this._cecMgr.getFspVersion();
                    if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                        System.out.println("in buildNVRAMFromLocalCopy: _fspVersion is still null");
                        this._fspVersion = "F3.0";
                    }
                    if (DEBUG_ON) {
                        System.out.println("_fspVersion = " + this._fspVersion);
                    }
                }
                if (DEBUG_ON) {
                    System.out.println("in buildNVRAMFromLocalCopy ---- about to call buildNVRAM");
                    System.out.println("in buildNVRAMFromLocalCopy -- NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                    System.out.println("in buildNVRAMFromLocalCopy -- _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                }
                this.buildNVRAM(false, file, bl2, false, false);
                if (bl && bl3) {
                    if (DEBUG_ON) {
                        System.out.println("in buildNVRAMFromLocalCopy templateVersion = " + this._templateVersion);
                    }
                    int n2 = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
                    byte[] byArray = new byte[this.NVRAM_SIZE];
                    System.arraycopy(this._nvramData, n2, byArray, 0, this.NVRAM_SIZE);
                    this._writeDataToFSP(byArray, n2, this.NVRAM_SIZE);
                }
                this._cecMgr.setSaveArea(this);
                pIHMCSaveArea = this;
                Object var10_13 = null;
                if (1 > Trace.LEVEL) break block26;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0025", throwable);
                }
                catch (Throwable throwable2) {
                    Object var10_14 = null;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("apnvhscT", " <- buildNVRAMFromLocalCopy");
                    }
                    if (bl3) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            Trace.trace("apnvhscT", " <- buildNVRAMFromLocalCopy");
        }
        if (bl3) {
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return pIHMCSaveArea;
    }

    private void _writeDataToFSP(byte[] byArray, int n, int n2) throws PIHscServerException {
        try {
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In _writeDataToFSP");
                System.out.println("offset = " + n);
                System.out.println("length = " + n2);
            }
            long l = this._cecMgr.getCmdHelper().writeFile(7, 0L, n, n2, byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0026", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", " <- _writeDataToFSP");
            }
        }
    }

    private void _backupToLocalFile() throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", " -> _backupToLocalFile");
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("_backupToLocalFile");
                System.out.println("NVRAM_SIZE = " + this.NVRAM_SIZE);
            }
            try {
                String string = "/var/hsc/profiles/";
                String string2 = this._cecName.substring(this._cecName.indexOf("*") + 1, this._cecName.length());
                System.out.println("in _backupToLocalFile: serialNumber = " + string2);
                String string3 = string.concat(this._cecName) + "/";
                string = string.concat(string2) + "/";
                File file = new File(string);
                file.mkdirs();
                File file2 = new File(string3);
                file2.mkdirs();
                if (file2.exists()) {
                    System.out.println("in _backupToLocalFile: old style directory exists ***********************");
                }
                File[] fileArray = file2.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = fileArray[i];
                    String string4 = file3.getName();
                    System.out.println("in _backupToLocalFile: oldFileName = " + string4);
                    File file4 = new File(string.concat(string4));
                    FileOutputStream fileOutputStream = new FileOutputStream(file4);
                    FileInputStream fileInputStream = new FileInputStream(file3);
                    byte[] byArray = new byte[(int)file3.length()];
                    fileInputStream.read(byArray);
                    fileOutputStream.write(byArray);
                    fileInputStream.close();
                    fileOutputStream.close();
                    file3.delete();
                }
                if (file2.exists()) {
                    System.out.println("in _backupToLocalFile: old style directory exists **** deleting it *******************");
                    file2.delete();
                }
                string = string.concat("backupFile");
                if (DEBUG_ON) {
                    System.out.println("dir = " + string);
                }
                RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
                int n = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
                System.out.println("_nvram.length = " + this._nvramData.length);
                System.out.println("basicInfoChecksumOffset = " + n);
                randomAccessFile.write(this._nvramData, n, this.NVRAM_SIZE);
                randomAccessFile.close();
                if (DEBUG_ON) {
                    System.out.println("End of _backupToLocalFile");
                    System.out.println("****************************************");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                throw new PIHscServerException("1195", throwable);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0027", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "<- _backupToLocalFile");
            }
        }
    }

    public boolean existInPartition(int n, Short s) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", " -> existInPartition");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
            Trace.trace("apnvhscF", "profID = " + s);
        }
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("existInPartition");
        }
        boolean bl = this._profilesAtPartitionTable[n].contains(s);
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "ret = " + bl);
        }
        if (DEBUG_ON) {
            System.out.println("exist or not = " + bl);
            System.out.println("end of existInPartition");
            System.out.println("****************************************");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- existInPartition");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _readDataFromFSP(int n, int n2) throws PIHscServerException {
        try {
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println(" In _readDataFromFSP");
                System.out.println("offset = " + n);
                System.out.println("len = " + n2);
            }
            byte[] byArray = null;
            try {
                byArray = this._cecMgr.getCmdHelper().readFile(7, 0L, n, n2);
                Object var5_5 = null;
                if (byArray == null) {
                    System.out.println("End of _readDataFromFSP()");
                    System.out.println("****************************************");
                    System.out.println("****************************************");
                    System.out.println(" readFile has returned a NULL value ****");
                    System.out.println(" offset = " + n);
                    System.out.println(" len = " + n2);
                    System.out.println(" barf barf barf barf barf barf barf ****");
                    System.out.println("****************************************");
                    System.out.println("****************************************");
                }
                if (DEBUG_ON) {
                    System.out.println("End of _readDataFromFSP()");
                    System.out.println("****************************************");
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (byArray == null) {
                    System.out.println("End of _readDataFromFSP()");
                    System.out.println("****************************************");
                    System.out.println("****************************************");
                    System.out.println(" readFile has returned a NULL value ****");
                    System.out.println(" offset = " + n);
                    System.out.println(" len = " + n2);
                    System.out.println(" barf barf barf barf barf barf barf ****");
                    System.out.println("****************************************");
                    System.out.println("****************************************");
                }
                if (DEBUG_ON) {
                    System.out.println("End of _readDataFromFSP()");
                    System.out.println("****************************************");
                }
                throw throwable;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0028", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", " <- _readDataFromFSP");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteProfilesAtPartition(int n) throws PIHscServerException {
        boolean bl;
        int n2;
        block22: {
            n2 = 1;
            bl = false;
            try {
                try {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("apnvhscT", " -> deleteProfilesAtPartition");
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
                    }
                    if (DEBUG_ON) {
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println("In deleteProfilesAtPartition");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in deleteProfilesAtPartition: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    Enumeration enumeration = this._profilesAtPartitionTable[n].elements();
                    while (enumeration.hasMoreElements()) {
                        Integer n3 = (Integer)enumeration.nextElement();
                        if (2 <= Trace.LEVEL) {
                            Trace.trace("apnvhscF", "profID = " + n3);
                        }
                        if (DEBUG_ON) {
                            System.out.println("in deleteProfilesAtPartition: profID = " + n3);
                        }
                        int n4 = n3;
                        this._removeLPARProfile(n4, true);
                    }
                    this._modifySysProfilesUsingLparID(n);
                    if (DEBUG_ON) {
                        System.out.println("End of deleteProfilesAtPartition");
                        System.out.print("********************");
                        System.out.println("********************");
                    }
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0029", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var9_10 = null;
                if (1 > Trace.LEVEL) break block22;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (1 <= Trace.LEVEL) {
                    Trace.trace("apnvhscT", " <- deleteProfilesAtPartition");
                }
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            Trace.trace("apnvhscT", " <- deleteProfilesAtPartition");
        }
        if (bl) {
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifySysProfilesUsingLparID(int n) throws PIHscServerException {
        boolean bl;
        int n2;
        block19: {
            n2 = 1;
            bl = false;
            try {
                try {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("apnvhscT", " -> modifySysProfilesUsingLparID");
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
                    }
                    if (DEBUG_ON) {
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println("In modifySysProfilesUsingLparID");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in modifySysProfilesUsingLparID: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._modifySysProfilesUsingLparID(n);
                    if (DEBUG_ON) {
                        System.out.println("End of modifySysProfilesUsingLparID");
                        System.out.print("********************");
                        System.out.println("********************");
                    }
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("002A", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var8_7 = null;
                if (1 > Trace.LEVEL) break block19;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (1 <= Trace.LEVEL) {
                    Trace.trace("apnvhscT", " <- modifySysProfilesUsingLparID");
                }
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            Trace.trace("apnvhscT", " <- modifySysProfilesUsingLparID");
        }
        if (bl) {
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    private void _modifySysProfilesUsingLparID(int n) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", " -> _modifySysProfilesUsingLparID");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
            }
            if (DEBUG_ON) {
                System.out.print("********************");
                System.out.println("********************");
                System.out.println("In _modifySysProfilesUsingLparID");
            }
            Integer n2 = new Integer(n);
            Enumeration enumeration = this._profilesAtPartitionTable[0].elements();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                if (DEBUG_ON) {
                    System.out.println("in _modifySysProfilesUsingLparID: sysProfID = " + n3);
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apnvhscF", "sysProfID = " + n3);
                }
                int n4 = n3;
                Hashtable hashtable = this._getSysProfile(n4, true);
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apnvhscF", "properties = " + hashtable);
                }
                if (DEBUG_ON) {
                    System.out.println("in _modifySysProfilesUsingLparID: properties = " + hashtable);
                }
                Vector vector = (Vector)hashtable.get("ProfileList");
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apnvhscF", "lparProfs = " + vector);
                }
                if (DEBUG_ON) {
                    System.out.println("in _modifySysProfilesUsingLparID: lparProfs = " + vector);
                }
                if (vector == null) break;
                int n5 = vector.indexOf(n2);
                if (n5 == -1) continue;
                if (DEBUG_ON) {
                    System.out.println("in _modifySysProfilesUsingLparID: ");
                    System.out.println("sys profile contains profile id for lparID = " + n);
                    System.out.println("indexOf = " + n5);
                }
                vector.removeElementAt(n5);
                if (vector.size() == 0) {
                    System.out.println("in _modifySysProfilesUsingLparID: ");
                    System.out.println("no more profiles in sys profile " + n3);
                }
                String string = (String)hashtable.get("UserDefinedName");
                this._saveSysProfile(string, n4, hashtable, null, true);
            }
            if (DEBUG_ON) {
                System.out.println("End of _modifySysProfilesUsingLparID");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("002A", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", " <- modifySysProfilesUsingLparID");
            }
        }
    }

    public static String printableTimestamp(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", " -> printableTimestamp");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "timestamp = " + string);
        }
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In printableTimestamp");
        }
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray[0] << 8 | byArray[1] & 0xFF;
        stringBuffer.append(n);
        stringBuffer.append('/');
        stringBuffer.append(byArray[2]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[3]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[4]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[5]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[6]);
        int n2 = byArray[7] << 24 | byArray[8] << 16 | byArray[9] << 8 | 0xFF & byArray[10];
        stringBuffer.append(n2);
        if (DEBUG_ON) {
            System.out.println("printableString = " + stringBuffer);
            System.out.println("End of printableTimestamp");
            System.out.println("****************************************");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "ret = " + stringBuffer);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- printableTimestamp");
        }
        return stringBuffer.toString();
    }

    public static String cryptedTimestamp(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> cryptedTimestamp");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "time = " + string);
        }
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In cryptedTimeStamp");
        }
        byte[] byArray = new byte[7];
        int n = 0;
        int n2 = string.indexOf(47);
        int n3 = Integer.parseInt(string.substring(n, n2 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n4 = Integer.parseInt(string.substring(n + 1, n2 - 1 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n5 = Integer.parseInt(string.substring(n + 1, n2 - 1 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n6 = Integer.parseInt(string.substring(n + 1, n2 - 1 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n7 = Integer.parseInt(string.substring(n + 1, n2 - 1 - n));
        n = n2;
        int n8 = Integer.parseInt(string.substring(n + 1, string.length() - n - 1));
        byArray[0] = (byte)(n3 >>> 8);
        byArray[1] = (byte)n3;
        byArray[2] = (byte)n4;
        byArray[3] = (byte)n5;
        byArray[4] = (byte)n6;
        byArray[5] = (byte)n7;
        byArray[6] = (byte)n8;
        if (DEBUG_ON) {
            System.out.println("End of cryptedTimestamp");
            System.out.println("****************************************");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- cryptedTimestamp");
        }
        return new String(byArray);
    }

    public static Vector arrayToVec(Object[] objectArray) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> arrayToVec");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "arr = " + objectArray);
        }
        if (objectArray == null) {
            return new Vector();
        }
        int n = objectArray.length;
        Vector<Object> vector = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            vector.setElementAt(object, i);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "retVec = " + vector);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- arrayToVec");
        }
        return vector;
    }

    public PIHMCSaveArea priorityRestore(File file, File file2, int n, FspLockHelper fspLockHelper) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> priorityRestore");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "mirrorFile = " + file);
                Trace.trace("apnvhscF", "backupFile = " + file2);
                Trace.trace("apnvhscF", "priority = " + n);
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In priorityRestore");
                System.out.println("priority = " + n);
                System.out.println("PIHscConstants.RESTORE_TYPE_CEC_PRIORITY = 3");
                System.out.println("PIHscConstants.RESTORE_TYPE_BACKUP_PRIORITY = 2");
            }
            PIHMCSaveArea pIHMCSaveArea = null;
            PIHMCSaveArea pIHMCSaveArea2 = null;
            this._restoreType = n;
            if (!file.equals(file2)) {
                this.rebuildNVRAM(this._fspVersion, fspLockHelper);
            }
            if (n == 3) {
                pIHMCSaveArea2 = new PIHMCSaveArea(file2, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, 0, this._cecName, this._cecMgr, this._fspVersion);
                pIHMCSaveArea = new PIHMCSaveArea(file, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, 0, this._cecName, this._cecMgr, this._fspVersion);
            } else if (n == 2) {
                pIHMCSaveArea2 = new PIHMCSaveArea(file, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, 0, this._cecName, this._cecMgr, this._fspVersion);
                pIHMCSaveArea = new PIHMCSaveArea(file2, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, 0, this._cecName, this._cecMgr, this._fspVersion);
            }
            if (pIHMCSaveArea._templateVersion != pIHMCSaveArea2._templateVersion) {
                throw new PIHscServerException("0035");
            }
            this._mergeData(pIHMCSaveArea, pIHMCSaveArea2);
            this._cecMgr.setSaveArea(pIHMCSaveArea);
            if (DEBUG_ON) {
                System.out.println("End of priorityRestore");
                System.out.println("****************************************");
            }
            PIHMCSaveArea pIHMCSaveArea3 = pIHMCSaveArea;
            return pIHMCSaveArea3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("002B");
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- priorityRestore");
            }
        }
    }

    private void _mergeData(PIHMCSaveArea pIHMCSaveArea, PIHMCSaveArea pIHMCSaveArea2) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> _mergeData");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "base = " + pIHMCSaveArea);
                Trace.trace("apnvhscF", "addedOn= " + pIHMCSaveArea2);
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In _mergeData");
            }
            this._templateVersion = pIHMCSaveArea._templateVersion;
            this._profileTemplateVersion = pIHMCSaveArea._profileTemplateVersion;
            this.saveAreaDataTable = pIHMCSaveArea.saveAreaDataTable;
            this.saveAreaDataTableOffsets = pIHMCSaveArea.saveAreaDataTableOffsets;
            this.sysProfileDataTable = pIHMCSaveArea.sysProfileDataTable;
            this.fspmProfileDataTable = pIHMCSaveArea.fspmProfileDataTable;
            this.lparProfileDataTable = pIHMCSaveArea.lparProfileDataTable;
            this.saveAreaElementSequence = pIHMCSaveArea.saveAreaElementSequence;
            this.sysProfileElementSequence = pIHMCSaveArea.sysProfileElementSequence;
            this.fspmProfileElementSequence = pIHMCSaveArea.fspmProfileElementSequence;
            this.lparProfileElementSequence = pIHMCSaveArea.lparProfileElementSequence;
            this.tmpSubSequence = pIHMCSaveArea.tmpSubSequence;
            Vector[] vectorArray = this._mergePartitionNames(pIHMCSaveArea, pIHMCSaveArea2);
            this._mergeDefaultAndActivatedList(pIHMCSaveArea, pIHMCSaveArea2, vectorArray);
            this._mergeProfileInfo(pIHMCSaveArea, pIHMCSaveArea2, vectorArray);
            pIHMCSaveArea._backupToLocalFile();
            String string = this._cecName.substring(this._cecName.indexOf("*") + 1, this._cecName.length());
            System.out.println("in _mergeData: serialNumber = " + string);
            System.out.println("file name = " + "/var/hsc/profiles/" + string + "/" + "backupFile");
            pIHMCSaveArea._recalculateChecksum(new File("/var/hsc/profiles/" + string + "/" + "backupFile"));
            pIHMCSaveArea.buildNVRAMFromLocalCopy(new File("/var/hsc/profiles/" + string + "/" + "backupFile"), true, true);
            if (DEBUG_ON) {
                System.out.println("End of mergeData");
                System.out.println("****************************************");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("002C");
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- _mergeData");
            }
        }
    }

    private Vector[] _mergePartitionNames(PIHMCSaveArea pIHMCSaveArea, PIHMCSaveArea pIHMCSaveArea2) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> _mergePartitionNames");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "model= " + pIHMCSaveArea);
                Trace.trace("apnvhscF", "additionalInfo = " + pIHMCSaveArea2);
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In _mergePartitionNames");
            }
            try {
                Vector[] vectorArray;
                Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
                Vector<Integer> vector = new Vector<Integer>();
                Vector<Integer> vector2 = new Vector<Integer>();
                Vector<Integer> vector3 = new Vector<Integer>();
                int n = 0;
                int n2 = 0;
                for (int i = 1; i <= this.NUM_PARTITION_SLOTS; ++i) {
                    n = this._cecMgr.getCmdHelper().getLparSlotDefinitionState(new UnsignedInt16(i)).intValue();
                    System.out.println("lpar " + i + " slot definition state = " + n);
                    if (n == 0) continue;
                    hashtable.put(new Integer(i), new Integer(n));
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n3 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(VERSION_BASED_PARTITION_TABLE_DATA);
                dataOutputStream.write(pIHMCSaveArea._nvramData, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n3);
                for (int i = 1; i <= this.NUM_PARTITION_SLOTS; ++i) {
                    Object object;
                    if (DEBUG_ON) {
                        System.out.println("----- i = " + i + " -----");
                    }
                    System.out.println("1: check model partition table ------------------");
                    if (pIHMCSaveArea._partitionTable[i - 1] != null && pIHMCSaveArea._partitionTable[i - 1].trim().length() != 0) {
                        if (DEBUG_ON) {
                            System.out.println("FOUND ONE IN MODEL: model's lpar name = " + pIHMCSaveArea._partitionTable[i - 1]);
                        }
                        object = pIHMCSaveArea._partitionTable[i - 1].trim();
                        System.out.println(" -redundancy-  model's lpar name = " + (String)object);
                        pIHMCSaveArea._partitionTable[i - 1] = object;
                        dataOutputStream.writeBytes(this.setLength((String)object, 47));
                        if (pIHMCSaveArea._fastActivation[i - 1]) {
                            dataOutputStream.writeByte(1);
                        } else {
                            dataOutputStream.writeByte(0);
                        }
                        if (DEBUG_ON) {
                            System.out.println("model's OS type = " + pIHMCSaveArea._partitionOSTypeTable[i - 1]);
                        }
                        dataOutputStream.writeByte(pIHMCSaveArea._partitionOSTypeTable[i - 1]);
                        vector.add(new Integer(i));
                        continue;
                    }
                    System.out.println("2: check additionalInfo partition table ------------------");
                    if (pIHMCSaveArea2._partitionTable[i - 1] != null && pIHMCSaveArea2._partitionTable[i - 1].trim().length() != 0) {
                        object = pIHMCSaveArea2._partitionTable[i - 1];
                        if (DEBUG_ON) {
                            System.out.println("FOUND ONE IN additionalInfo: name = " + (String)object);
                        }
                        pIHMCSaveArea._partitionTable[i - 1] = object;
                        dataOutputStream.writeBytes(this.setLength((String)object, 47));
                        if (pIHMCSaveArea2._fastActivation[i - 1]) {
                            dataOutputStream.writeByte(1);
                        } else {
                            dataOutputStream.writeByte(0);
                        }
                        pIHMCSaveArea._fastActivation[i - 1] = pIHMCSaveArea2._fastActivation[i - 1];
                        n2 = pIHMCSaveArea2._partitionOSTypeTable[i - 1];
                        if (DEBUG_ON) {
                            System.out.println("additionalInfo OS type = " + n2);
                        }
                        pIHMCSaveArea._partitionOSTypeTable[i - 1] = n2;
                        dataOutputStream.writeByte(n2);
                        vector2.add(new Integer(i));
                        continue;
                    }
                    System.out.println("3: check FSP for defined partitions ------------------");
                    object = (Integer)hashtable.get(new Integer(i));
                    if (object != null) {
                        System.out.println("Lpar ID " + i + " slot definition state = " + object);
                        vectorArray = this._usingFspLparInfo(i);
                        if (vectorArray != null && vectorArray.trim().length() != 0) {
                            vector3.add(new Integer(i));
                            pIHMCSaveArea._partitionTable[i - 1] = vectorArray;
                            dataOutputStream.writeBytes(this.setLength((String)vectorArray, 47));
                        } else {
                            pIHMCSaveArea._partitionTable[i - 1] = null;
                            dataOutputStream.write(new byte[47]);
                        }
                        pIHMCSaveArea._fastActivation[i - 1] = false;
                        dataOutputStream.writeByte(0);
                        n = (Integer)object;
                        n2 = 130 == n || 129 == n ? 129 : (66 == n || 65 == n ? 4 : (4 == n || 3 == n ? 65 : 1));
                        pIHMCSaveArea._partitionOSTypeTable[i - 1] = n2;
                        dataOutputStream.writeByte(n2);
                        continue;
                    }
                    pIHMCSaveArea._partitionTable[i - 1] = null;
                    dataOutputStream.write(new byte[48]);
                    pIHMCSaveArea._fastActivation[i - 1] = false;
                    dataOutputStream.writeByte(0);
                }
                Vector[] vectorArray2 = new Vector[]{vector3, vector, vector2};
                if (DEBUG_ON) {
                    System.out.println("dout.size() = " + dataOutputStream.size());
                    System.out.println("model._nvramData.length = " + pIHMCSaveArea._nvramData.length);
                }
                System.out.println("writing out everything past partition table");
                int n4 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
                System.out.println("defaultProfileTableChecksumOffset = " + n4);
                System.out.println("writing out " + (this.NVRAM_SIZE - n4) + " bytes ----------------------");
                dataOutputStream.write(pIHMCSaveArea._nvramData, n4, this.NVRAM_SIZE - n4);
                dataOutputStream.close();
                pIHMCSaveArea._nvramData = byteArrayOutputStream.toByteArray();
                if (DEBUG_ON) {
                    System.out.println("lparsFromFsp = " + vector3);
                    System.out.println("lparsFromModel = " + vector);
                    System.out.println("lparsFromAddOn = " + vector2);
                    System.out.println("_merge Part _nvram length = " + pIHMCSaveArea._nvramData.length);
                }
                if (DEBUG_ON) {
                    System.out.println("SANITY CHECK ---  the following two values should match");
                    System.out.println("model._nvramData.length = " + pIHMCSaveArea._nvramData.length);
                    System.out.println("NVRAM_SIZE = " + this.NVRAM_SIZE);
                }
                byteArrayOutputStream.close();
                if (DEBUG_ON) {
                    System.out.println("End of _mergePartitionName");
                    System.out.println("****************************************");
                }
                vectorArray = vectorArray2;
                return vectorArray;
            }
            catch (Throwable throwable) {
                try {
                    System.out.println("_mergePartitionName: inner catch " + throwable);
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) {
                        throw new PIHscServerException("0007");
                    }
                    throw (PIHscServerException)throwable;
                }
                catch (Throwable throwable2) {
                    System.out.println("_mergePartitionName: outer catch " + throwable2);
                    throwable2.printStackTrace();
                    HSCLogUtils.serverLog(throwable2, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable2 instanceof PIHscServerException)) {
                        throw new PIHscServerException("002D");
                    }
                    throw (PIHscServerException)throwable2;
                }
            }
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- _mergePartitionNames");
            }
        }
    }

    private String _usingFspLparInfo(int n) throws PIHscServerException {
        try {
            String string;
            if (DEBUG_ON) {
                System.out.println("In _usingFspLparInfo:  lparID = " + n);
            }
            String string2 = this._cecMgr.getCmdHelper().getLparUserDefName(new UnsignedInt16(n));
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "partName = " + string2);
            }
            if (DEBUG_ON) {
                System.out.println("FSP partition name = " + string2);
            }
            if (string2 != null && string2.trim().length() != 0) {
                String string3 = string2.trim();
                return string3;
            }
            String string4 = string = "lparID_" + n + "_has_no_user_defined_name";
            return string4;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (DEBUG_ON) {
                System.out.println("exception exit _usingFspLparInfo:  exception " + throwable);
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("002C");
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (DEBUG_ON) {
                System.out.println("<- _usingFspLparInfo:  lparID = " + n);
            }
        }
    }

    private void _mergeDefaultAndActivatedList(PIHMCSaveArea pIHMCSaveArea, PIHMCSaveArea pIHMCSaveArea2, Vector[] vectorArray) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> _mergeDefaultAndActivatedList");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "model = " + pIHMCSaveArea);
                Trace.trace("apnvhscF", "additionalInfo = " + pIHMCSaveArea2);
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In _mergeDefaultAndActivatedList");
            }
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n2 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE);
                int n3 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE_CHECKSUM);
                System.out.println("defaultProfTableOffset = " + n2);
                dataOutputStream.write(pIHMCSaveArea._nvramData, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n2);
                String[] stringArray = new String[1];
                Object var9_11 = null;
                Vector vector = vectorArray[0];
                Vector vector2 = vectorArray[1];
                Vector vector3 = vectorArray[2];
                int n4 = 0;
                int n5 = 0;
                for (n = 1; n <= this.NUM_PARTITION_SLOTS; ++n) {
                    if (DEBUG_ON) {
                        System.out.println("----- i = " + n + " -----");
                    }
                    n4 = pIHMCSaveArea._defaultProfTable[n - 1];
                    System.out.println("model defaultProfileID = " + n4);
                    if (n4 != 0 && vector2.contains(new Integer(n))) {
                        dataOutputStream.writeShort(n4);
                        continue;
                    }
                    n4 = pIHMCSaveArea2._defaultProfTable[n - 1];
                    if (n4 != 0 && vector3.contains(new Integer(n))) {
                        pIHMCSaveArea._defaultProfTable[n - 1] = n4;
                        dataOutputStream.writeShort(n4);
                        continue;
                    }
                    pIHMCSaveArea._defaultProfTable[n - 1] = 0;
                    dataOutputStream.writeShort(0);
                }
                System.out.println("writing activatedProfTableChecksum at offset " + n3);
                dataOutputStream.write(pIHMCSaveArea._nvramData, n3, 8);
                if (DEBUG_ON) {
                    System.out.println(" interim check - should be at activated profile table");
                    System.out.println("dout.size() = " + dataOutputStream.size());
                }
                for (n = 1; n <= this.NUM_PARTITION_SLOTS; ++n) {
                    if (DEBUG_ON) {
                        System.out.println("----- i = " + n + " -----");
                    }
                    n5 = pIHMCSaveArea._activatedProfTable[n - 1];
                    System.out.println("model activatedProfileID = " + n5);
                    if (n5 != 0 && vector2.contains(new Integer(n))) {
                        dataOutputStream.writeShort(n5);
                        continue;
                    }
                    n5 = pIHMCSaveArea2._activatedProfTable[n - 1];
                    if (n5 != 0 && vector3.contains(new Integer(n))) {
                        pIHMCSaveArea._activatedProfTable[n - 1] = n5;
                        dataOutputStream.writeShort(n5);
                        continue;
                    }
                    pIHMCSaveArea._activatedProfTable[n - 1] = 0;
                    dataOutputStream.writeShort(0);
                }
                if (DEBUG_ON) {
                    System.out.println(" nother check after writing out activated table ---");
                    System.out.println("dout.size() = " + dataOutputStream.size());
                    System.out.println("model._nvramData.length = " + pIHMCSaveArea._nvramData.length);
                }
                n = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(PROFILE_INFO_CHECKSUM);
                if (DEBUG_ON) {
                    System.out.println("model._nvramData.size() = " + pIHMCSaveArea._nvramData.length);
                    System.out.println("profileInfoChecksumOffset = " + n);
                    System.out.println("diff = " + (this.NVRAM_SIZE - n));
                }
                dataOutputStream.write(pIHMCSaveArea._nvramData, n, this.NVRAM_SIZE - n);
                dataOutputStream.close();
                pIHMCSaveArea._nvramData = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                if (DEBUG_ON) {
                    System.out.println("End of _mergeDefaultAndActivatedList");
                    System.out.println("****************************************");
                }
            }
            catch (Throwable throwable) {
                System.out.println("inner catch - exception = " + throwable);
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof PIHscServerException) {
                    throw (PIHscServerException)throwable;
                }
                throw new PIHscServerException("0007", throwable);
            }
        }
        catch (Throwable throwable) {
            System.out.println("outer catch - exception = " + throwable);
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("002E");
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- _mergeDefaultAndActivatedList");
            }
        }
    }

    private void _mergeProfileInfo(PIHMCSaveArea pIHMCSaveArea, PIHMCSaveArea pIHMCSaveArea2, Vector[] vectorArray) throws PIHscServerException {
        try {
            Vector vector = vectorArray[0];
            Vector vector2 = vectorArray[1];
            Vector vector3 = vectorArray[2];
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> _mergeProfileInfo");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "model = " + pIHMCSaveArea);
                Trace.trace("apnvhscF", "additionalInfo = " + pIHMCSaveArea2);
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In _mergeProfileInfo");
            }
            try {
                Serializable serializable;
                Object object;
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n2 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(NEXT_AVAILABLE_SEQUENCE_NUMBER);
                dataOutputStream.write(pIHMCSaveArea._nvramData, 0, n2);
                this._nextAvailProfileSequenceID = pIHMCSaveArea._nextAvailProfileSequenceID >= pIHMCSaveArea2._nextAvailProfileSequenceID ? pIHMCSaveArea._nextAvailProfileSequenceID : pIHMCSaveArea2._nextAvailProfileSequenceID;
                dataOutputStream.writeShort(this._nextAvailProfileSequenceID);
                String[] stringArray = new String[1];
                Object var11_13 = null;
                Vector vector4 = new Vector();
                Vector<Integer> vector5 = new Vector<Integer>();
                boolean bl = false;
                int n3 = 0;
                for (n = 0; n <= this.NUM_PARTITION_SLOTS; ++n) {
                    Integer n4;
                    Enumeration enumeration;
                    if (DEBUG_ON) {
                        System.out.println("----- i = " + n + " -----");
                    }
                    if (pIHMCSaveArea._profilesAtPartitionTable[n] != null && !pIHMCSaveArea._profilesAtPartitionTable[n].isEmpty()) {
                        if (vector2.contains(new Integer(n)) || n == 0) {
                            enumeration = pIHMCSaveArea._profilesAtPartitionTable[n].elements();
                            n4 = null;
                            while (enumeration.hasMoreElements()) {
                                n4 = (Integer)enumeration.nextElement();
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "profileID = " + n4);
                                }
                                if (DEBUG_ON) {
                                    System.out.println("model's profileID = " + n4);
                                }
                                if (vector5.contains(n4)) {
                                    System.out.println("PROFILE ID ALREADY EXISTS in MODEL - discard model profile");
                                    continue;
                                }
                                object = (Object[])pIHMCSaveArea._profileTable.get(n4);
                                serializable = (Hashtable)object[2];
                                if (2 <= Trace.LEVEL) {
                                    Trace.trace("apnvhscF", "properties = " + serializable);
                                }
                                if (DEBUG_ON) {
                                    System.out.println("model's profProperties = " + serializable);
                                }
                                vector5.add(n4);
                                ++n3;
                            }
                            continue;
                        }
                        enumeration = pIHMCSaveArea._profilesAtPartitionTable[n].elements();
                        while (enumeration.hasMoreElements()) {
                            n4 = (Integer)enumeration.nextElement();
                            pIHMCSaveArea._profileTable.remove(n4);
                        }
                        pIHMCSaveArea._profilesAtPartitionTable[n] = new Vector();
                    }
                    if (pIHMCSaveArea2._profilesAtPartitionTable[n] != null && !pIHMCSaveArea2._profilesAtPartitionTable[n].isEmpty() && vector3.contains(new Integer(n))) {
                        enumeration = pIHMCSaveArea2._profilesAtPartitionTable[n].elements();
                        pIHMCSaveArea._profilesAtPartitionTable[n] = new Vector();
                        while (enumeration.hasMoreElements()) {
                            n4 = (Integer)enumeration.nextElement();
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "profileID = " + n4);
                            }
                            if (DEBUG_ON) {
                                System.out.println("addOn's profileID = " + n4);
                            }
                            if (vector5.contains(n4)) {
                                System.out.println("PROFILE ID ALREADY EXISTS in MODEL - discard additionInfo profile");
                                continue;
                            }
                            pIHMCSaveArea._profilesAtPartitionTable[n].add(n4);
                            object = (Object[])pIHMCSaveArea2._profileTable.get(n4);
                            pIHMCSaveArea._profileTable.put(n4, object);
                            serializable = (Hashtable)object[2];
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "properties = " + serializable);
                            }
                            if (DEBUG_ON) {
                                System.out.println("(additionalInfo) model's profProperties = " + serializable);
                            }
                            vector5.add(n4);
                            ++n3;
                        }
                        continue;
                    }
                    pIHMCSaveArea._profilesAtPartitionTable[n] = new Vector();
                }
                n = dataOutputStream.size();
                int n5 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(VERSION_BASED_PROFILE_INFO_DATA);
                System.out.println(" in _mergeProfileInfo: THE FOLLOWING TWO VALUES SHOULD BE THE SAME");
                System.out.println(" in _mergeProfileInfo: starting offset of profile table = " + n);
                System.out.println(" in _mergeProfileInfo: starting offset of profile table = " + n5);
                for (int i = 0; i <= this.NUM_PARTITION_SLOTS; ++i) {
                    if (DEBUG_ON) {
                        System.out.println("----- partitionID = " + i + " -----");
                    }
                    if (pIHMCSaveArea._profilesAtPartitionTable[i] == null || pIHMCSaveArea._profilesAtPartitionTable[i].isEmpty()) continue;
                    object = pIHMCSaveArea._profilesAtPartitionTable[i].elements();
                    while (object.hasMoreElements()) {
                        int n6;
                        int n7;
                        int n8;
                        short s;
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        byte[] byArray;
                        String string;
                        short s2;
                        serializable = (Integer)object.nextElement();
                        if (DEBUG_ON) {
                            System.out.println("profID = " + serializable);
                        }
                        Object[] objectArray = (Object[])pIHMCSaveArea._profileTable.get(serializable);
                        if (DEBUG_ON) {
                            System.out.println("offset = " + n);
                        }
                        objectArray[0] = new Integer(n);
                        short s3 = (Short)objectArray[1];
                        if (DEBUG_ON) {
                            System.out.println("len = " + s3);
                        }
                        n += s3;
                        Hashtable hashtable = (Hashtable)objectArray[2];
                        if (DEBUG_ON) {
                            System.out.println("properties = " + hashtable);
                        }
                        if (i == 0) {
                            s2 = (short)(pIHMCSaveArea._profileTemplateVersion + 0);
                            if (DEBUG_ON) {
                                System.out.println("_profileTemplateVersion = " + this._profileTemplateVersion);
                                System.out.println("templateVersion = " + s2);
                            }
                            string = (String)hashtable.get("UserDefinedName");
                            if (DEBUG_ON) {
                                System.out.println("sys profile userDefName = " + string);
                            }
                            byArray = new byte[32];
                            n13 = string.length();
                            if (n13 != 32) {
                                string = this.setLength(string, 32);
                            }
                            byArray = string.getBytes("US-ASCII");
                            Vector vector6 = (Vector)hashtable.get("ProfileList");
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("apnvhscF", "profileIDList = " + vector6);
                            }
                            if (DEBUG_ON) {
                                System.out.println("profileIDList = " + vector6);
                            }
                            n12 = 0;
                            n12 = vector6 == null ? 0 : (int)vector6.size();
                            dataOutputStream.writeShort(s3);
                            dataOutputStream.writeByte((byte)s2);
                            dataOutputStream.writeShort((Integer)serializable);
                            dataOutputStream.write(byArray, 0, 32);
                            dataOutputStream.writeShort(n12);
                            for (int j = 0; j < n12; ++j) {
                                Integer n14 = (Integer)vector6.elementAt(j);
                                if (DEBUG_ON) {
                                    System.out.println("pid = " + n14);
                                }
                                dataOutputStream.writeShort(n14);
                            }
                            continue;
                        }
                        s2 = 0;
                        string = null;
                        byArray = new byte[32];
                        n13 = 0;
                        short s4 = 0;
                        n12 = 0;
                        long l = 0L;
                        long l2 = 0L;
                        long l3 = 0L;
                        long l4 = 0L;
                        long l5 = 0L;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        long l6 = 0L;
                        long l7 = 0L;
                        long l8 = 0L;
                        long l9 = 0L;
                        long l10 = 0L;
                        long l11 = 0L;
                        short s5 = 0;
                        long l12 = 0L;
                        long l13 = 0L;
                        long l14 = 0L;
                        short s6 = 0;
                        short s7 = 0;
                        Vector vector7 = null;
                        Vector vector8 = null;
                        short s8 = 0;
                        short s9 = 0;
                        short s10 = 0;
                        Vector vector9 = null;
                        int n18 = 0;
                        short s11 = 0;
                        long l15 = 0L;
                        long l16 = 0L;
                        long l17 = 0L;
                        short s12 = 0;
                        short s13 = 0;
                        int n19 = 0;
                        int n20 = 0;
                        int n21 = 0;
                        short s14 = 0;
                        Vector vector10 = null;
                        int n22 = 0;
                        int n23 = 0;
                        int n24 = 0;
                        Vector vector11 = null;
                        Vector vector12 = null;
                        Vector vector13 = null;
                        Vector vector14 = null;
                        Vector vector15 = null;
                        Vector vector16 = null;
                        Vector vector17 = null;
                        Vector vector18 = null;
                        Vector vector19 = null;
                        Vector vector20 = null;
                        Vector vector21 = null;
                        Vector vector22 = null;
                        int n25 = 0;
                        Vector vector23 = null;
                        Vector vector24 = null;
                        Vector vector25 = null;
                        Vector vector26 = null;
                        Vector vector27 = null;
                        int n26 = 0;
                        Vector vector28 = null;
                        Vector vector29 = null;
                        Vector vector30 = null;
                        int n27 = 0;
                        Vector vector31 = null;
                        int n28 = 0;
                        Vector vector32 = null;
                        Vector vector33 = null;
                        Vector vector34 = null;
                        Vector vector35 = null;
                        Vector vector36 = null;
                        Vector vector37 = null;
                        int n29 = 0;
                        Vector vector38 = null;
                        string = (String)hashtable.get("UserDefinedName");
                        if (DEBUG_ON) {
                            System.out.println("profile userDefName = " + string);
                        }
                        if ((n11 = string.length()) != 32) {
                            string = this.setLength(string, 32);
                        }
                        byArray = string.getBytes("US-ASCII");
                        UnsignedInt8 unsignedInt8 = (UnsignedInt8)hashtable.get("FullSysPartProf");
                        if (unsignedInt8 != null && unsignedInt8.shortValue() == 1) {
                            s2 = (short)(pIHMCSaveArea._profileTemplateVersion + 50);
                            if (hashtable.get("BootMode") != null) {
                                n13 = ((UnsignedInt8)hashtable.get("BootMode")).shortValue();
                            }
                            s4 = ((UnsignedInt8)hashtable.get("SFPSurveillance")).shortValue();
                            if (hashtable.get("HSLOptiConnectPool") != null) {
                                n12 = ((UnsignedInt8)hashtable.get("HSLOptiConnectPool")).shortValue();
                            }
                            if (hashtable.get("LoadSourceDRCIndex") != null) {
                                l = ((UnsignedInt32)hashtable.get("LoadSourceDRCIndex")).longValue();
                            }
                            if (hashtable.get("AltLoadSourceDRCIndex") != null) {
                                l2 = ((UnsignedInt32)hashtable.get("AltLoadSourceDRCIndex")).longValue();
                            }
                            if (hashtable.get("ConsoleDRCIndex") != null) {
                                l3 = ((UnsignedInt32)hashtable.get("ConsoleDRCIndex")).longValue();
                            }
                            if (hashtable.get("AltConsoleDRCIndex") != null) {
                                l4 = ((UnsignedInt32)hashtable.get("AltConsoleDRCIndex")).longValue();
                            }
                            if (hashtable.get("ECSDRCIndex") != null) {
                                l5 = ((UnsignedInt32)hashtable.get("ECSDRCIndex")).longValue();
                            }
                            if (hashtable.get("TaggedIOInfo") != null) {
                                vector9 = (Vector)hashtable.get("TaggedIOInfo");
                                for (n10 = 0; n10 < vector9.size(); ++n10) {
                                    Boolean bl2 = (Boolean)vector9.elementAt(n10);
                                    boolean bl3 = false;
                                    if (bl2 != null) {
                                        bl3 = bl2;
                                    }
                                    if (!bl3) continue;
                                    n18 = (short)(n18 | 1 << n10);
                                }
                                System.out.println("taggedIoInfoVector = " + vector9);
                                System.out.println("taggedIoInfo = " + n18);
                            }
                            if (DEBUG_ON) {
                                System.out.println("bootMode = " + n13);
                            }
                            dataOutputStream.writeShort(s3);
                            dataOutputStream.writeByte((byte)s2);
                            dataOutputStream.writeShort((Integer)serializable);
                            dataOutputStream.write(byArray, 0, 32);
                            dataOutputStream.writeShort(i);
                            dataOutputStream.writeByte(n13);
                            dataOutputStream.writeByte(s4);
                            dataOutputStream.writeByte(n12);
                            dataOutputStream.writeInt((int)l);
                            dataOutputStream.writeInt((int)l2);
                            dataOutputStream.writeInt((int)l3);
                            dataOutputStream.writeInt((int)l4);
                            dataOutputStream.writeInt((int)l5);
                            dataOutputStream.writeByte(n18);
                            continue;
                        }
                        s2 = (short)(pIHMCSaveArea._profileTemplateVersion + 100);
                        if (hashtable.get("BootMode") != null) {
                            n13 = ((UnsignedInt8)hashtable.get("BootMode")).shortValue();
                        }
                        s4 = ((UnsignedInt8)hashtable.get("SFPSurveillance")).shortValue();
                        n15 = ((UnsignedInt16)hashtable.get("DesiredCPUCount")).intValue();
                        n16 = ((UnsignedInt16)hashtable.get("MinimumCPUCount")).intValue();
                        n17 = ((UnsignedInt16)hashtable.get("MaximumCPUCount")).intValue();
                        s9 = ((UnsignedInt8)hashtable.get("ProcMode")).shortValue();
                        s10 = ((UnsignedInt8)hashtable.get("SharingMode")).shortValue();
                        if (hashtable.get("TaggedIOInfo") != null) {
                            vector9 = (Vector)hashtable.get("TaggedIOInfo");
                            for (n10 = 0; n10 < vector9.size(); ++n10) {
                                Boolean bl4 = (Boolean)vector9.elementAt(n10);
                                boolean bl5 = false;
                                if (bl4 != null) {
                                    bl5 = bl4;
                                }
                                if (!bl5) continue;
                                n18 = (short)(n18 | 1 << n10);
                            }
                            System.out.println("taggedIoInfoVector = " + vector9);
                            System.out.println("taggedIoInfo = " + n18);
                        }
                        if (hashtable.get("UncappedWeight") != null) {
                            s11 = ((UnsignedInt8)hashtable.get("UncappedWeight")).shortValue();
                        }
                        if (hashtable.get("DesiredProcUnit") != null) {
                            l15 = ((UnsignedInt32)hashtable.get("DesiredProcUnit")).longValue();
                        }
                        if (hashtable.get("MinProcUnit") != null) {
                            l16 = ((UnsignedInt32)hashtable.get("MinProcUnit")).longValue();
                        }
                        if (hashtable.get("MaxProcUnit") != null) {
                            l17 = ((UnsignedInt32)hashtable.get("MaxProcUnit")).longValue();
                        }
                        l6 = ((UnsignedInt32)hashtable.get("DesiredMemory")).longValue();
                        l7 = ((UnsignedInt32)hashtable.get("MinimumMemory")).longValue();
                        l8 = ((UnsignedInt32)hashtable.get("MaximumMemory")).longValue();
                        if (hashtable.get("Reserve1CurrMem") != null) {
                            l9 = ((UnsignedInt32)hashtable.get("Reserve1CurrMem")).longValue();
                        }
                        if (hashtable.get("Reserve1MaxMem") != null) {
                            l10 = ((UnsignedInt32)hashtable.get("Reserve1MaxMem")).longValue();
                        }
                        if (hashtable.get("Reserve1MinMem") != null) {
                            l11 = ((UnsignedInt32)hashtable.get("Reserve1MinMem")).longValue();
                        }
                        if (hashtable.get("Reserve1Type") != null) {
                            s5 = ((UnsignedInt8)hashtable.get("Reserve1Type")).shortValue();
                        }
                        if (hashtable.get("Reserve2CurrMem") != null) {
                            l12 = ((UnsignedInt32)hashtable.get("Reserve2CurrMem")).longValue();
                        }
                        if (hashtable.get("Reserve2MaxMem") != null) {
                            l13 = ((UnsignedInt32)hashtable.get("Reserve2MaxMem")).longValue();
                        }
                        if (hashtable.get("Reserve2MinMem") != null) {
                            l14 = ((UnsignedInt32)hashtable.get("Reserve2MinMem")).longValue();
                        }
                        if (hashtable.get("Reserve2Type") != null) {
                            s6 = ((UnsignedInt8)hashtable.get("Reserve2Type")).shortValue();
                        }
                        s12 = ((UnsignedInt8)hashtable.get("AutoIPLEnabled")).shortValue();
                        if (hashtable.get("VirtualOptiConnectPool") != null) {
                            s13 = ((UnsignedInt8)hashtable.get("VirtualOptiConnectPool")).shortValue();
                        }
                        if (hashtable.get("HSLOptiConnectPool") != null) {
                            n12 = ((UnsignedInt8)hashtable.get("HSLOptiConnectPool")).shortValue();
                        }
                        if (hashtable.get("DesiredInteractivePerf") != null) {
                            n19 = ((UnsignedInt16)hashtable.get("DesiredInteractivePerf")).intValue();
                        }
                        if (hashtable.get("MinInteractivePerf") != null) {
                            n20 = ((UnsignedInt16)hashtable.get("MinInteractivePerf")).intValue();
                        }
                        if (hashtable.get("MaxInteractivePerf") != null) {
                            n21 = ((UnsignedInt16)hashtable.get("MaxInteractivePerf")).intValue();
                        }
                        if (hashtable.get("LoadSourceDRCIndex") != null) {
                            l = ((UnsignedInt32)hashtable.get("LoadSourceDRCIndex")).longValue();
                        }
                        if (hashtable.get("AltLoadSourceDRCIndex") != null) {
                            l2 = ((UnsignedInt32)hashtable.get("AltLoadSourceDRCIndex")).longValue();
                        }
                        if (hashtable.get("ConsoleDRCIndex") != null) {
                            l3 = ((UnsignedInt32)hashtable.get("ConsoleDRCIndex")).longValue();
                        }
                        if (hashtable.get("AltConsoleDRCIndex") != null) {
                            l4 = ((UnsignedInt32)hashtable.get("AltConsoleDRCIndex")).longValue();
                        }
                        if (hashtable.get("ECSDRCIndex") != null) {
                            l5 = ((UnsignedInt32)hashtable.get("ECSDRCIndex")).longValue();
                        }
                        s14 = (vector10 = (Vector)hashtable.get("HostingPartitions")) == null ? (short)0 : (short)vector10.size();
                        n22 = ((UnsignedInt16)hashtable.get("MaxVirtualSlots")).intValue();
                        vector11 = (Vector)hashtable.get("VirSerialAdapters");
                        if (vector11 != null) {
                            vector13 = (Vector)hashtable.get("VirSerialDeviceAttributes");
                            vector15 = (Vector)hashtable.get("VirSerialSupportHMCClients");
                            vector17 = (Vector)hashtable.get("VirSerialSlotReqDesAttribute");
                            vector19 = (Vector)hashtable.get("VirSerialServerLPARs");
                            vector21 = (Vector)hashtable.get("VirSerialServerSlotNum");
                        }
                        n23 = vector11 == null ? 0 : vector11.size();
                        vector12 = (Vector)hashtable.get("VirSCSIAdapters");
                        if (vector12 != null) {
                            vector14 = (Vector)hashtable.get("VirSCSIDeviceAttributes");
                            vector16 = (Vector)hashtable.get("VirSCSISupportHMCClients");
                            vector18 = (Vector)hashtable.get("VirSCSISlotReqDesAttribute");
                            vector20 = (Vector)hashtable.get("VirSCSIServerLPARs");
                            vector22 = (Vector)hashtable.get("VirSCSIServerSlotNum");
                        }
                        n24 = vector12 == null ? 0 : vector12.size();
                        vector23 = (Vector)hashtable.get("SMCAVirSlotNum");
                        if (vector23 != null) {
                            vector24 = (Vector)hashtable.get("SMCADRCIndex");
                            vector25 = (Vector)hashtable.get("SMCARIOBus");
                            vector26 = (Vector)hashtable.get("SMCARemoteLparID");
                            vector27 = (Vector)hashtable.get("SMCARemoteVirSlotNum");
                        }
                        n25 = vector23 == null ? 0 : vector23.size();
                        vector28 = (Vector)hashtable.get("IOSlots");
                        if (vector28 != null) {
                            vector29 = (Vector)hashtable.get("IORequirement");
                            vector30 = (Vector)hashtable.get("IOPoolIDs");
                        }
                        n26 = vector28 == null ? 0 : vector28.size();
                        vector31 = (Vector)hashtable.get("PartitionIOPools");
                        n27 = vector31 == null ? 0 : vector31.size();
                        if (hashtable.get("SNIConfigMode") != null) {
                            s7 = ((UnsignedInt8)hashtable.get("SNIConfigMode")).shortValue();
                            vector7 = (Vector)hashtable.get("SNIDeviceID");
                            vector8 = (Vector)hashtable.get("SNIWindows");
                        }
                        s8 = vector7 == null ? (short)0 : (short)vector7.size();
                        vector32 = (Vector)hashtable.get("VirtualLanSlotIDs");
                        if (vector32 != null) {
                            vector33 = (Vector)hashtable.get("IEEE");
                            vector34 = (Vector)hashtable.get("VLANTrunkAdapter");
                            vector35 = (Vector)hashtable.get("VLANSlotReqDesAttribute");
                            vector36 = (Vector)hashtable.get("PVLANID");
                            vector37 = (Vector)hashtable.get("AddVlanNum");
                            vector38 = (Vector)hashtable.get("AddVlans");
                        }
                        if (vector32 == null) {
                            n28 = 0;
                        } else {
                            n28 = vector32.size();
                            for (n10 = 0; n10 < n28; ++n10) {
                                n29 += ((UnsignedInt16)vector37.elementAt(n10)).intValue();
                            }
                        }
                        dataOutputStream.writeShort(s3);
                        dataOutputStream.writeByte((byte)s2);
                        dataOutputStream.writeShort((Integer)serializable);
                        dataOutputStream.write(byArray, 0, 32);
                        dataOutputStream.writeShort(i);
                        dataOutputStream.writeByte((byte)n13);
                        dataOutputStream.writeByte((byte)s4);
                        dataOutputStream.writeShort((short)n15);
                        dataOutputStream.writeShort((short)n16);
                        dataOutputStream.writeShort((short)n17);
                        dataOutputStream.writeByte((byte)s9);
                        dataOutputStream.writeByte((byte)s10);
                        dataOutputStream.writeByte((byte)n18);
                        dataOutputStream.writeByte((byte)s11);
                        dataOutputStream.writeInt((int)l15);
                        dataOutputStream.writeInt((int)l16);
                        dataOutputStream.writeInt((int)l17);
                        dataOutputStream.writeInt((int)l6);
                        dataOutputStream.writeInt((int)l7);
                        dataOutputStream.writeInt((int)l8);
                        dataOutputStream.writeInt((int)l9);
                        dataOutputStream.writeInt((int)l10);
                        dataOutputStream.writeInt((int)l11);
                        dataOutputStream.writeByte(s5);
                        dataOutputStream.writeInt((int)l12);
                        dataOutputStream.writeInt((int)l13);
                        dataOutputStream.writeInt((int)l14);
                        dataOutputStream.writeByte(s6);
                        dataOutputStream.writeByte((byte)s12);
                        dataOutputStream.writeByte((byte)s13);
                        dataOutputStream.writeByte((byte)n12);
                        dataOutputStream.writeShort((short)n19);
                        dataOutputStream.writeShort((short)n20);
                        dataOutputStream.writeShort((short)n21);
                        dataOutputStream.writeInt((int)l);
                        dataOutputStream.writeInt((int)l2);
                        dataOutputStream.writeInt((int)l3);
                        dataOutputStream.writeInt((int)l4);
                        dataOutputStream.writeInt((int)l5);
                        dataOutputStream.writeShort(s14);
                        if (s14 > 0) {
                            for (n10 = 0; n10 < s14; ++n10) {
                                short s15 = ((UnsignedInt16)vector10.elementAt(n10)).shortValue();
                                dataOutputStream.writeShort(s15);
                            }
                        }
                        dataOutputStream.writeShort(n22);
                        dataOutputStream.writeShort(n23);
                        if (n23 > 0) {
                            for (n10 = 0; n10 < n23; ++n10) {
                                short s16 = ((UnsignedInt16)vector11.elementAt(n10)).shortValue();
                                dataOutputStream.writeShort(s16);
                                byte by = ((UnsignedInt8)vector13.elementAt(n10)).byteValue();
                                dataOutputStream.writeByte(by);
                                n9 = 0;
                                if (vector15 != null && (UnsignedInt8)vector15.elementAt(n10) != null) {
                                    n9 = ((UnsignedInt8)vector15.elementAt(n10)).byteValue();
                                }
                                if (((String)vector17.elementAt(n10)).equals("R")) {
                                    n9 = (short)(n9 | 8);
                                }
                                dataOutputStream.writeByte(n9);
                                s = ((UnsignedInt16)vector19.elementAt(n10)).shortValue();
                                n8 = ((UnsignedInt16)vector21.elementAt(n10)).shortValue();
                                dataOutputStream.writeShort(s);
                                dataOutputStream.writeShort(n8);
                            }
                        }
                        dataOutputStream.writeShort(n24);
                        if (n24 > 0) {
                            for (n10 = 0; n10 < n24; ++n10) {
                                short s17 = ((UnsignedInt16)vector12.elementAt(n10)).shortValue();
                                dataOutputStream.writeShort(s17);
                                byte by = ((UnsignedInt8)vector14.elementAt(n10)).byteValue();
                                dataOutputStream.writeByte(by);
                                n9 = 0;
                                if (vector16 != null && (UnsignedInt8)vector16.elementAt(n10) != null) {
                                    n9 = ((UnsignedInt8)vector16.elementAt(n10)).byteValue();
                                }
                                if (((String)vector18.elementAt(n10)).equals("R")) {
                                    n9 = (short)(n9 | 8);
                                }
                                dataOutputStream.writeByte(n9);
                                s = ((UnsignedInt16)vector20.elementAt(n10)).shortValue();
                                n8 = ((UnsignedInt16)vector22.elementAt(n10)).shortValue();
                                dataOutputStream.writeShort(s);
                                dataOutputStream.writeShort(n8);
                            }
                        }
                        dataOutputStream.writeShort(n25);
                        if (n25 > 0) {
                            for (n10 = 0; n10 < n25; ++n10) {
                                int n30 = ((UnsignedInt16)vector23.elementAt(n10)).intValue();
                                dataOutputStream.writeShort(n30);
                                long l18 = ((UnsignedInt32)vector24.elementAt(n10)).longValue();
                                dataOutputStream.writeInt((int)l18);
                                long l19 = ((UnsignedInt32)vector25.elementAt(n10)).longValue();
                                dataOutputStream.writeInt((int)l19);
                                n7 = ((UnsignedInt16)vector26.elementAt(n10)).intValue();
                                dataOutputStream.writeShort(n7);
                                n6 = ((UnsignedInt16)vector27.elementAt(n10)).intValue();
                                dataOutputStream.writeShort(n6);
                            }
                        }
                        dataOutputStream.writeShort(n26);
                        if (n26 > 0) {
                            for (n10 = 0; n10 < n26; ++n10) {
                                int n31 = ((UnsignedInt32)vector28.elementAt(n10)).intValue();
                                dataOutputStream.writeInt(n31);
                                int n32 = 0;
                                if (((String)vector29.elementAt(n10)).equalsIgnoreCase("r")) {
                                    n32 = 1;
                                }
                                dataOutputStream.writeByte(n32);
                                n9 = ((UnsignedInt16)vector30.elementAt(n10)).intValue();
                                dataOutputStream.writeShort(n9);
                            }
                        }
                        dataOutputStream.writeShort(n27);
                        if (n27 > 0) {
                            for (n10 = 0; n10 < n27; ++n10) {
                                int n33 = ((UnsignedInt16)vector31.elementAt(n10)).intValue();
                                dataOutputStream.writeShort(n33);
                            }
                        }
                        dataOutputStream.writeByte((byte)s8);
                        if (s8 > 0) {
                            dataOutputStream.writeByte((byte)s7);
                            System.out.println("SMA Mode = " + s7);
                            for (n10 = 0; n10 < s8; ++n10) {
                                long l20 = Long.parseLong((String)vector7.elementAt(n10));
                                dataOutputStream.writeInt((int)l20);
                            }
                            for (n10 = 0; n10 < s8; ++n10) {
                                short s18 = ((UnsignedInt16)vector8.elementAt(n10)).shortValue();
                                dataOutputStream.writeShort(s18);
                            }
                        }
                        dataOutputStream.writeShort(n28);
                        if (n28 <= 0) continue;
                        n10 = 0;
                        for (int j = 0; j < n28; ++j) {
                            int n34 = ((UnsignedInt16)vector32.elementAt(j)).intValue();
                            dataOutputStream.writeShort((short)n34);
                            n9 = ((UnsignedInt8)vector33.elementAt(j)).shortValue();
                            dataOutputStream.writeByte((byte)n9);
                            int n35 = 0;
                            if (vector34 != null && (UnsignedInt8)vector34.elementAt(j) != null) {
                                n35 = ((UnsignedInt8)vector34.elementAt(j)).shortValue();
                            }
                            if (((String)vector35.elementAt(j)).equals("R")) {
                                n35 = (short)(n35 | 8);
                            }
                            dataOutputStream.writeByte((byte)n35);
                            n8 = ((UnsignedInt16)vector36.elementAt(j)).intValue();
                            dataOutputStream.writeShort((short)n8);
                            n7 = ((UnsignedInt16)vector37.elementAt(j)).intValue();
                            dataOutputStream.writeShort((short)n7);
                            if (n7 <= 0) continue;
                            n6 = 0;
                            for (n6 = 0; n6 < n7; ++n6) {
                                int n36 = ((UnsignedInt16)vector38.elementAt(n10 + n6)).intValue();
                                dataOutputStream.writeShort((short)n36);
                            }
                            n10 += n6;
                        }
                    }
                }
                System.out.println("final offset = " + n);
                System.out.println("filling in rest of SaveArea with 0s -- size " + (this.NVRAM_SIZE - n));
                System.out.println("setting _nvramDataSize to new offset ");
                this._nvramDataSize = n;
                dataOutputStream.write(new byte[this.NVRAM_SIZE - n]);
                dataOutputStream.close();
                pIHMCSaveArea._nvramData = byteArrayOutputStream.toByteArray();
                System.out.println("model._nvramData.length = " + pIHMCSaveArea._nvramData.length);
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable) {
                System.out.println("inner catch - exception = " + throwable);
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof PIHscServerException) {
                    throw (PIHscServerException)throwable;
                }
                throw new PIHscServerException("0007", throwable);
            }
        }
        catch (Throwable throwable) {
            System.out.println("outer catch - exception = " + throwable);
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("002E");
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- _mergeDrawerProfileInfo");
            }
        }
    }

    private void _recalculateChecksum(File file) throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> _recalculateChecksum");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("apnvhscF", "file = " + file);
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            Adler32 adler32 = new Adler32();
            byte[] byArray = null;
            int n = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
            int n2 = (Integer)this.saveAreaDataTableOffsets.get(SAVE_AREA_TEMPLATE_VERSION);
            int n3 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
            randomAccessFile.seek(n2);
            byArray = new byte[n3 - n2];
            randomAccessFile.read(byArray);
            adler32.reset();
            adler32.update(byArray);
            randomAccessFile.seek(n);
            randomAccessFile.write(PIHMCSaveArea.longToByteArray(adler32.getValue()));
            System.out.println("wrote basic info checksum - " + adler32.getValue());
            System.out.println("basicInfoChecksumOffset = " + n);
            System.out.println("startOffset = " + n2);
            System.out.println("end offset = timestampInfoChecksumOffset = " + n3);
            n2 = (Integer)this.saveAreaDataTableOffsets.get(GLOBAL_TIMESTAMP);
            int n4 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
            randomAccessFile.seek(n2);
            byArray = new byte[n4 - n2];
            randomAccessFile.read(byArray);
            adler32.reset();
            adler32.update(byArray);
            randomAccessFile.seek(n3);
            randomAccessFile.write(PIHMCSaveArea.longToByteArray(adler32.getValue()));
            System.out.println("wrote timestamp checksum - " + adler32.getValue());
            System.out.println("timestampInfoChecksumOffset = " + n3);
            System.out.println("startOffset = " + n2);
            System.out.println("end offset = partitionTableChecksumOffset = " + n4);
            n2 = (Integer)this.saveAreaDataTableOffsets.get(NUM_PARTITIONS);
            int n5 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
            randomAccessFile.seek(n2);
            byArray = new byte[n5 - n2];
            randomAccessFile.read(byArray);
            adler32.reset();
            adler32.update(byArray);
            randomAccessFile.seek(n4);
            randomAccessFile.write(PIHMCSaveArea.longToByteArray(adler32.getValue()));
            System.out.println("wrote partition table checksum - " + adler32.getValue());
            System.out.println("partitionTableChecksumOffset = " + n4);
            System.out.println("startOffset = " + n2);
            System.out.println("end offset = defaultProfTableChecksumOffset = " + n5);
            n2 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE);
            int n6 = (Integer)this.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE_CHECKSUM);
            randomAccessFile.seek(n2);
            byArray = new byte[n6 - n2];
            randomAccessFile.read(byArray);
            adler32.reset();
            adler32.update(byArray);
            randomAccessFile.seek(n5);
            randomAccessFile.write(PIHMCSaveArea.longToByteArray(adler32.getValue()));
            System.out.println("wrote default profile table checksum - " + adler32.getValue());
            System.out.println("defaultProfTableChecksumOffset = " + n5);
            System.out.println("startOffset = " + n2);
            System.out.println("end offset = activatedProfileTableChecksumOffset = " + n6);
            n2 = (Integer)this.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE);
            int n7 = (Integer)this.saveAreaDataTableOffsets.get(PROFILE_INFO_CHECKSUM);
            randomAccessFile.seek(n2);
            byArray = new byte[n7 - n2];
            randomAccessFile.read(byArray);
            adler32.reset();
            adler32.update(byArray);
            randomAccessFile.seek(n6);
            randomAccessFile.write(PIHMCSaveArea.longToByteArray(adler32.getValue()));
            System.out.println("wrote activated profile table checksum - " + adler32.getValue());
            System.out.println("activatedProfileTableChecksumOffset = " + n6);
            System.out.println("startOffset = " + n2);
            System.out.println("end offset = profileInfoChecksumOffset = " + n7);
            int n8 = (Integer)this.saveAreaDataTableOffsets.get(PROFILE_INFO_DATA_SIZE);
            int n9 = this.NVRAM_SIZE - n8;
            randomAccessFile.seek(n8);
            randomAccessFile.writeInt(n9);
            randomAccessFile.seek(n8);
            byArray = new byte[this.NVRAM_SIZE - n8];
            randomAccessFile.read(byArray);
            adler32.reset();
            adler32.update(byArray);
            randomAccessFile.seek(n7);
            randomAccessFile.write(PIHMCSaveArea.longToByteArray(adler32.getValue()));
            System.out.println("wrote profile info  checksum - " + adler32.getValue());
            System.out.println("profileInfoChecksumOffset = " + n7);
            System.out.println("startOffset = " + n8);
            System.out.println("end offset = (NVRAM_SIZE - profileInfoDataSizeOffset) = " + (this.NVRAM_SIZE - n8));
            randomAccessFile.close();
        }
        catch (Throwable throwable) {
            System.out.println("caught exception in _recalculateChecksum = " + throwable);
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("0007");
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- _recalculateChecksum");
            }
        }
    }

    public static byte[] longToByteArray(long l) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "-> longToByteArray");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "num = " + l);
        }
        if (DEBUG_ON) {
            System.out.println("num = " + l);
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >>> (8 - i - 1) * 8);
            if (!DEBUG_ON) continue;
            System.out.println("ret[" + i + "] = " + byArray[i]);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "ret = " + byArray);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("apnvhscT", "<- longToByteArray");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPartitionInfo(int n) throws PIHscServerException {
        Vector vector;
        boolean bl;
        int n2;
        block23: {
            block21: {
                Vector<Object> vector2;
                block22: {
                    n2 = 128;
                    bl = false;
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("in getPartitionInfo");
                        System.out.println("lparID = " + n);
                    }
                    Object var4_4 = null;
                    Vector<Object> vector3 = null;
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (DEBUG_ON) {
                            System.out.println("in getPartitionInfo: open file failed");
                        }
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this.buildNVRAM(false, null, true, true, true);
                    System.out.println("partition name = " + this._partitionTable[n - 1]);
                    if (this._partitionTable[n - 1] == null || this._partitionTable[n - 1].trim().length() == 0) break block21;
                    vector3 = new Vector<Object>();
                    vector3.setSize(2);
                    vector3.setElementAt(this._partitionTable[n - 1].trim(), 0);
                    vector3.setElementAt(new Short(this._partitionOSTypeTable[n - 1]), 1);
                    if (DEBUG_ON) {
                        System.out.println("in getPartitionInfo: content = " + vector3);
                    }
                    vector2 = vector3;
                    Object var10_12 = null;
                    if (1 > Trace.LEVEL) break block22;
                    Trace.trace("apnvhscT", "<- getPartitionInfo");
                }
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                return vector2;
            }
            try {
                System.out.println("got no partition entry for lpar " + n);
                vector = null;
                Object var10_13 = null;
                if (1 > Trace.LEVEL) break block23;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("003d", throwable);
                }
                catch (Throwable throwable2) {
                    Object var10_14 = null;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("apnvhscT", "<- getPartitionInfo");
                    }
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            Trace.trace("apnvhscT", "<- getPartitionInfo");
        }
        if (bl) {
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return vector;
    }

    public synchronized void migration() throws PIHscServerException {
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In migration");
            System.out.println("_fspVersion = " + this._fspVersion);
            System.out.println("_templateVersion = " + this._templateVersion);
        }
        if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
            System.out.println("in migration: _fspVersion is null");
            this._fspVersion = this._cecMgr.getFspVersion();
            if (this._fspVersion == null || this._fspVersion.trim().length() == 0) {
                System.out.println("in migration: _fspVersion is still null");
                this._fspVersion = "F3.0";
            }
            System.out.println("in migration: _fspVersion is " + this._fspVersion);
        }
        int n = FSP_VERSIONS.indexOf(this._fspVersion);
        byte by = 0;
        by = n == -1 ? this._templateVersion : (Byte)NVRAM_VERSIONS.elementAt(n);
        if (by == this._templateVersion && this.NUM_PARTITION_SLOTS == this._releaseNumPartitionSlots) {
            return;
        }
        if (by != this._templateVersion || this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
            // empty if block
        }
        try {
            PIHMCSaveArea pIHMCSaveArea = null;
            pIHMCSaveArea = new PIHMCSaveArea(this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, by, this._cecName, this._cecMgr, this._fspVersion);
            int n2 = 0;
            for (int i = 0; i < CURRENT_RELEASE_SECTIONS.size(); ++i) {
                n2 = ((Byte)CURRENT_RELEASE_SECTIONS.elementAt(i)).intValue();
                System.out.println("in _migration: sectionID = " + n2);
                this._migrateSection(n2, pIHMCSaveArea);
            }
            String string = "/var/hsc/profiles/";
            String string2 = this._cecName.substring(this._cecName.indexOf("*") + 1, this._cecName.length());
            string = string.concat(string2) + "/tmp/";
            System.out.println("in migration: creating dir " + string);
            File file = new File(string);
            file.mkdirs();
            string = string.concat("tmpProfileData");
            System.out.println("in migration: creating temporary file " + string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            int n3 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
            randomAccessFile.write(pIHMCSaveArea._nvramData, n3, pIHMCSaveArea.NVRAM_SIZE);
            randomAccessFile.close();
            pIHMCSaveArea._recalculateChecksum(new File(string));
            this.buildNVRAMFromLocalCopy(new File(string), false, true);
            this._migrationOccurred = true;
            try {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    System.out.println("in migration: removing tmp file " + fileArray[i]);
                    fileArray[i].delete();
                }
                System.out.println("in migration: removing tmp directory");
                file.delete();
            }
            catch (Throwable throwable) {
                System.out.println("migration: failed to delete tmp files");
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            }
            if (DEBUG_ON) {
                System.out.println("End of migration");
                System.out.println("****************************************");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("0036");
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            System.out.println("finally - End of migration");
            System.out.println("****************************************");
        }
    }

    private void _migrateSection(int n, PIHMCSaveArea pIHMCSaveArea) throws PIHscServerException {
        System.out.println("in _migrateSection -------------------");
        switch (n) {
            case 0: {
                this._migrateSection0(pIHMCSaveArea);
                break;
            }
            case 1: {
                this._migrateSection1(pIHMCSaveArea);
                break;
            }
            case 2: {
                this._migrateSection2(pIHMCSaveArea);
                break;
            }
            case 3: {
                this._migrateSection3(pIHMCSaveArea);
                break;
            }
            case 4: {
                this._migrateSection4(pIHMCSaveArea);
                break;
            }
            case 5: {
                this._migrateSection5(pIHMCSaveArea);
                break;
            }
            default: {
                System.out.println("HIT AN UNKNOWN SECTION ID - SKIP IT-----------");
            }
        }
        System.out.println("leaving _migrateSection -------------------");
    }

    public void _migrateSection0(PIHMCSaveArea pIHMCSaveArea) {
        int n;
        int n2 = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
        int n3 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
        int n4 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
        for (n = 0; n < n4; ++n) {
            pIHMCSaveArea._nvramData[n3 + n] = this._nvramData[n2 + n];
        }
        n = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(SAVE_AREA_TEMPLATE_VERSION);
        pIHMCSaveArea._nvramData[n] = pIHMCSaveArea._templateVersion;
    }

    public void _migrateSection1(PIHMCSaveArea pIHMCSaveArea) {
        int n = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
        int n2 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
        int n3 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
        int n4 = n3 - n;
        System.out.println("timestamp section length = " + n4);
        for (int i = 0; i < n4; ++i) {
            pIHMCSaveArea._nvramData[n2 + i] = this._nvramData[n + i];
        }
    }

    public void _migrateSection2(PIHMCSaveArea pIHMCSaveArea) {
        int n;
        int n2 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
        int n3 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
        int n4 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
        int n5 = n4 - n2;
        System.out.println("partition section length = " + n5);
        for (n = 0; n < n5; ++n) {
            pIHMCSaveArea._nvramData[n3 + n] = this._nvramData[n2 + n];
        }
        n = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(PARTITION_TABLE_TEMPLATE_VERSION);
        pIHMCSaveArea._nvramData[n] = pIHMCSaveArea._templateVersion;
        int n6 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(NUM_PARTITIONS);
        pIHMCSaveArea._nvramData[n6] = (byte)(pIHMCSaveArea.NUM_PARTITION_SLOTS >>> 8);
        pIHMCSaveArea._nvramData[n6 + 1] = (byte)pIHMCSaveArea.NUM_PARTITION_SLOTS;
    }

    public void _migrateSection3(PIHMCSaveArea pIHMCSaveArea) {
        int n = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
        int n2 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
        int n3 = (Integer)this.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE_CHECKSUM);
        int n4 = n3 - n;
        System.out.println("default section length = " + n4);
        for (int i = 0; i < n4; ++i) {
            pIHMCSaveArea._nvramData[n2 + i] = this._nvramData[n + i];
        }
    }

    public void _migrateSection4(PIHMCSaveArea pIHMCSaveArea) {
        int n = (Integer)this.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE_CHECKSUM);
        int n2 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE_CHECKSUM);
        int n3 = (Integer)this.saveAreaDataTableOffsets.get(PROFILE_INFO_CHECKSUM);
        int n4 = n3 - n;
        System.out.println("activated section length = " + n4);
        for (int i = 0; i < n4; ++i) {
            pIHMCSaveArea._nvramData[n2 + i] = this._nvramData[n + i];
        }
    }

    public void _migrateSection5(PIHMCSaveArea pIHMCSaveArea) {
        int n;
        int n2 = (Integer)this.saveAreaDataTableOffsets.get(PROFILE_INFO_CHECKSUM);
        int n3 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(PROFILE_INFO_CHECKSUM);
        for (n = 0; n < 8; ++n) {
            pIHMCSaveArea._nvramData[n3 + n] = this._nvramData[n2 + n];
        }
        n = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(PROFILE_INFO_DATA_SIZE);
        int n4 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(VERSION_BASED_PROFILE_INFO_DATA);
        int n5 = pIHMCSaveArea.NVRAM_SIZE - n4;
        pIHMCSaveArea._nvramData[n] = (byte)(n5 >>> 24);
        pIHMCSaveArea._nvramData[n + 1] = (byte)(n5 >>> 16);
        pIHMCSaveArea._nvramData[n + 2] = (byte)(n5 >>> 8);
        pIHMCSaveArea._nvramData[n + 3] = (byte)(n5 & 0xFF);
        int n6 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(PROFILE_INFO_TEMPLATE_VERSION);
        pIHMCSaveArea._nvramData[n6] = pIHMCSaveArea._templateVersion;
        System.out.println("_nextAvailProfileSequenceID = " + this._nextAvailProfileSequenceID);
        int n7 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(NEXT_AVAILABLE_SEQUENCE_NUMBER);
        pIHMCSaveArea._nvramData[n7] = (byte)(this._nextAvailProfileSequenceID >>> 8);
        pIHMCSaveArea._nvramData[n7 + 1] = (byte)(this._nextAvailProfileSequenceID & 0xFF);
        int n8 = (Integer)this.saveAreaDataTableOffsets.get(VERSION_BASED_PROFILE_INFO_DATA);
        int n9 = (Integer)pIHMCSaveArea.saveAreaDataTableOffsets.get(VERSION_BASED_PROFILE_INFO_DATA);
        short s = 0;
        short s2 = 0;
        int n10 = (Integer)this.lparProfileDataTableOffsets.get(TEMPLATE_VERSION);
        int n11 = (Integer)pIHMCSaveArea.lparProfileDataTableOffsets.get(TEMPLATE_VERSION);
        System.out.println(" srcLparTemplateVersionOffset = " + n10);
        System.out.println(" destLparTemplateVersionOffset = " + n11);
        while (n9 < pIHMCSaveArea.NVRAM_SIZE) {
            s = (short)(this._nvramData[n8] << 8 | this._nvramData[n8 + 1] & 0xFF);
            System.out.println("PROFILE LENGTH = " + s);
            if (s == 0) {
                System.out.println("no more profiles --------------------");
                break;
            }
            pIHMCSaveArea._nvramData[n9] = this._nvramData[n8];
            pIHMCSaveArea._nvramData[n9 + 1] = this._nvramData[n8 + 1];
            pIHMCSaveArea._nvramData[n9 + 2] = pIHMCSaveArea._templateVersion;
            s2 = this._nvramData[n8 + n10];
            System.out.println("src templateVersion = " + s2);
            if (s2 == -1) {
                System.out.println("profile templateVersion is INVALID_PROFILE");
                pIHMCSaveArea._nvramData[n9 + n11] = (byte)s2;
            } else {
                s2 = s2 < 50 ? (short)(0 + pIHMCSaveArea._templateVersion) : (s2 < 100 ? (short)(50 + pIHMCSaveArea._templateVersion) : (short)(100 + pIHMCSaveArea._templateVersion));
                System.out.println("dest templateVersion = " + s2);
                pIHMCSaveArea._nvramData[n9 + n11] = (byte)s2;
            }
            for (int i = 3; i < s - 3; ++i) {
                pIHMCSaveArea._nvramData[n9 + i] = this._nvramData[n8 + i];
            }
            System.out.println("srcProfileInfoOffset = " + (n8 += s));
            System.out.println("destProfileInfoOffset = " + (n9 += s));
        }
    }

    /*
     * Exception decompiling
     */
    public Vector getLPARProfilesAtPartition(int var1_1, boolean var2_2, boolean var3_3) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String _usingCspLparInfo(int n) throws PIHscServerException {
        return null;
    }

    private void _initializeData(String string, boolean bl) throws PIHscServerException {
        int n;
        Object object;
        String string2;
        Object object2;
        int n2;
        Object var3_3 = null;
        FspCecTime fspCecTime = null;
        Object var5_5 = null;
        Object var6_6 = null;
        boolean bl2 = false;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        int n3 = 0;
        int n4 = 0;
        if (DEBUG_ON) {
            System.out.println("_initializeData -- fspVersion = " + string);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "NVRAM is not yet initialized yet! - Need to initialize the NVRAM");
        }
        if (DEBUG_ON) {
            System.out.println("_initializeData: The PIHMCSaveArea has not yet been initialized");
        }
        int n5 = FSP_VERSIONS.indexOf(string);
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "verIndex = " + n5);
        }
        if (DEBUG_ON) {
            System.out.println("_initializeData: verIndex = " + n5);
        }
        if (n5 == -1) {
            System.out.println("UNKNOWN FSP VERSION **********************************************");
        }
        if (n5 == -1) {
            this._templateVersion = 0;
            this._profileTemplateVersion = 1;
        } else {
            this._templateVersion = this.getFSPTemplateVersion(string);
            n2 = HMC_TEMPLATE_VERSIONS.indexOf(new Byte(this._templateVersion));
            this._profileTemplateVersion = (Byte)HMC_PROFILE_TEMPLATE_VERSIONS.elementAt(n2);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apnvhscF", "_templateVersion = " + this._templateVersion);
            Trace.trace("apnvhscF", "_profileTemplateVersion = " + this._profileTemplateVersion);
        }
        if (DEBUG_ON) {
            System.out.println("_templateVersion = " + this._templateVersion);
            System.out.println("_profileTemplateVersion = " + this._profileTemplateVersion);
        }
        this._bufferedNVRAMSize = (long)((double)this.NVRAM_SIZE * 0.9);
        this._initializeOffsets(false, true);
        System.out.println("NVRAM_SIZE = " + this.NVRAM_SIZE);
        System.out.println("NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
        this._nvramTimestamp = new byte[11];
        this._partitionTableTimestamp = new byte[11];
        this._defaultProfTableTimestamp = new byte[11];
        this._activatedProfTableTimestamp = new byte[11];
        this._profileInfoTimestamp = new byte[11];
        this._nvramData = new byte[this.NVRAM_SIZE];
        this._profileTable = new Hashtable();
        this._profilesAtPartitionTable = new Vector[this.NUM_PARTITION_SLOTS + 1];
        this._nextAvailProfileSequenceID = 1;
        for (n2 = 0; n2 < this.NUM_PARTITION_SLOTS + 1; ++n2) {
            this._profilesAtPartitionTable[n2] = new Vector();
        }
        this._partitionTable = new String[this.NUM_PARTITION_SLOTS];
        this._fastActivation = new boolean[this.NUM_PARTITION_SLOTS];
        this._partitionNameTable = new String[this.NUM_PARTITION_SLOTS];
        this._partitionOSTypeTable = new short[this.NUM_PARTITION_SLOTS];
        this._defaultProfTable = new int[this.NUM_PARTITION_SLOTS];
        this._activatedProfTable = new int[this.NUM_PARTITION_SLOTS];
        if (var6_6 != null) {
            throw var6_6;
        }
        if (bl) {
            Object object3;
            System.out.println("in _initializeData: checking for backupFile............");
            String string3 = "/var/hsc/profiles/";
            object2 = string3.concat(this._cecName) + "/";
            string2 = ((String)object2).concat("backupFile");
            object = new File((String)object2);
            String string4 = this._cecName.substring(this._cecName.indexOf("*") + 1, this._cecName.length());
            String string5 = string3.concat(string4) + "/";
            String string6 = string5.concat("backupFile");
            System.out.println("in _initializeData: old temp file name = " + string2);
            System.out.println("in _initializeData: new temp file name = " + string6);
            File file = new File(string2);
            File file2 = new File(string6);
            boolean bl3 = false;
            if (file2.exists()) {
                bl3 = true;
                if (file.exists()) {
                    if (DEBUG_ON) {
                        System.out.println("HMC Save Area has been cleared.");
                        System.out.println("NEW convention: old backup file also exists - removing old copy");
                    }
                    object3 = ((File)object).listFiles();
                    for (int i = 0; i < ((File[])object3).length; ++i) {
                        Object object4 = object3[i];
                        ((File)object4).delete();
                    }
                    ((File)object).delete();
                }
            } else if (file.exists()) {
                bl3 = true;
                if (DEBUG_ON) {
                    System.out.println("HMC Save Area has been cleared.");
                    System.out.println("OLD convention: old backup file exists");
                }
                try {
                    object3 = new File(string5);
                    ((File)object3).mkdirs();
                    File[] fileArray = ((File)object).listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file3 = fileArray[i];
                        String string7 = file3.getName();
                        System.out.println("in _initializeData: moving oldFileName = " + string7);
                        File file4 = new File(string5.concat(string7));
                        FileOutputStream fileOutputStream = new FileOutputStream(file4);
                        FileInputStream fileInputStream = new FileInputStream(file3);
                        byte[] byArray = new byte[(int)file3.length()];
                        fileInputStream.read(byArray);
                        fileOutputStream.write(byArray);
                        fileInputStream.close();
                        fileOutputStream.close();
                        file3.delete();
                    }
                    ((File)object).delete();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    System.out.println("in _initialize: old backup file exists - FileNotFoundException");
                    HSCLogUtils.serverLog(fileNotFoundException, HSCLogUtils._NVRAMClassLogInfo);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    System.out.println("in _initialize: old backup file exists - SecurityException");
                    HSCLogUtils.serverLog(securityException, HSCLogUtils._NVRAMClassLogInfo);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.out.println("in _initialize: old backup file exists - Exception = " + throwable);
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                }
            }
            if (bl3) {
                System.out.println("HMC Save Area has been cleared.");
                this.handleBadNVRAMError();
                this._cecMgr.setCecRecoveryState();
                throw new PIHscServerException("0031", null);
            }
        }
        this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
        this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
        byte[] byArray = new byte[this.NVRAM_SIZE];
        try {
            this._nvramDOutputStream.write(byArray, this.HMC_SAVE_AREA_BEGINNING_OFFSET, 8);
            this._nvramDOutputStream.writeByte(this._templateVersion);
            if (DEBUG_ON) {
                System.out.println("_initializeData _templateVersion = " + this._templateVersion);
            }
            object2 = null;
            string2 = null;
            if (this._cecName != null) {
                string2 = this._cecName.substring(this._cecName.indexOf(42) + 1);
            }
            object2 = (object = PIVirtualEthernetMACAddressUtils.getDefaultMACAddressPrefix(string2)) == null ? (Object)new byte[3] : (Object)ByteUtilities.hexStringToByteArray(ByteUtilities.toHexString(new Long(Long.parseLong((String)object, 16)), 6));
            System.out.println("in buildNVRAM: _initializeData() - mac addr prefix = " + (String)object);
            System.out.println("in buildNVRAM: _initializeData() - mac addr prefix bytes = " + object2);
            this._nvramDOutputStream.write((byte[])object2, 0, 3);
            n3 = (Integer)this.saveAreaDataTableOffsets.get(SYS_CREDENTIAL_USER_ID);
            n4 = (Integer)this.saveAreaDataTableOffsets.get(NUM_PARTITIONS);
            this._nvramDOutputStream.write(byArray, n3, n4 - n3);
            this._nvramDOutputStream.writeShort(this.NUM_PARTITION_SLOTS);
            this._nvramDOutputStream.writeByte(this._templateVersion);
            n3 = (Integer)this.saveAreaDataTableOffsets.get(VERSION_BASED_PARTITION_TABLE_DATA);
            n4 = (Integer)this.saveAreaDataTableOffsets.get(PROFILE_INFO_DATA_SIZE);
            this._nvramDOutputStream.write(byArray, n3, n4 - n3);
            n3 = (Integer)this.saveAreaDataTableOffsets.get(VERSION_BASED_PROFILE_INFO_DATA);
            System.out.println("in _initializeData: _profileTableSize = " + this._profileTableSize);
            this._profileTableSize = this.NVRAM_SIZE - n3;
            this._nvramDOutputStream.writeInt(this._profileTableSize);
            this._nvramDOutputStream.writeByte(this._profileTemplateVersion);
            System.out.println("in _initializeData: _nextAvailProfileSequenceID = " + this._nextAvailProfileSequenceID);
            if (this._nextAvailProfileSequenceID != 1) {
                System.out.println("in _initializeData: _nextAvailProfileSequenceID is corrupted !!!!!!!!!!!!!!!!!!!!!");
                System.out.println("resetting to 1 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                this._nextAvailProfileSequenceID = 1;
            }
            this._nvramDOutputStream.writeShort((short)this._nextAvailProfileSequenceID);
            n3 = (Integer)this.saveAreaDataTableOffsets.get(VERSION_BASED_PROFILE_INFO_DATA);
            this._nvramDOutputStream.write(byArray, n3, this.NVRAM_SIZE - n3);
            if (DEBUG_ON) {
                System.out.println("in _initializeData: _nvramData size = " + this._nvramData.length);
            }
            this._nvramData = this._nvramBAOutputStream.toByteArray();
            if (DEBUG_ON) {
                System.out.println("in _initializeData: _nvramData size = " + this._nvramData.length);
            }
            this._nvramDataSize = n3;
            this._nvramDOutputStream.close();
            this._nvramBAOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            throw new PIHscServerException("0007", throwable);
        }
        try {
            fspCecTime = this._cecMgr.getCmdHelper().getCecTimeOfDay(this._cecMgr.getCecName());
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._NVRAMClassLogInfo);
            throw new PIHscServerException("0007", pIHscCmdMgrException);
        }
        object2 = this.getTime(fspCecTime);
        Object[] objectArray = (Object[])this.saveAreaDataTable.get(GLOBAL_TIMESTAMP);
        n3 = (Integer)objectArray[1];
        for (n = 0; n < 11; ++n) {
            this._nvramData[n3 + n] = (byte)object2[n];
            this._nvramTimestamp = (byte[])object2.clone();
        }
        n = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
        n3 = n + 8;
        n4 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
        this._checksumCalc.reset();
        this._checksumCalc.update(this._nvramData, n3, n4 - n3);
        this._checksum = this._checksumCalc.getValue();
        this.writeIntegralToNvramData(this._checksum, n, (short)8);
        System.out.println("in _initializeData: BASIC_INFO_CHECKSUM offset = " + n);
        System.out.println("in _initializeData: BASIC INFO CHECKSUM = " + this._checksum);
        n = n4;
        n3 = n + 8;
        n4 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
        this._checksumCalc.reset();
        this._checksumCalc.update(this._nvramData, n3, n4 - n3);
        this._checksum = this._checksumCalc.getValue();
        this.writeIntegralToNvramData(this._checksum, n, (short)8);
        n = n4;
        n3 = n + 8;
        n4 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
        this._checksumCalc.reset();
        this._checksumCalc.update(this._nvramData, n3, n4 - n3);
        this._checksum = this._checksumCalc.getValue();
        this.writeIntegralToNvramData(this._checksum, n, (short)8);
        n = n4;
        n3 = n + 8;
        n4 = (Integer)this.saveAreaDataTableOffsets.get(ACTIVATED_PROF_TABLE_CHECKSUM);
        this._checksumCalc.reset();
        this._checksumCalc.update(this._nvramData, n3, n4 - n3);
        this._checksum = this._checksumCalc.getValue();
        this.writeIntegralToNvramData(this._checksum, n, (short)8);
        n = n4;
        n3 = n + 8;
        n4 = (Integer)this.saveAreaDataTableOffsets.get(PROFILE_INFO_CHECKSUM);
        this._checksumCalc.reset();
        this._checksumCalc.update(this._nvramData, n3, n4 - n3);
        this._checksum = this._checksumCalc.getValue();
        this.writeIntegralToNvramData(this._checksum, n, (short)8);
        n = n4;
        n3 = n + 8;
        this._checksumCalc.reset();
        this._checksumCalc.update(this._nvramData, n3, this.NVRAM_SIZE - n3);
        this._checksum = this._checksumCalc.getValue();
        this.writeIntegralToNvramData(this._checksum, n, (short)8);
        object = new byte[this.NVRAM_SIZE];
        System.arraycopy(this._nvramData, this.HMC_SAVE_AREA_BEGINNING_OFFSET, object, 0, this.NVRAM_SIZE);
        this._writeDataToFSP((byte[])object, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
    }

    private void _updateVariables(boolean bl, boolean bl2, boolean bl3) throws PIHscServerException {
        if (DEBUG_ON) {
            System.out.println("In _updateVariable _templateVersion = " + this._templateVersion);
            System.out.println("In _updateVariable _profileTemplateVersion = " + this._profileTemplateVersion);
            System.out.println("In _updateVariable _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
            System.out.println("In _updateVariable NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
        }
        this._initializeOffsets(bl2, bl3);
        if (bl) {
            this._nvramTimestamp = new byte[11];
            this._partitionTableTimestamp = new byte[11];
            this._defaultProfTableTimestamp = new byte[11];
            this._activatedProfTableTimestamp = new byte[11];
            this._profileInfoTimestamp = new byte[11];
            this._nvramData = new byte[this.NVRAM_SIZE];
            this._profileTable = new Hashtable();
            this._profilesAtPartitionTable = new Vector[this._releaseNumPartitionSlots + 1];
            for (int i = 0; i < this._releaseNumPartitionSlots + 1; ++i) {
                this._profilesAtPartitionTable[i] = new Vector();
            }
            this._partitionTable = new String[this._releaseNumPartitionSlots];
            this._partitionNameTable = new String[this._releaseNumPartitionSlots];
            this._fastActivation = new boolean[this._releaseNumPartitionSlots];
            this._partitionOSTypeTable = new short[this._releaseNumPartitionSlots];
            this._defaultProfTable = new int[this._releaseNumPartitionSlots];
            this._activatedProfTable = new int[this._releaseNumPartitionSlots];
        }
    }

    public boolean validBackupFile(File file) throws PIHscServerException {
        try {
            if (DEBUG_ON) {
                System.out.println(" in validBackupFile -------------- ");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[this.NVRAM_SIZE];
            fileInputStream.read(byArray, 0, (int)file.length());
            fileInputStream.close();
            this._checksumCalc.reset();
            this._checksumCalc.update(byArray, this.CORRUPTED_BYTE_OFFSET, this.VALIDATION_CHECKSUM_OFFSET - this.CORRUPTED_BYTE_OFFSET);
            byte[] byArray2 = new byte[8];
            for (int i = 0; i < 8; ++i) {
                byArray2[i] = byArray[this.VALIDATION_CHECKSUM_OFFSET + i];
            }
            BigInteger bigInteger = new BigInteger(byArray2);
            if (bigInteger.longValue() != this._checksumCalc.getValue()) {
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            HSCLogUtils.serverLog(fileNotFoundException, HSCLogUtils._NVRAMClassLogInfo);
            throw new PIHscServerException("1198", new String[]{file.getName()}, fileNotFoundException);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            HSCLogUtils.serverLog(securityException, HSCLogUtils._NVRAMClassLogInfo);
            throw new PIHscServerException("1196", new String[]{file.getName()}, securityException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            throw new PIHscServerException("1197", new String[]{file.getName()}, throwable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFastActivation(int n) throws PIHscServerException {
        boolean bl;
        block16: {
            int n2 = 128;
            boolean bl2 = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getFastActivation");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getFastActivation: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl2 = true;
                bl = this._getFastActivation(n, true);
                Object var8_9 = null;
                if (!bl2) break block16;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("004b", throwable);
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    if (bl2) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
        return bl;
    }

    /*
     * Exception decompiling
     */
    private boolean _getFastActivation(int var1_1, boolean var2_2) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFastActivation(int n, boolean bl) throws PIHscServerException {
        block14: {
            int n2 = 1;
            boolean bl2 = false;
            try {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setFastActivation");
                    }
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    int n3 = (Integer)this.saveAreaDataTableOffsets.get(DEFAULT_PROF_TABLE_CHECKSUM);
                    FspFileOpenResponse fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n3);
                    if (fspFileOpenResponse == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setFastActivation: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl2 = true;
                    this._setFastActivation(n, bl, true);
                }
                catch (Throwable throwable) {
                    n2 = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("004a", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var9_10 = null;
                if (!bl2) break block14;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (bl2) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n2);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * Exception decompiling
     */
    private void _setFastActivation(int var1_1, boolean var2_2, boolean var3_3) throws PIHscServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseSaveAreaData(boolean bl) {
        NodeList nodeList = this.saveAreaFormatDoc.getElementsByTagName(SAVE_AREA_FORMAT);
        Node node = nodeList.item(0);
        this.parseNodeList(node, bl, 0, false);
    }

    private void parseSysProfileData(boolean bl) {
        Element element = null;
        String string = VERSION_BASED_PROFILE_INFO_DATA;
        String string2 = Integer.toString(this._profileTemplateVersion);
        string = string + "_" + string2;
        element = this.saveAreaFormatDoc.getElementById(string);
        System.out.println("parsing SYSTEM PROFILE node name = " + string);
        this.parseNodeList(element, bl, 1, false);
    }

    private void parseFSPMProfileData(boolean bl) {
        Element element = null;
        String string = VERSION_BASED_PROFILE_INFO_DATA;
        String string2 = Integer.toString(this._profileTemplateVersion);
        string = string + "_" + string2;
        element = this.saveAreaFormatDoc.getElementById(string);
        System.out.println("parsing FSPM PROFILE node name = " + string);
        this.parseNodeList(element, bl, 3, false);
    }

    private void parseLPARProfileData(boolean bl) {
        Element element = null;
        String string = VERSION_BASED_PROFILE_INFO_DATA;
        String string2 = Integer.toString(this._profileTemplateVersion);
        string = string + "_" + string2;
        element = this.saveAreaFormatDoc.getElementById(string);
        System.out.println("parsing LPAR PROFILE node name = " + string);
        this.parseNodeList(element, bl, 2, false);
    }

    private void parseNodeList(Node node, boolean bl, int n, boolean bl2) {
        Object var5_5 = null;
        String string = null;
        Node node2 = node;
        String string2 = node2.getNodeName();
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        block12: for (int i = 0; i < n2; ++i) {
            Node node3 = nodeList.item(i);
            String string3 = node3.getNodeName();
            block0 : switch (node3.getNodeType()) {
                case 3: {
                    continue block12;
                }
                case 1: {
                    string = ((Element)node3).getAttribute(NAME);
                    Integer n3 = (Integer)this.mapTable.get(string3);
                    switch (n3) {
                        case 0: {
                            this.parseBasicType(string, node3, n, bl2);
                            break block0;
                        }
                        case 1: {
                            this.parseArrayType(string, node3, bl, n, bl2);
                            break block0;
                        }
                        case 2: {
                            this.parseVersionBasedStruct(string, node3, bl, n, bl2);
                            break block0;
                        }
                        case 3: {
                            this.parseString(string, node3, bl, n, bl2);
                            break block0;
                        }
                        case 4: {
                            this.parseSet(string, node3, bl, n, bl2);
                            break block0;
                        }
                        case 5: {
                            this.parseCheckNonZero(string, node3, bl, n, bl2);
                            break block0;
                        }
                    }
                }
            }
        }
    }

    private void parseBasicType(String string, Node node, int n, boolean bl) {
        String string2 = ((Element)node).getAttribute(TYPE);
        Object[] objectArray = new Object[]{string2, new Integer(0)};
        switch (n) {
            case 0: {
                this.saveAreaDataTable.put(string, objectArray);
                if (bl) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.saveAreaElementSequence.add(string);
                break;
            }
            case 1: {
                this.sysProfileDataTable.put(string, objectArray);
                if (bl) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.sysProfileElementSequence.add(string);
                break;
            }
            case 3: {
                this.fspmProfileDataTable.put(string, objectArray);
                if (bl) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.fspmProfileElementSequence.add(string);
                break;
            }
            case 2: {
                this.lparProfileDataTable.put(string, objectArray);
                if (bl) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.lparProfileElementSequence.add(string);
                break;
            }
            default: {
                System.out.println("ERROR - bad parseType");
            }
        }
    }

    private void parseArrayType(String string, Node node, boolean bl, int n, boolean bl2) {
        Object[] objectArray = null;
        Element element = null;
        String string2 = ((Element)node).getAttribute(TYPE);
        String string3 = ((Element)node).getAttribute(SIZE);
        String string4 = null;
        String string5 = null;
        if (string2.equals(VERSION_BASED_STRUCT)) {
            string4 = ((Element)node).getAttribute(VERSION);
            objectArray = new Object[6];
            String string6 = null;
            switch (n) {
                case 0: {
                    string6 = Integer.toString(this._templateVersion);
                    break;
                }
                case 1: {
                    string6 = Integer.toString(this._profileTemplateVersion);
                    break;
                }
                case 2: {
                    string6 = Integer.toString(this._profileTemplateVersion + 100);
                    break;
                }
                case 3: {
                    string6 = Integer.toString(this._profileTemplateVersion + 50);
                }
            }
            string5 = string + "_" + string6;
            objectArray[4] = string5;
            System.out.println("in parseArrayType: childNodeName = " + string5);
            element = this.saveAreaFormatDoc.getElementById(string5);
            this.tmpSubSequence = new Vector();
            this.parseNodeList(element, bl, n, true);
            objectArray[5] = this.tmpSubSequence.clone();
        } else if (string2.equals(STRUCT)) {
            objectArray = new Object[6];
            NodeList nodeList = null;
            Node node2 = null;
            string5 = string;
            objectArray[4] = string5;
            nodeList = this.saveAreaFormatDoc.getElementsByTagName(string5);
            node2 = nodeList.item(0);
            this.tmpSubSequence = new Vector();
            this.parseNodeList(node2, bl, n, true);
            objectArray[5] = this.tmpSubSequence.clone();
        } else {
            objectArray = new Object[]{ARRAY_TYPE, new Integer(0), string3, string2};
        }
        switch (n) {
            case 0: {
                this.saveAreaDataTable.put(string, objectArray);
                if (bl2) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.saveAreaElementSequence.add(string);
                break;
            }
            case 1: {
                this.sysProfileDataTable.put(string, objectArray);
                if (bl2) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.sysProfileElementSequence.add(string);
                break;
            }
            case 2: {
                this.lparProfileDataTable.put(string, objectArray);
                if (bl2) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.lparProfileElementSequence.add(string);
                break;
            }
            case 3: {
                this.fspmProfileDataTable.put(string, objectArray);
                if (bl2) {
                    this.tmpSubSequence.add(string);
                    break;
                }
                this.fspmProfileElementSequence.add(string);
                break;
            }
            default: {
                System.out.println("ERROR - bad parseType");
            }
        }
    }

    private void parseVersionBasedStruct(String string, Node node, boolean bl, int n, boolean bl2) {
        try {
            Object[] objectArray;
            String string2;
            System.out.println("In parseVersionBasedStruct: nodeName = " + string);
            System.out.println("node = " + node);
            System.out.println("initializingData = " + bl);
            System.out.println("parseType = " + n);
            System.out.println("subSeq = " + bl2);
            String string3 = ((Element)node).getAttribute(VERSION);
            System.out.println("node version attribute = " + string3);
            String string4 = null;
            Element element = null;
            Object var9_10 = null;
            Object var11_11 = null;
            if (bl) {
                string2 = Integer.toString(this._templateVersion);
            } else {
                System.out.println(" -------------------UNREACHABLE-----------------------------------------");
                System.out.println("in parseVersionBasedStruct - using nodeAttrVersion for templateVersion");
                System.out.println(" -----------------------------------------------------------------------");
                objectArray = (Object[])this.saveAreaDataTable.get(string3);
                string2 = Integer.toString(objectArray.byteValue());
            }
            System.out.println("in parseVersionBasedStruct: templateVersion = " + string2);
            System.out.println("in parseVersionBasedStruct: _templateVersion = " + this._templateVersion);
            System.out.println("in parseVersionBasedStruct: _profileTemplateVersion = " + this._profileTemplateVersion);
            if (bl && string.equals(VERSION_BASED_PROFILE_INFO_DATA)) {
                objectArray = new Object[]{VERSION_BASED_STRUCT, new Integer(0)};
                this.saveAreaDataTable.put(string, objectArray);
                this.saveAreaElementSequence.add(string);
                System.out.println("in parseVersionBasedStruct - returning having found VERSION_BASED_PROFILE_INFO_DATA");
                return;
            }
            switch (n) {
                case 0: {
                    string4 = string + "_" + this._templateVersion;
                    break;
                }
                case 1: {
                    string4 = string + "_" + this._profileTemplateVersion;
                    System.out.println("in parseVersionBasedStruct: SYS_PROFILE_PARSE childNodeName = " + string4);
                    break;
                }
                case 2: {
                    string2 = Integer.toString(this._profileTemplateVersion + 100);
                    string4 = string + "_" + string2;
                    System.out.println("in parseVersionBasedStruct: LPAR_PROFILE_PARSE childNodeName = " + string4);
                    break;
                }
                case 3: {
                    string2 = Integer.toString(this._profileTemplateVersion + 50);
                    string4 = string + "_" + string2;
                    System.out.println("in parseVersionBasedStruct:  FSPM::::::: parseVersionBasedStruct: " + string4);
                    break;
                }
                default: {
                    System.out.println("ERROR - bad parseType");
                }
            }
            element = this.saveAreaFormatDoc.getElementById(string4);
            this.parseNodeList(element, bl, n, bl2);
        }
        catch (Throwable throwable) {
            System.out.println("got a sax = " + throwable);
        }
    }

    private void parseSet(String string, Node node, boolean bl, int n, boolean bl2) {
        String string2 = null;
        NodeList nodeList = null;
        Node node2 = null;
        String string3 = ((Element)node).getAttribute(TYPE);
        if (!string3.equals(STRUCT)) {
            System.out.println("ERROR PARSING SET NODE");
            return;
        }
        string2 = string;
        nodeList = this.saveAreaFormatDoc.getElementsByTagName(string2);
        node2 = nodeList.item(0);
        this.parseNodeList(node2, bl, n, bl2);
    }

    private void parseString(String string, Node node, boolean bl, int n, boolean bl2) {
        String string2 = ((Element)node).getAttribute(LENGTH);
        Object[] objectArray = new Object[]{STRING, new Integer(0), string2};
        switch (n) {
            case 0: {
                this.saveAreaDataTable.put(string, objectArray);
                if (!bl2) {
                    this.saveAreaElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            case 1: {
                this.sysProfileDataTable.put(string, objectArray);
                if (!bl2) {
                    this.sysProfileElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            case 2: {
                this.lparProfileDataTable.put(string, objectArray);
                if (!bl2) {
                    this.lparProfileElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            case 3: {
                this.fspmProfileDataTable.put(string, objectArray);
                if (!bl2) {
                    this.fspmProfileElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            default: {
                System.out.println("parseERROR - bad parseType");
            }
        }
    }

    private void parseCheckNonZero(String string, Node node, boolean bl, int n, boolean bl2) {
        String string2 = ((Element)node).getAttribute(TYPE);
        String string3 = ((Element)node).getAttribute(VALUE);
        Object[] objectArray = new Object[]{STRING, new Integer(0), string2, string3};
        switch (n) {
            case 0: {
                this.saveAreaDataTable.put(string, objectArray);
                if (!bl2) {
                    this.saveAreaElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            case 1: {
                this.sysProfileDataTable.put(string, objectArray);
                if (!bl2) {
                    this.sysProfileElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            case 2: {
                this.lparProfileDataTable.put(string, objectArray);
                if (!bl2) {
                    this.lparProfileElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            case 3: {
                this.fspmProfileDataTable.put(string, objectArray);
                if (!bl2) {
                    this.fspmProfileElementSequence.add(string);
                    break;
                }
                this.tmpSubSequence.add(string);
                break;
            }
            default: {
                System.out.println("ERROR - bad parseType");
            }
        }
    }

    public int getNextProfileID() throws PIHscServerException {
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "-> getNextProfileID");
            }
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In getNextProfileID");
            }
            this.buildNVRAM(false, null, true, true, true);
            if (DEBUG_ON) {
                System.out.println("return = " + this._nextAvailProfileSequenceID);
                System.out.println("End of getNextProfileID");
                System.out.println("****************************************");
            }
            int n = this._nextAvailProfileSequenceID;
            return n;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0049", throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("apnvhscT", "<- getNextProfileSequenceID");
            }
        }
    }

    public static PIHMCSaveArea getPIHMCSaveAreaInstance(String string) {
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string);
        return omCecMgr.getSaveArea();
    }

    private void _initializeOffsets(boolean bl, boolean bl2) throws PIHscServerException {
        try {
            int n = this.HMC_SAVE_AREA_BEGINNING_OFFSET;
            System.out.println("_initializeOffsets: initializing offset tables ");
            this.saveAreaDataTableOffsets = new Hashtable();
            this.lparProfileDataTableOffsets = new Hashtable();
            this.sysProfileDataTableOffsets = new Hashtable();
            this.fspmProfileDataTableOffsets = new Hashtable();
            if (bl2) {
                this.saveAreaElementSequence = new Vector();
                this.sysProfileElementSequence = new Vector();
                this.fspmProfileElementSequence = new Vector();
                this.lparProfileElementSequence = new Vector();
                this.tmpSubSequence = new Vector();
                this.parseSaveAreaData(true);
                this.parseSysProfileData(true);
                this.parseFSPMProfileData(true);
                this.parseLPARProfileData(true);
            }
            this._initializeSaveAreaDataOffsets();
            this._initializeLPARProfileDataOffsets();
            System.out.println("FSPM: initializing offsets;;;;;;;;;;;;;;;;;;;;;;;;;;;");
            this._initializeFSPMProfileDataOffsets();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0030", throwable);
        }
    }

    private void _initializeSaveAreaDataOffsets() {
        int n = this.HMC_SAVE_AREA_BEGINNING_OFFSET;
        for (int i = 0; i < this.saveAreaElementSequence.size(); ++i) {
            String string;
            String string2 = (String)this.saveAreaElementSequence.elementAt(i);
            Object[] objectArray = (Object[])this.saveAreaDataTable.get(string2);
            objectArray[1] = new Integer(n);
            this.saveAreaDataTableOffsets.put(string2, new Integer(n));
            System.out.println("Element name: " + string2 + " offset: " + n);
            this.saveAreaDataTable.put(string2, objectArray);
            String string3 = (String)objectArray[0];
            int n2 = 0;
            if (string3.equals(ARRAY_TYPE)) {
                string = (String)objectArray[2];
                int n3 = 0;
                if (string.equals(NUM_PARTITIONS)) {
                    n3 = this._releaseNumPartitionSlots;
                    System.out.println("_initializeSaveAreaDataOffsets: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                    System.out.println("_initializeSaveAreaDataOffsets: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                } else {
                    n3 = Integer.parseInt(string);
                }
                String string4 = (String)objectArray[3];
                if (string4.equals(VERSION_BASED_STRUCT)) {
                    String string5 = (String)objectArray[4];
                    n2 = n3 * (Integer)this._dataTypeSizeTable.get(string5);
                } else {
                    n2 = n3 * (Integer)this._dataTypeSizeTable.get(string4);
                }
                n += n2;
                continue;
            }
            if (string3.equals(STRING)) {
                string = (String)objectArray[2];
                n2 = Integer.parseInt(string);
                n += n2;
                continue;
            }
            n2 = (Integer)this._dataTypeSizeTable.get(string3);
            n += n2;
        }
    }

    private void _initializeLPARProfileDataOffsets() {
        System.out.println("entering _initializeLPARProfileDataOffsets ----------- ");
        int n = 0;
        for (int i = 0; i < this.lparProfileElementSequence.size(); ++i) {
            String string;
            String string2 = (String)this.lparProfileElementSequence.elementAt(i);
            Object[] objectArray = (Object[])this.lparProfileDataTable.get(string2);
            objectArray[1] = new Integer(n);
            this.lparProfileDataTableOffsets.put(string2, new Integer(n));
            System.out.println("initializeLPARProfileDataOffsets:  Element name: " + string2 + " offset: " + n);
            this.lparProfileDataTable.put(string2, objectArray);
            if (string2.equals(PARTITION_ID)) {
                return;
            }
            String string3 = (String)objectArray[0];
            int n2 = 0;
            if (string3.equals(ARRAY_TYPE)) {
                string = (String)objectArray[2];
                int n3 = 0;
                if (string.equals(NUM_PARTITIONS)) {
                    n3 = this._releaseNumPartitionSlots;
                    System.out.println("_initializeLPARProfileDataOffsets: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                    System.out.println("_initializeLPARProfileDataOffsets: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                } else {
                    n3 = Integer.parseInt(string);
                }
                String string4 = (String)objectArray[3];
                if (string4.equals(VERSION_BASED_STRUCT)) {
                    String string5 = (String)objectArray[4];
                    n2 = n3 * (Integer)this._dataTypeSizeTable.get(string5);
                } else {
                    n2 = n3 * (Integer)this._dataTypeSizeTable.get(string4);
                }
                n += n2;
                continue;
            }
            if (string3.equals(STRING)) {
                string = (String)objectArray[2];
                n2 = Integer.parseInt(string);
                n += n2;
                continue;
            }
            n2 = (Integer)this._dataTypeSizeTable.get(string3);
            n += n2;
        }
        System.out.println("leaving _initializeLPARProfileDataOffsets ----------- ");
    }

    private void _initializeFSPMProfileDataOffsets() {
        System.out.println("entering _initializeFSPMProfileDataOffsets ----------- ");
        int n = 0;
        for (int i = 0; i < this.fspmProfileElementSequence.size(); ++i) {
            String string = (String)this.fspmProfileElementSequence.elementAt(i);
            Object[] objectArray = (Object[])this.fspmProfileDataTable.get(string);
            objectArray[1] = new Integer(n);
            this.fspmProfileDataTableOffsets.put(string, new Integer(n));
            this.fspmProfileDataTable.put(string, objectArray);
            String string2 = (String)objectArray[0];
            int n2 = 0;
            if (string2.equals(STRING)) {
                String string3 = (String)objectArray[2];
                n2 = Integer.parseInt(string3);
                n += n2;
                continue;
            }
            n2 = (Integer)this._dataTypeSizeTable.get(string2);
            n += n2;
        }
        System.out.println("leaving _initializeFSPMProfileDataOffsets ----------- ");
    }

    private long readUnsignedInt(DataInputStream dataInputStream) throws PIHscServerException {
        long l = 0L;
        int[] nArray = new int[4];
        try {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = dataInputStream.readUnsignedByte();
            }
            l = (long)(nArray[0] & 0xFF) << 24 | (long)((nArray[1] & 0xFF) << 16) | (long)((nArray[2] & 0xFF) << 8) | (long)(nArray[3] & 0xFF);
            return l;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("0007", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVirtEthernetMacAddrPrefix() throws PIHscServerException {
        String string;
        block17: {
            int n = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getVirtEthernetMacAddrPrefix");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getVirtEthernetMacAddrPrefix: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                this.buildNVRAM(false, null, true, true, true);
                if (DEBUG_ON) {
                    System.out.println("return = " + this._macAddrPrefix);
                    System.out.println("End of getVirtEthernetMacAddrPrefix");
                    System.out.println("****************************************");
                }
                string = this._macAddrPrefix;
                Object var7_8 = null;
                if (!bl) break block17;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("0022", throwable);
                }
                catch (Throwable throwable2) {
                    Object var7_9 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVirtEthernetMacAddrPrefix(String string) throws PIHscServerException {
        block17: {
            int n = 1;
            boolean bl = false;
            try {
                try {
                    int n2;
                    int n3;
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setVirtEthernetMacAddrPrefix");
                        System.out.println("macAddrPrefix = " + string);
                    }
                    Object var4_4 = null;
                    Object var5_6 = null;
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    int n4 = (Integer)this.saveAreaDataTableOffsets.get(LAST_MODIFIED_PARTITION_TABLE_TIMESTAMP);
                    FspFileOpenResponse fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n4);
                    if (fspFileOpenResponse == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setVirtEthernetMacAddrPrefix: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this.buildNVRAM(false, null, true, true, false);
                    this._macAddrPrefix = string;
                    byte[] byArray = null;
                    byArray = string == null ? new byte[3] : ByteUtilities.hexStringToByteArray(ByteUtilities.toHexString(new Long(Long.parseLong(string, 16)), 6));
                    int n5 = (Integer)this.saveAreaDataTableOffsets.get(VIRTUAL_ETHERNET_MAC_ADDR_PREFIX);
                    for (n3 = 0; n3 < 3; ++n3) {
                        this._nvramData[n3 + n5] = byArray[n3];
                    }
                    n3 = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
                    int n6 = (Integer)this.saveAreaDataTableOffsets.get(SAVE_AREA_TEMPLATE_VERSION);
                    int n7 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n6, n7 - n6);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, n3, (short)8);
                    int n8 = (Integer)this.saveAreaDataTableOffsets.get(GLOBAL_TIMESTAMP);
                    FspCecTime fspCecTime = this._cecMgr.getCmdHelper().getCecTimeOfDay(this._cecMgr.getCecName());
                    byte[] byArray2 = this.getTime(fspCecTime);
                    for (n2 = 0; n2 < 11; ++n2) {
                        this._nvramData[n8 + n2] = byArray2[n2];
                    }
                    n2 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
                    int n9 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n8, n2 - n8);
                    this._checksum = this._checksumCalc.getValue();
                    System.out.println("in setMACADDRPREFIX : timestampInfoChecksumOffset = " + n9);
                    System.out.println("in setMACADDRPREFIX: _checksum = " + this._checksum);
                    this.writeIntegralToNvramData(this._checksum, n9, (short)8);
                    this._nvramTimestamp = (byte[])byArray2.clone();
                    this._backupToLocalFile();
                    byte[] byArray3 = new byte[8];
                    System.arraycopy(this._nvramData, n3, byArray3, 0, 8);
                    this._writeDataToFSP(byArray3, n3, 8);
                    byArray3 = new byte[3];
                    System.arraycopy(this._nvramData, n5, byArray3, 0, 3);
                    this._writeDataToFSP(byArray3, n5, 3);
                    byArray3 = new byte[n2 - n9];
                    System.arraycopy(this._nvramData, n9, byArray3, 0, n2 - n9);
                    this._writeDataToFSP(byArray3, n9, n2 - n9);
                    if (DEBUG_ON) {
                        System.out.println("End of setVirtEthernetMacAddrPrefix");
                        System.out.println("****************************************");
                    }
                }
                catch (Throwable throwable) {
                    n = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0024", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var20_22 = null;
                if (!bl) break block17;
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSystemCredentialInfo() throws PIHscServerException {
        Vector<String> vector;
        block17: {
            int n = 128;
            boolean bl = false;
            try {
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In getSystemCredentialInfo");
                }
                Object object = this.saveAreaFileSyncObj;
                synchronized (object) {
                    while (this.isSaveAreaFileOpen) {
                        try {
                            if (DEBUG_ON) {
                                System.out.println("Waiting for file to close....");
                            }
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                    this.isSaveAreaFileOpen = true;
                }
                object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)1, (short)0, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                if (object == null) {
                    if (DEBUG_ON) {
                        System.out.println("in getSystemCredentialInfo: open file failed");
                    }
                    throw new PIHscServerException("004c", null);
                }
                bl = true;
                this.buildNVRAM(false, null, true, true, true);
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement(this._sysCredentialUserID);
                vector2.addElement(this._sysCredentialPassword);
                if (DEBUG_ON) {
                    System.out.println("sysCredentialUserID = " + this._sysCredentialUserID);
                    System.out.println("End of getSystemCredentialInfo");
                    System.out.println("****************************************");
                }
                vector = vector2;
                Object var7_9 = null;
                if (!bl) break block17;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("004f", throwable);
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    if (bl) {
                        this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                    }
                    this.isSaveAreaFileOpen = false;
                    throw throwable2;
                }
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSystemCredentialInfo(String string, String string2) throws PIHscServerException {
        block24: {
            int n = 1;
            boolean bl = false;
            try {
                try {
                    int n2;
                    int n3;
                    int n4;
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setSystemCredentialInfo");
                        System.out.println("sysCredentialUserID = " + string);
                    }
                    Object var5_5 = null;
                    Object var6_7 = null;
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    int n5 = (Integer)this.saveAreaDataTableOffsets.get(LAST_MODIFIED_PARTITION_TABLE_TIMESTAMP);
                    FspFileOpenResponse fspFileOpenResponse = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, n5);
                    if (fspFileOpenResponse == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in setSystemCredentialInfo: open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this.buildNVRAM(false, null, true, true, false);
                    this._sysCredentialUserID = string;
                    this._sysCredentialPassword = string2;
                    byte[] byArray = null;
                    byte[] byArray2 = null;
                    if (string == null) {
                        byArray = new byte[8];
                        System.out.println("NULL User ID in setSystemCredentialInfo");
                    } else {
                        n4 = string.length();
                        if (n4 != 8) {
                            string = this.setLength(string, 8);
                        }
                        byArray = string.getBytes();
                    }
                    if (string2 == null) {
                        byArray2 = new byte[16];
                        System.out.println("NULL Password in setSystemCredentialInfo");
                    } else {
                        n4 = string2.length();
                        if (n4 != 16) {
                            string2 = this.setLength(string2, 16);
                        }
                        byArray2 = string2.getBytes();
                    }
                    n4 = (Integer)this.saveAreaDataTableOffsets.get(SYS_CREDENTIAL_USER_ID);
                    int n6 = (Integer)this.saveAreaDataTableOffsets.get(SYS_CREDENTIAL_PASSWORD);
                    for (n3 = 0; n3 < 8; ++n3) {
                        this._nvramData[n3 + n4] = byArray[n3];
                    }
                    for (n3 = 0; n3 < 16; ++n3) {
                        this._nvramData[n3 + n6] = byArray2[n3];
                    }
                    n3 = (Integer)this.saveAreaDataTableOffsets.get(BASIC_INFO_CHECKSUM);
                    int n7 = (Integer)this.saveAreaDataTableOffsets.get(SAVE_AREA_TEMPLATE_VERSION);
                    int n8 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n7, n8 - n7);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, n3, (short)8);
                    int n9 = (Integer)this.saveAreaDataTableOffsets.get(GLOBAL_TIMESTAMP);
                    FspCecTime fspCecTime = this._cecMgr.getCmdHelper().getCecTimeOfDay(this._cecMgr.getCecName());
                    byte[] byArray3 = this.getTime(fspCecTime);
                    for (n2 = 0; n2 < 11; ++n2) {
                        this._nvramData[n9 + n2] = byArray3[n2];
                    }
                    n2 = (Integer)this.saveAreaDataTableOffsets.get(PARTITION_TABLE_CHECKSUM);
                    int n10 = (Integer)this.saveAreaDataTableOffsets.get(TIMESTAMP_INFO_CHECKSUM);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, n9, n2 - n9);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, n10, (short)8);
                    this._nvramTimestamp = (byte[])byArray3.clone();
                    this._backupToLocalFile();
                    byte[] byArray4 = new byte[8];
                    System.arraycopy(this._nvramData, n3, byArray4, 0, 8);
                    this._writeDataToFSP(byArray4, n3, 8);
                    byArray4 = new byte[8];
                    System.arraycopy(this._nvramData, n4, byArray4, 0, 8);
                    this._writeDataToFSP(byArray4, n4, 8);
                    byArray4 = new byte[16];
                    System.arraycopy(this._nvramData, n6, byArray4, 0, 16);
                    this._writeDataToFSP(byArray4, n6, 16);
                    byArray4 = new byte[n2 - n10];
                    System.arraycopy(this._nvramData, n10, byArray4, 0, n2 - n10);
                    this._writeDataToFSP(byArray4, n10, n2 - n10);
                    if (DEBUG_ON) {
                        System.out.println("End of setSystemCredentialInfo");
                        System.out.println("****************************************");
                    }
                }
                catch (Throwable throwable) {
                    n = 255;
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0050", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var23_25 = null;
                if (!bl) break block24;
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                }
                this.isSaveAreaFileOpen = false;
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearAll() throws PIHscServerException {
        block14: {
            int n = 1;
            boolean bl = false;
            try {
                try {
                    this.NVRAM_SIZE = (int)this._cecMgr.getCmdHelper().getFileSize(7, 0L);
                    Object object = this.saveAreaFileSyncObj;
                    synchronized (object) {
                        while (this.isSaveAreaFileOpen) {
                            try {
                                if (DEBUG_ON) {
                                    System.out.println("Waiting for file to close....");
                                }
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                        this.isSaveAreaFileOpen = true;
                    }
                    object = this._cecMgr.getCmdHelper().openFile(7, 0L, (short)2, (short)1, this.HMC_SAVE_AREA_BEGINNING_OFFSET, this.NVRAM_SIZE);
                    if (object == null) {
                        if (!DEBUG_ON) throw new PIHscServerException("004c", null);
                        System.out.println("in PIHMCSaveArea zeroOut(): open file failed");
                        throw new PIHscServerException("004c", null);
                    }
                    bl = true;
                    this._writeDataToFSP(new byte[12], 0, 12);
                    if (DEBUG_ON) {
                        System.out.println("successful initialize ");
                    }
                }
                catch (Throwable throwable) {
                    n = 255;
                    throwable.printStackTrace();
                    if (!(throwable instanceof PIHscServerException)) throw new PIHscServerException("0030", throwable);
                    throw (PIHscServerException)throwable;
                }
                Object var7_6 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (bl) {
                    this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
                }
                this.isSaveAreaFileOpen = false;
                if (!DEBUG_ON) throw throwable;
                System.out.println("End of NVRAM initialize");
                System.out.println("*******************************************");
                System.out.println();
                throw throwable;
            }
            this._cecMgr.getCmdHelper().closeFile(7, 0L, n);
        }
        this.isSaveAreaFileOpen = false;
        if (!DEBUG_ON) return;
        System.out.println("End of NVRAM initialize");
        System.out.println("*******************************************");
        System.out.println();
    }

    public int getPartitionOsType(int n) {
        return this._partitionOSTypeTable[n - 1];
    }

    public byte getFSPTemplateVersion(String string) {
        System.out.println("in getFSPTemplateVersion");
        System.out.println("fspVersion = " + string);
        Enumeration enumeration = FSP_HMC_VERSIONS.elements();
        while (enumeration.hasMoreElements()) {
            FSPVersionObject fSPVersionObject = (FSPVersionObject)enumeration.nextElement();
            if (!fSPVersionObject.fspVersion.equals(string)) continue;
            System.out.println("Found an HMC template version associated with the FSP version");
            System.out.println("template version = " + fSPVersionObject.hmcTemplateVersion);
            return fSPVersionObject.hmcTemplateVersion;
        }
        return 0;
    }

    static {
        FSP_VERSIONS.add("F3.0");
        FSP_VERSIONS.add("F3.1");
        FSP_VERSIONS.add("00030000");
        FSP_VERSIONS.add("00030010");
        FSP_VERSIONS.add("00030020");
        FSP_VERSIONS.add("00040000");
        FSP_VERSIONS.add("00040020");
        FSPVersionObject fSPVersionObject = new FSPVersionObject("F3.0", new Byte(0));
        FSPVersionObject fSPVersionObject2 = new FSPVersionObject("F3.1", new Byte(0));
        FSPVersionObject fSPVersionObject3 = new FSPVersionObject("00030000", new Byte(0));
        FSPVersionObject fSPVersionObject4 = new FSPVersionObject("00030010", new Byte(0));
        FSPVersionObject fSPVersionObject5 = new FSPVersionObject("00030020", new Byte(0));
        FSPVersionObject fSPVersionObject6 = new FSPVersionObject("00040000", new Byte(0));
        FSPVersionObject fSPVersionObject7 = new FSPVersionObject("00040020", new Byte(0));
        FSP_HMC_VERSIONS.add(fSPVersionObject);
        FSP_HMC_VERSIONS.add(fSPVersionObject2);
        FSP_HMC_VERSIONS.add(fSPVersionObject3);
        FSP_HMC_VERSIONS.add(fSPVersionObject4);
        FSP_HMC_VERSIONS.add(fSPVersionObject5);
        FSP_HMC_VERSIONS.add(fSPVersionObject6);
        FSP_HMC_VERSIONS.add(fSPVersionObject7);
        NVRAM_VERSIONS.add(new Byte(0));
        NVRAM_VERSIONS.add(new Byte(0));
        NVRAM_VERSIONS.add(new Byte(0));
        NVRAM_VERSIONS.add(new Byte(0));
        NVRAM_VERSIONS.add(new Byte(0));
        NVRAM_VERSIONS.add(new Byte(0));
        NVRAM_VERSIONS.add(new Byte(0));
        HMC_TEMPLATE_VERSIONS.add(new Byte(0));
        HMC_TEMPLATE_VERSIONS.add(new Byte(1));
        HMC_TEMPLATE_VERSIONS.add(new Byte(2));
        HMC_PROFILE_TEMPLATE_VERSIONS.add(new Byte(0));
        HMC_PROFILE_TEMPLATE_VERSIONS.add(new Byte(0));
        HMC_PROFILE_TEMPLATE_VERSIONS.add(new Byte(0));
        HMC_PROFILE_TEMPLATE_VERSIONS.add(new Byte(0));
        HMC_PROFILE_TEMPLATE_VERSIONS.add(new Byte(0));
        HMC_PROFILE_TEMPLATE_VERSIONS.add(new Byte(0));
        HMC_PROFILE_TEMPLATE_VERSIONS.add(new Byte(0));
        FIRST_RELEASE_SECTIONS = new Vector();
        CURRENT_RELEASE_SECTIONS = new Vector();
        FIRST_RELEASE_SECTIONS.add(new Byte(0));
        FIRST_RELEASE_SECTIONS.add(new Byte(1));
        FIRST_RELEASE_SECTIONS.add(new Byte(2));
        FIRST_RELEASE_SECTIONS.add(new Byte(3));
        FIRST_RELEASE_SECTIONS.add(new Byte(4));
        FIRST_RELEASE_SECTIONS.add(new Byte(5));
        CURRENT_RELEASE_SECTIONS.add(new Byte(0));
        CURRENT_RELEASE_SECTIONS.add(new Byte(1));
        CURRENT_RELEASE_SECTIONS.add(new Byte(2));
        CURRENT_RELEASE_SECTIONS.add(new Byte(3));
        CURRENT_RELEASE_SECTIONS.add(new Byte(4));
        CURRENT_RELEASE_SECTIONS.add(new Byte(5));
        DEBUG_ON = true;
        callingReg = new Vector();
    }

    public static class FSPVersionObject {
        public String fspVersion = null;
        public Byte hmcTemplateVersion = null;

        public FSPVersionObject(String string, Byte by) {
            this.fspVersion = string;
            this.hmcTemplateVersion = by;
        }

        public String toString() {
            String string = "fspVersion = ";
            String string2 = "hmcTemplateVersion = ";
            if (null != this.fspVersion) {
                string = string + this.fspVersion;
            }
            if (null != this.hmcTemplateVersion) {
                string2 = string2 + this.hmcTemplateVersion;
            }
            return string + "; " + string2 + "\n";
        }
    }
}

